/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.metrics.java;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4mp.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4mp.commons.codeaction.MicroProfileCodeActionId;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4mp.jdt.core.java.corrections.proposal.ReplaceAnnotationProposal;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class ApplicationScopedAnnotationMissingQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(ApplicationScopedAnnotationMissingQuickFix.class.getName());
    private static final String[] REMOVE_ANNOTATION_NAMES = new String[]{"RequestScoped", "SessionScoped", "Dependent"};
    private static final String[] ADD_ANNOTATIONS = new String[]{"jakarta.enterprise.context.ApplicationScoped", "javax.enterprise.context.ApplicationScoped"};

    @Override
    public String getParticipantId() {
        return ApplicationScopedAnnotationMissingQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        String addAnnotation = this.getAddAnnotation(context);
        ExtendedCodeAction codeAction = new ExtendedCodeAction(ApplicationScopedAnnotationMissingQuickFix.getLabel(addAnnotation));
        codeAction.setRelevance(0);
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), null, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), MicroProfileCodeActionId.InsertApplicationScopedAnnotation));
        return Collections.singletonList(codeAction);
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        String addAnnotation = this.getAddAnnotation(context);
        CodeAction toResolve = context.getUnresolved();
        String name = ApplicationScopedAnnotationMissingQuickFix.getLabel(addAnnotation);
        ASTNode node = context.getCoveringNode();
        IBinding parentType = this.getBinding(node);
        ReplaceAnnotationProposal proposal = new ReplaceAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, addAnnotation, REMOVE_ANNOTATION_NAMES);
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Failed to create workspace edit to replace bean scope annotation", e);
        }
        return toResolve;
    }

    private String getAddAnnotation(JavaCodeActionContext context) {
        String[] stringArray = ADD_ANNOTATIONS;
        int n = ADD_ANNOTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String annotation = stringArray[n2];
            if (JDTTypeUtils.findType(context.getJavaProject(), annotation) != null) {
                return annotation;
            }
            ++n2;
        }
        return "jakarta.enterprise.context.ApplicationScoped";
    }

    private IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    private static String getLabel(String annotation) {
        StringBuilder name = new StringBuilder("Replace current scope with ");
        String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
        name.append("@");
        name.append(annotationName);
        return name.toString();
    }
}

