/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.config.java;

import com.google.gson.JsonObject;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.utils.AntPathMatcher;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProject;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.internal.config.java.MicroProfileConfigErrorCode;
import org.eclipse.lsp4mp.jdt.internal.config.properties.MicroProfileConfigPropertyProvider;

public class MicroProfileConfigASTValidator
extends JavaASTValidator {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileConfigASTValidator.class.getName());
    private static final AntPathMatcher pathMatcher = new AntPathMatcher();
    private static final String EXPECTED_TYPE_ERROR_MESSAGE = "''{0}'' does not match the expected type of ''{1}''.";
    private static final String NO_VALUE_ERROR_MESSAGE = "The property ''{0}'' is not assigned a value in any config file, and must be assigned at runtime.";
    private static final String EMPTY_KEY_ERROR_MESSAGE = "The member ''{0}'' can'''t be empty.";
    private List<String> patterns;
    private String currentPrefix;

    @Override
    public void initialize(JavaDiagnosticsContext context, List<Diagnostic> diagnostics) {
        super.initialize(context, diagnostics);
        this.currentPrefix = null;
        this.patterns = MicroProfileConfigASTValidator.getPatternsFromContext(context);
    }

    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.config.inject.ConfigProperty") != null;
    }

    private static List<String> getPatternsFromContext(JavaDiagnosticsContext context) {
        return context.getSettings().getPatterns();
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        List modifiers = typeDeclaration.modifiers();
        for (Object modifier : modifiers) {
            if (!(modifier instanceof NormalAnnotation) || !AnnotationUtils.isMatchAnnotation((Annotation)((NormalAnnotation)modifier), "org.eclipse.microprofile.config.inject.ConfigProperties") && !AnnotationUtils.isMatchAnnotation((Annotation)((NormalAnnotation)modifier), "io.quarkus.arc.config.ConfigProperties")) continue;
            try {
                Expression prefixExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)((NormalAnnotation)modifier), "prefix");
                if (prefixExpr == null) continue;
                this.currentPrefix = ((StringLiteral)prefixExpr).getLiteralValue();
            }
            catch (JavaModelException e) {
                LOGGER.log(Level.WARNING, "Exception when trying to get prefix of a @ConfigProperties annotation", e);
            }
        }
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.currentPrefix = null;
        super.endVisit(node);
    }

    public boolean visit(NormalAnnotation annotation) {
        if (AnnotationUtils.isMatchAnnotation((Annotation)annotation, "org.eclipse.microprofile.config.inject.ConfigProperty") && annotation.getParent() instanceof FieldDeclaration) {
            try {
                Expression defaultValueExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "defaultValue");
                this.validatePropertyDefaultValue((Annotation)annotation, defaultValueExpr);
                this.validatePropertyHasValue((Annotation)annotation, defaultValueExpr);
            }
            catch (JavaModelException e) {
                LOGGER.log(Level.WARNING, "Exception when trying to get defaultValue of a @ConfigProperty annotation while calculating diagnostics for it", e);
            }
        }
        return false;
    }

    private void validatePropertyDefaultValue(Annotation annotation, Expression defaultValueExpr) {
        FieldDeclaration fieldDeclaration = (FieldDeclaration)annotation.getParent();
        IJavaProject javaProject = this.getContext().getJavaProject();
        if (defaultValueExpr != null) {
            String defValue = defaultValueExpr instanceof StringLiteral ? ((StringLiteral)defaultValueExpr).getLiteralValue() : null;
            ITypeBinding fieldBinding = fieldDeclaration.getType().resolveBinding();
            if (fieldBinding != null && defValue != null && !MicroProfileConfigASTValidator.isAssignable(fieldBinding, javaProject, defValue)) {
                String message = MessageFormat.format(EXPECTED_TYPE_ERROR_MESSAGE, defValue, fieldBinding.getName());
                super.addDiagnostic(message, "microprofile-config", (ASTNode)defaultValueExpr, MicroProfileConfigErrorCode.DEFAULT_VALUE_IS_WRONG_TYPE, DiagnosticSeverity.Error);
            }
        }
    }

    private void validatePropertyHasValue(Annotation annotation, Expression defaultValueExpr) {
        try {
            boolean hasDefaultValue;
            String name = null;
            Expression nameExpression = AnnotationUtils.getAnnotationMemberValueExpression(annotation, "name");
            boolean bl = hasDefaultValue = defaultValueExpr != null;
            if (nameExpression != null) {
                name = ((StringLiteral)nameExpression).getLiteralValue();
                name = MicroProfileConfigPropertyProvider.getPropertyName(name, this.currentPrefix);
            }
            if (name != null) {
                if (name.isEmpty()) {
                    String message = MessageFormat.format(EMPTY_KEY_ERROR_MESSAGE, "name");
                    super.addDiagnostic(message, "microprofile-config", (ASTNode)nameExpression, MicroProfileConfigErrorCode.EMPTY_KEY, DiagnosticSeverity.Error);
                } else if (!(hasDefaultValue || MicroProfileConfigASTValidator.doesPropertyHaveValue(name, this.getContext()) || this.isPropertyIgnored(name))) {
                    String message = MessageFormat.format(NO_VALUE_ERROR_MESSAGE, name);
                    Diagnostic d = super.addDiagnostic(message, "microprofile-config", (ASTNode)nameExpression, MicroProfileConfigErrorCode.NO_VALUE_ASSIGNED_TO_PROPERTY, DiagnosticSeverity.Warning);
                    MicroProfileConfigASTValidator.setDataForUnassigned(name, d);
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.WARNING, "Exception while calculating diagnostics for @ConfigProperty (property has value)", e);
        }
    }

    private boolean isPropertyIgnored(String propertyName) {
        for (String pattern : this.patterns) {
            if (!pathMatcher.match(pattern, propertyName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignable(ITypeBinding fieldBinding, IJavaProject javaProject, String defValue) {
        String fqn = Signature.getTypeErasure((String)fieldBinding.getQualifiedName());
        try {
            switch (fqn) {
                case "boolean": 
                case "java.lang.Boolean": {
                    return Boolean.valueOf(defValue) != null;
                }
                case "byte": 
                case "java.lang.Byte": {
                    return Byte.valueOf(defValue) != null;
                }
                case "java.lang.Short": 
                case "short": {
                    return Short.valueOf(defValue) != null;
                }
                case "java.lang.Integer": 
                case "int": {
                    return Integer.valueOf(defValue) != null;
                }
                case "long": 
                case "java.lang.Long": {
                    return Long.valueOf(defValue) != null;
                }
                case "java.lang.Float": 
                case "float": {
                    return Float.valueOf(defValue) != null;
                }
                case "double": 
                case "java.lang.Double": {
                    return Double.valueOf(defValue) != null;
                }
                case "char": 
                case "java.lang.Character": {
                    return Character.valueOf(defValue.charAt(0)) != null;
                }
                case "java.lang.Class": {
                    return JDTTypeUtils.findType(javaProject, defValue) != null;
                }
                case "java.lang.String": {
                    return true;
                }
            }
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean doesPropertyHaveValue(String property, JavaDiagnosticsContext context) {
        IJavaProject javaProject = context.getJavaProject();
        try {
            JDTMicroProfileProject mpProject = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(javaProject);
            return mpProject.hasProperty(property);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "@ConfigProperty validation attempted in a non MicroProfile project", e);
            return false;
        }
    }

    public static void setDataForUnassigned(String name, Diagnostic diagnostic) {
        JsonObject data = new JsonObject();
        data.addProperty("name", name);
        diagnostic.setData((Object)data);
    }
}

