/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.restclient.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.Assert;
import org.junit.Test;

public class MicroProfileRestClientJavaCodeLensTest
extends BasePropertiesManagerTest {
    @Test
    public void urlCodeLensProperties() throws Exception {
        IJavaProject javaProject = MicroProfileRestClientJavaCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.rest_client_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileRestClientJavaCodeLensTest.initConfigFile(javaProject);
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/restclient/CountriesService.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        List lenses = PropertiesManagerForJava.getInstance().codeLens(params, utils, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)lenses.size());
        MicroProfileRestClientJavaCodeLensTest.saveFile("META-INF/microprofile-config.properties", "org.acme.restclient.CountriesService/mp-rest/url = https://restcountries.url/rest", javaProject);
        MicroProfileRestClientJavaCodeLensTest.assertCodeLenses("https://restcountries.url/rest", params, utils);
        MicroProfileRestClientJavaCodeLensTest.saveFile("META-INF/microprofile-config.properties", "org.acme.restclient.CountriesService/mp-rest/uri = https://restcountries.uri/rest" + System.lineSeparator() + "org.acme.restclient.CountriesService/mp-rest/url = https://restcountries.url/rest", javaProject);
        MicroProfileRestClientJavaCodeLensTest.assertCodeLenses("https://restcountries.uri/rest", params, utils);
    }

    private static void initConfigFile(IJavaProject javaProject) throws Exception {
        MicroProfileRestClientJavaCodeLensTest.saveFile("META-INF/microprofile-config.properties", "", javaProject);
    }

    @Test
    public void urlCodeLensPropertiesWithAnnotationBaseUri() throws Exception {
        IJavaProject javaProject = MicroProfileRestClientJavaCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.rest_client_quickstart);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileRestClientJavaCodeLensTest.initConfigFile(javaProject);
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/restclient/CountriesServiceWithBaseUri.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        MicroProfileRestClientJavaCodeLensTest.assertCodeLenses("https://restcountries.ann/rest", params, utils);
        MicroProfileRestClientJavaCodeLensTest.saveFile("META-INF/microprofile-config.properties", "org.acme.restclient.CountriesServiceWithBaseUri/mp-rest/url = https://restcountries.url/rest", javaProject);
        MicroProfileRestClientJavaCodeLensTest.assertCodeLenses("https://restcountries.url/rest", params, utils);
        MicroProfileRestClientJavaCodeLensTest.saveFile("META-INF/microprofile-config.properties", "org.acme.restclient.CountriesServiceWithBaseUri/mp-rest/uri = https://restcountries.uri/rest" + System.lineSeparator() + "org.acme.restclient.CountriesServiceWithBaseUri/mp-rest/url = https://restcountries.url/rest", javaProject);
        MicroProfileRestClientJavaCodeLensTest.assertCodeLenses("https://restcountries.uri/rest", params, utils);
    }

    private static void assertCodeLenses(String baseURL, MicroProfileJavaCodeLensParams params, IJDTUtils utils) throws JavaModelException {
        List lenses = PropertiesManagerForJava.getInstance().codeLens(params, utils, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)2L, (long)lenses.size());
        CodeLens lensForGet = (CodeLens)lenses.get(0);
        Assert.assertNotNull((Object)lensForGet.getCommand());
        Assert.assertEquals((Object)(String.valueOf(baseURL) + "/v2/name/{name}"), (Object)lensForGet.getCommand().getTitle());
        CodeLens lensForGetSingle = (CodeLens)lenses.get(1);
        Assert.assertNotNull((Object)lensForGetSingle.getCommand());
        Assert.assertEquals((Object)(String.valueOf(baseURL) + "/v2/name/{name}"), (Object)lensForGetSingle.getCommand().getTitle());
    }
}

