/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.reactivemessaging.properties;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileAssert;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.reactivemessaging.java.MicroProfileReactiveMessagingErrorCode;
import org.junit.Test;

public class MicroProfileReactiveMessagingTest
extends BasePropertiesManagerTest {
    @Test
    public void microprofileReactiveMessagingPropertiesTest() throws Exception {
        MicroProfileProjectInfo infoFromClasspath = MicroProfileReactiveMessagingTest.getMicroProfileProjectInfoFromMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_reactive_messaging, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        MicroProfileAssert.assertProperties(infoFromClasspath, MicroProfileAssert.p(null, "mp.messaging.incoming.prices.connector", "org.eclipse.microprofile.reactive.messaging.spi.Connector", null, false, "org.acme.kafka.PriceConverter", null, "process(I)D", 0, null), MicroProfileAssert.p(null, "mp.messaging.outgoing.my-data-stream.connector", "org.eclipse.microprofile.reactive.messaging.spi.Connector", null, false, "org.acme.kafka.PriceConverter", null, "process(I)D", 0, null), MicroProfileAssert.p(null, "mp.messaging.outgoing.price-create.connector", "org.eclipse.microprofile.reactive.messaging.spi.Connector", null, false, "org.acme.kafka.PriceResource", "priceEmitter", null, 0, null), MicroProfileAssert.p(null, "mp.messaging.incoming.${smallrye-kafka}.topic", "java.lang.String", "The consumed / populated Kafka topic. If not set, the channel name is used", true, "io.smallrye.reactive.messaging.kafka.KafkaConnector", null, null, 0, null), MicroProfileAssert.p(null, "mp.messaging.outgoing.${smallrye-kafka}.topic", "java.lang.String", "The consumed / populated Kafka topic. If not set, the channel name is used", true, "io.smallrye.reactive.messaging.kafka.KafkaConnector", null, null, 0, null), MicroProfileAssert.p(null, "mp.messaging.incoming.${smallrye-kafka}.bootstrap.servers", "java.lang.String", "A comma-separated list of host:port to use for establishing the initial connection to the Kafka cluster.", true, "io.smallrye.reactive.messaging.kafka.KafkaConnector", null, null, 0, "localhost:9092"), MicroProfileAssert.p(null, "mp.messaging.outgoing.quotes.connector", "org.eclipse.microprofile.reactive.messaging.spi.Connector", null, false, "org.acme.kafka.QuoteResource", "quotes", null, 0, null));
        MicroProfileAssert.assertPropertiesDuplicate(infoFromClasspath);
        MicroProfileAssert.assertHints(infoFromClasspath, MicroProfileAssert.h("${mp.messaging.connector.binary}", null, true, null, MicroProfileAssert.vh("smallrye-kafka", null, "io.smallrye.reactive.messaging.kafka.KafkaConnector")));
        MicroProfileAssert.assertHintsDuplicate(infoFromClasspath);
    }

    @Test
    public void blankAnnotation() throws Exception {
        IJavaProject javaProject = MicroProfileReactiveMessagingTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_reactive_messaging);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/kafka/PriceConverter.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d1 = MicroProfileForJavaAssert.d(24, 14, 16, "The name of the consumed channel must not be blank.", DiagnosticSeverity.Error, "microprofile-reactive-messaging", (IJavaErrorCode)MicroProfileReactiveMessagingErrorCode.BLANK_CHANNEL_NAME);
        Diagnostic d2 = MicroProfileForJavaAssert.d(25, 20, 22, "The name of the consumed channel must not be blank.", DiagnosticSeverity.Error, "microprofile-reactive-messaging", (IJavaErrorCode)MicroProfileReactiveMessagingErrorCode.BLANK_CHANNEL_NAME);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2);
    }
}

