/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.internal.core.DocumentAdapter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public class JsonRpcHelpers {
    public static int toOffset(IBuffer buffer, int line, int column) {
        if (buffer != null) {
            return JsonRpcHelpers.toOffset(JsonRpcHelpers.toDocument(buffer), line, column);
        }
        return -1;
    }

    public static int toOffset(IDocument document, int line, int column) {
        try {
            return document.getLineOffset(line) + column;
        }
        catch (BadLocationException e) {
            JakartaCorePlugin.logException(e.getMessage(), e);
            return -1;
        }
    }

    public static int[] toLine(IBuffer buffer, int offset) {
        return JsonRpcHelpers.toLine(JsonRpcHelpers.toDocument(buffer), offset);
    }

    public static int[] toLine(IDocument document, int offset) {
        try {
            int line = document.getLineOfOffset(offset);
            int column = offset - document.getLineOffset(line);
            return new int[]{line, column};
        }
        catch (BadLocationException e) {
            JakartaCorePlugin.logException(e.getMessage(), e);
            return null;
        }
    }

    public static IDocument toDocument(IBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer instanceof IDocument) {
            return (IDocument)buffer;
        }
        return new DocumentAdapter(buffer);
    }
}

