/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.cdi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IType;
import org.eclipse.lsp4jakarta.jdt.internal.cdi.Constants;

public class Utils {
    static boolean isManagedBean(IType type) {
        return Utils.getScopeAnnotations((IAnnotatable)type, Constants.SCOPES).size() > 0;
    }

    public static List<String> getScopeAnnotations(IAnnotatable type, Set<String> scopes) {
        try {
            return Arrays.stream(type.getAnnotations()).map(annotation -> annotation.getElementName()).filter(scopes::contains).distinct().collect(Collectors.toList());
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }
}

