/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction.proposal.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.ModifyAnnotationProposal;

public class InsertAnnotationQuickFix
implements IJavaCodeActionParticipant {
    private final String[] attributes;
    private final String annotation;
    protected final boolean generateOnlyOneCodeAction;

    public InsertAnnotationQuickFix(String annotation, String ... attributes) {
        this(annotation, false, attributes);
    }

    public InsertAnnotationQuickFix(String annotation, boolean generateOnlyOneCodeAction, String ... attributes) {
        this.annotation = annotation;
        this.generateOnlyOneCodeAction = generateOnlyOneCodeAction;
        this.attributes = attributes;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        this.addAttributes(diagnostic, context, parentType, codeActions, this.annotation);
        return codeActions;
    }

    protected void addAttributes(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, String annotation) throws CoreException {
        if (this.generateOnlyOneCodeAction) {
            this.addAttribute(diagnostic, context, parentType, codeActions, annotation, this.attributes);
        } else {
            String[] stringArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                this.addAttribute(diagnostic, context, parentType, codeActions, annotation, attribute);
                ++n2;
            }
        }
    }

    private void addAttribute(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, String annotation, String ... attributes) throws CoreException {
        context.getCoveredNode().getParent();
        String name = this.getLabel(annotation, attributes);
        ModifyAnnotationProposal proposal = new ModifyAnnotationProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, annotation, Arrays.asList(attributes));
        CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
    }

    protected IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)node.getParent()).resolveBinding();
        }
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    protected String getLabel(String annotation, String ... attributes) {
        StringBuilder name = new StringBuilder("Insert ");
        name.append("@");
        name.append(annotation);
        return name.toString();
    }
}

