/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction.proposal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.ChangeCorrectionProposal;

public class ModifyModifiersProposal
extends ChangeCorrectionProposal {
    private final CompilationUnit invocationNode;
    private final IBinding binding;
    private final ASTNode coveredNode;
    private final List<String> modifiersToAdd;
    private final List<String> modifiersToRemove;

    public ModifyModifiersProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, ASTNode coveredNode, List<String> modifiersToAdd, List<String> modifiersToRemove) {
        super(label, "quickfix", targetCU, null, relevance);
        this.invocationNode = invocationNode;
        this.binding = binding;
        this.coveredNode = coveredNode;
        this.modifiersToAdd = modifiersToAdd;
        this.modifiersToRemove = modifiersToRemove;
    }

    public ModifyModifiersProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, ASTNode coveredNode, List<String> modifiersToAdd) {
        super(label, "quickfix", targetCU, null, relevance);
        this.invocationNode = invocationNode;
        this.binding = binding;
        this.coveredNode = coveredNode;
        this.modifiersToAdd = modifiersToAdd;
        this.modifiersToRemove = new ArrayList<String>();
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        boolean isField;
        ASTNode declNode = null;
        ASTNode boundNode = this.invocationNode.findDeclaringNode(this.binding);
        CompilationUnit newRoot = this.invocationNode;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.binding.getKey());
        }
        if (this.coveredNode != null) {
            declNode = this.coveredNode;
        }
        if (isField = declNode instanceof VariableDeclarationFragment) {
            declNode = declNode.getParent();
        }
        AST ast = declNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ListRewrite modifiersList = null;
        List modifiers = new ArrayList();
        switch (declNode.getNodeType()) {
            case 31: {
                modifiersList = rewrite.getListRewrite(declNode, MethodDeclaration.MODIFIERS2_PROPERTY);
                modifiers = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.MODIFIERS2_PROPERTY);
                break;
            }
            case 23: {
                modifiersList = rewrite.getListRewrite(declNode, FieldDeclaration.MODIFIERS2_PROPERTY);
                modifiers = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS2_PROPERTY);
                break;
            }
            case 55: {
                modifiersList = rewrite.getListRewrite(declNode, TypeDeclaration.MODIFIERS2_PROPERTY);
                modifiers = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS2_PROPERTY);
                break;
            }
            case 44: {
                modifiersList = rewrite.getListRewrite(declNode, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
                modifiers = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)SingleVariableDeclaration.MODIFIERS2_PROPERTY);
                break;
            }
            default: {
                modifiersList = null;
            }
        }
        for (ASTNode modifier : modifiers) {
            if (modifier instanceof MarkerAnnotation) {
                MarkerAnnotation markAnno = (MarkerAnnotation)modifier;
                Name markAnnoTypeName = markAnno.getTypeName();
                if (!this.modifiersToRemove.stream().anyMatch(m -> m.equals(markAnnoTypeName.toString()))) continue;
                modifiersList.remove((ASTNode)markAnno, null);
                continue;
            }
            if (!(modifier instanceof Modifier)) continue;
            Modifier.ModifierKeyword modKeyword = ((Modifier)modifier).getKeyword();
            if (this.modifiersToRemove.stream().anyMatch(m -> m.equals(modKeyword.toString()))) {
                modifiersList.remove(modifier, null);
                continue;
            }
            if (!modKeyword.equals(Modifier.ModifierKeyword.PRIVATE_KEYWORD) && !modKeyword.equals(Modifier.ModifierKeyword.PUBLIC_KEYWORD) && !modKeyword.equals(Modifier.ModifierKeyword.PROTECTED_KEYWORD) || !this.modifiersToAdd.stream().anyMatch(m -> m.equals(Modifier.ModifierKeyword.PRIVATE_KEYWORD.toString()) || m.equals(Modifier.ModifierKeyword.PUBLIC_KEYWORD.toString()) || m.equals(Modifier.ModifierKeyword.PROTECTED_KEYWORD.toString()))) continue;
            modifiersList.remove(modifier, null);
        }
        for (String newModifier : this.modifiersToAdd) {
            Modifier marker = ast.newModifier(Modifier.ModifierKeyword.toKeyword((String)newModifier));
            modifiersList.insertLast((ASTNode)marker, null);
        }
        return rewrite;
    }
}

