/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public abstract class AbstractLSPCodeMiningProvider
extends AbstractCodeMiningProvider {
    private final ConcurrentMap<IDocument, CompletableFuture<List<? extends ICodeMining>>> pendingRequests = new ConcurrentHashMap<IDocument, CompletableFuture<List<? extends ICodeMining>>>();

    protected abstract @Nullable CompletableFuture<List<? extends ICodeMining>> doProvideCodeMinings(IDocument var1, TextDocumentIdentifier var2);

    public final @Nullable CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        IDocument document = viewer.getDocument();
        if (document == null) {
            return null;
        }
        URI docURI = LSPEclipseUtils.toUri(document);
        if (docURI == null) {
            return null;
        }
        TextDocumentIdentifier docId = LSPEclipseUtils.toTextDocumentIdentifier(docURI);
        CompletableFuture<List<? extends ICodeMining>> current = this.doProvideCodeMinings(document, docId);
        CompletableFuture<List<? extends ICodeMining>> previous = current == null ? (CompletableFuture<List<? extends ICodeMining>>)this.pendingRequests.remove(document) : this.pendingRequests.put(document, current);
        if (previous != null && !previous.isDone()) {
            previous.cancel(true);
        }
        return current;
    }
}

