/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public final class CancellationUtil {
    private CancellationUtil() {
    }

    public static boolean isRequestCancelledException(@Nullable Throwable throwable) {
        if (throwable instanceof CompletionException || throwable instanceof ExecutionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ResponseErrorException) {
            ResponseErrorException responseErrorException = (ResponseErrorException)throwable;
            return CancellationUtil.isRequestCancelled(responseErrorException);
        }
        return throwable instanceof CancellationException;
    }

    private static boolean isRequestCancelled(ResponseErrorException responseErrorException) {
        ResponseError responseError = responseErrorException.getResponseError();
        return responseError != null && responseError.getCode() == ResponseErrorCode.RequestCancelled.getValue();
    }
}

