/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
grammar InternalMachine;

options {
	superClass=AbstractInternalContentAssistParser;
}

@lexer::header {
package org.eclipse.lsat.machine.teditor.ide.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
}

@parser::header {
package org.eclipse.lsat.machine.teditor.ide.contentassist.antlr.internal;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.lsat.machine.teditor.services.MachineGrammarAccess;

}
@parser::members {
	private MachineGrammarAccess grammarAccess;

	public void setGrammarAccess(MachineGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		return tokenName;
	}
}

// Entry rule entryRuleMachine
entryRuleMachine
:
{ before(grammarAccess.getMachineRule()); }
	 ruleMachine
{ after(grammarAccess.getMachineRule()); } 
	 EOF 
;

// Rule Machine
ruleMachine 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMachineAccess().getGroup()); }
		(rule__Machine__Group__0)
		{ after(grammarAccess.getMachineAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleImport
entryRuleImport
:
{ before(grammarAccess.getImportRule()); }
	 ruleImport
{ after(grammarAccess.getImportRule()); } 
	 EOF 
;

// Rule Import
ruleImport 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getImportAccess().getGroup()); }
		(rule__Import__Group__0)
		{ after(grammarAccess.getImportAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePathAnnotation
entryRulePathAnnotation
:
{ before(grammarAccess.getPathAnnotationRule()); }
	 rulePathAnnotation
{ after(grammarAccess.getPathAnnotationRule()); } 
	 EOF 
;

// Rule PathAnnotation
rulePathAnnotation 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPathAnnotationAccess().getGroup()); }
		(rule__PathAnnotation__Group__0)
		{ after(grammarAccess.getPathAnnotationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePeripheralType
entryRulePeripheralType
:
{ before(grammarAccess.getPeripheralTypeRule()); }
	 rulePeripheralType
{ after(grammarAccess.getPeripheralTypeRule()); } 
	 EOF 
;

// Rule PeripheralType
rulePeripheralType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPeripheralTypeAccess().getGroup()); }
		(rule__PeripheralType__Group__0)
		{ after(grammarAccess.getPeripheralTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleActionType
entryRuleActionType
:
{ before(grammarAccess.getActionTypeRule()); }
	 ruleActionType
{ after(grammarAccess.getActionTypeRule()); } 
	 EOF 
;

// Rule ActionType
ruleActionType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getActionTypeAccess().getGroup()); }
		(rule__ActionType__Group__0)
		{ after(grammarAccess.getActionTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSetPoint
entryRuleSetPoint
:
{ before(grammarAccess.getSetPointRule()); }
	 ruleSetPoint
{ after(grammarAccess.getSetPointRule()); } 
	 EOF 
;

// Rule SetPoint
ruleSetPoint 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSetPointAccess().getGroup()); }
		(rule__SetPoint__Group__0)
		{ after(grammarAccess.getSetPointAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAxis
entryRuleAxis
:
{ before(grammarAccess.getAxisRule()); }
	 ruleAxis
{ after(grammarAccess.getAxisRule()); } 
	 EOF 
;

// Rule Axis
ruleAxis 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAxisAccess().getGroup()); }
		(rule__Axis__Group__0)
		{ after(grammarAccess.getAxisAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleResourceItem
entryRuleResourceItem
:
{ before(grammarAccess.getResourceItemRule()); }
	 ruleResourceItem
{ after(grammarAccess.getResourceItemRule()); } 
	 EOF 
;

// Rule ResourceItem
ruleResourceItem 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getResourceItemAccess().getGroup()); }
		(rule__ResourceItem__Group__0)
		{ after(grammarAccess.getResourceItemAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleResource
entryRuleResource
:
{ before(grammarAccess.getResourceRule()); }
	 ruleResource
{ after(grammarAccess.getResourceRule()); } 
	 EOF 
;

// Rule Resource
ruleResource 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getResourceAccess().getGroup()); }
		(rule__Resource__Group__0)
		{ after(grammarAccess.getResourceAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePeripheral
entryRulePeripheral
:
{ before(grammarAccess.getPeripheralRule()); }
	 rulePeripheral
{ after(grammarAccess.getPeripheralRule()); } 
	 EOF 
;

// Rule Peripheral
rulePeripheral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPeripheralAccess().getGroup()); }
		(rule__Peripheral__Group__0)
		{ after(grammarAccess.getPeripheralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDistance
entryRuleDistance
:
{ before(grammarAccess.getDistanceRule()); }
	 ruleDistance
{ after(grammarAccess.getDistanceRule()); } 
	 EOF 
;

// Rule Distance
ruleDistance 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDistanceAccess().getGroup()); }
		(rule__Distance__Group__0)
		{ after(grammarAccess.getDistanceAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAxisPositionsMapEntry
entryRuleAxisPositionsMapEntry
:
{ before(grammarAccess.getAxisPositionsMapEntryRule()); }
	 ruleAxisPositionsMapEntry
{ after(grammarAccess.getAxisPositionsMapEntryRule()); } 
	 EOF 
;

// Rule AxisPositionsMapEntry
ruleAxisPositionsMapEntry 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAxisPositionsMapEntryAccess().getGroup()); }
		(rule__AxisPositionsMapEntry__Group__0)
		{ after(grammarAccess.getAxisPositionsMapEntryAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePosition
entryRulePosition
:
{ before(grammarAccess.getPositionRule()); }
	 rulePosition
{ after(grammarAccess.getPositionRule()); } 
	 EOF 
;

// Rule Position
rulePosition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPositionAccess().getGroup()); }
		(rule__Position__Group__0)
		{ after(grammarAccess.getPositionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSymbolicPosition
entryRuleSymbolicPosition
:
{ before(grammarAccess.getSymbolicPositionRule()); }
	 ruleSymbolicPosition
{ after(grammarAccess.getSymbolicPositionRule()); } 
	 EOF 
;

// Rule SymbolicPosition
ruleSymbolicPosition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSymbolicPositionAccess().getGroup()); }
		(rule__SymbolicPosition__Group__0)
		{ after(grammarAccess.getSymbolicPositionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAxisPositionMapEntry
entryRuleAxisPositionMapEntry
:
{ before(grammarAccess.getAxisPositionMapEntryRule()); }
	 ruleAxisPositionMapEntry
{ after(grammarAccess.getAxisPositionMapEntryRule()); } 
	 EOF 
;

// Rule AxisPositionMapEntry
ruleAxisPositionMapEntry 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAxisPositionMapEntryAccess().getGroup()); }
		(rule__AxisPositionMapEntry__Group__0)
		{ after(grammarAccess.getAxisPositionMapEntryAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleProfile
entryRuleProfile
:
{ before(grammarAccess.getProfileRule()); }
	 ruleProfile
{ after(grammarAccess.getProfileRule()); } 
	 EOF 
;

// Rule Profile
ruleProfile 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getProfileAccess().getGroup()); }
		(rule__Profile__Group__0)
		{ after(grammarAccess.getProfileAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePath
entryRulePath
:
{ before(grammarAccess.getPathRule()); }
	 rulePath
{ after(grammarAccess.getPathRule()); } 
	 EOF 
;

// Rule Path
rulePath 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPathAccess().getAlternatives()); }
		(rule__Path__Alternatives)
		{ after(grammarAccess.getPathAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnidirectionalPath
entryRuleUnidirectionalPath
:
{ before(grammarAccess.getUnidirectionalPathRule()); }
	 ruleUnidirectionalPath
{ after(grammarAccess.getUnidirectionalPathRule()); } 
	 EOF 
;

// Rule UnidirectionalPath
ruleUnidirectionalPath 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getGroup()); }
		(rule__UnidirectionalPath__Group__0)
		{ after(grammarAccess.getUnidirectionalPathAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBidirectionalPath
entryRuleBidirectionalPath
:
{ before(grammarAccess.getBidirectionalPathRule()); }
	 ruleBidirectionalPath
{ after(grammarAccess.getBidirectionalPathRule()); } 
	 EOF 
;

// Rule BidirectionalPath
ruleBidirectionalPath 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getGroup()); }
		(rule__BidirectionalPath__Group__0)
		{ after(grammarAccess.getBidirectionalPathAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFullMeshPath
entryRuleFullMeshPath
:
{ before(grammarAccess.getFullMeshPathRule()); }
	 ruleFullMeshPath
{ after(grammarAccess.getFullMeshPathRule()); } 
	 EOF 
;

// Rule FullMeshPath
ruleFullMeshPath 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFullMeshPathAccess().getGroup()); }
		(rule__FullMeshPath__Group__0)
		{ after(grammarAccess.getFullMeshPathAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePathTargetReference
entryRulePathTargetReference
:
{ before(grammarAccess.getPathTargetReferenceRule()); }
	 rulePathTargetReference
{ after(grammarAccess.getPathTargetReferenceRule()); } 
	 EOF 
;

// Rule PathTargetReference
rulePathTargetReference 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPathTargetReferenceAccess().getGroup()); }
		(rule__PathTargetReference__Group__0)
		{ after(grammarAccess.getPathTargetReferenceAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIID
entryRuleIID
:
{ before(grammarAccess.getIIDRule()); }
	 ruleIID
{ after(grammarAccess.getIIDRule()); } 
	 EOF 
;

// Rule IID
ruleIID 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIIDAccess().getAlternatives()); }
		(rule__IID__Alternatives)
		{ after(grammarAccess.getIIDAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ResourceType
ruleResourceType
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getResourceTypeAccess().getAlternatives()); }
		(rule__ResourceType__Alternatives)
		{ after(grammarAccess.getResourceTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Alternatives_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineAccess().getPeripheralTypesAssignment_4_0()); }
		(rule__Machine__PeripheralTypesAssignment_4_0)
		{ after(grammarAccess.getMachineAccess().getPeripheralTypesAssignment_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineAccess().getResourcesAssignment_4_1()); }
		(rule__Machine__ResourcesAssignment_4_1)
		{ after(grammarAccess.getMachineAccess().getResourcesAssignment_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Path__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPathAccess().getUnidirectionalPathParserRuleCall_0()); }
		ruleUnidirectionalPath
		{ after(grammarAccess.getPathAccess().getUnidirectionalPathParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPathAccess().getBidirectionalPathParserRuleCall_1()); }
		ruleBidirectionalPath
		{ after(grammarAccess.getPathAccess().getBidirectionalPathParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPathAccess().getFullMeshPathParserRuleCall_2()); }
		ruleFullMeshPath
		{ after(grammarAccess.getPathAccess().getFullMeshPathParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Alternatives_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getGroup_4_0()); }
		(rule__UnidirectionalPath__Group_4_0__0)
		{ after(grammarAccess.getUnidirectionalPathAccess().getGroup_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getGroup_4_1()); }
		(rule__UnidirectionalPath__Group_4_1__0)
		{ after(grammarAccess.getUnidirectionalPathAccess().getGroup_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Alternatives_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getGroup_4_0()); }
		(rule__BidirectionalPath__Group_4_0__0)
		{ after(grammarAccess.getBidirectionalPathAccess().getGroup_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getGroup_4_1()); }
		(rule__BidirectionalPath__Group_4_1__0)
		{ after(grammarAccess.getBidirectionalPathAccess().getGroup_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFullMeshPathAccess().getGroup_3_0()); }
		(rule__FullMeshPath__Group_3_0__0)
		{ after(grammarAccess.getFullMeshPathAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getFullMeshPathAccess().getGroup_3_1()); }
		(rule__FullMeshPath__Group_3_1__0)
		{ after(grammarAccess.getFullMeshPathAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IID__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIIDAccess().getINTTerminalRuleCall_0()); }
		RULE_INT
		{ after(grammarAccess.getIIDAccess().getINTTerminalRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getIIDAccess().getIDTerminalRuleCall_1()); }
		RULE_ID
		{ after(grammarAccess.getIIDAccess().getIDTerminalRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ResourceType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getResourceTypeAccess().getPASSIVEEnumLiteralDeclaration_0()); }
		('PassiveResource')
		{ after(grammarAccess.getResourceTypeAccess().getPASSIVEEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getResourceTypeAccess().getEVENTEnumLiteralDeclaration_1()); }
		('EventResource')
		{ after(grammarAccess.getResourceTypeAccess().getEVENTEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getResourceTypeAccess().getREGULAREnumLiteralDeclaration_2()); }
		('Resource')
		{ after(grammarAccess.getResourceTypeAccess().getREGULAREnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group__0__Impl
	rule__Machine__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getMachineAction_0()); }
	()
	{ after(grammarAccess.getMachineAccess().getMachineAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group__1__Impl
	rule__Machine__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getImportsAssignment_1()); }
	(rule__Machine__ImportsAssignment_1)*
	{ after(grammarAccess.getMachineAccess().getImportsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group__2__Impl
	rule__Machine__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getGroup_2()); }
	(rule__Machine__Group_2__0)?
	{ after(grammarAccess.getMachineAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group__3__Impl
	rule__Machine__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getGroup_3()); }
	(rule__Machine__Group_3__0)?
	{ after(grammarAccess.getMachineAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getAlternatives_4()); }
	(rule__Machine__Alternatives_4)*
	{ after(grammarAccess.getMachineAccess().getAlternatives_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Machine__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group_2__0__Impl
	rule__Machine__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getMachineKeyword_2_0()); }
	'Machine'
	{ after(grammarAccess.getMachineAccess().getMachineKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getTypeAssignment_2_1()); }
	(rule__Machine__TypeAssignment_2_1)
	{ after(grammarAccess.getMachineAccess().getTypeAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Machine__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group_3__0__Impl
	rule__Machine__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getPathAnnotationsKeyword_3_0()); }
	'PathAnnotations'
	{ after(grammarAccess.getMachineAccess().getPathAnnotationsKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group_3__1__Impl
	rule__Machine__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getLeftCurlyBracketKeyword_3_1()); }
	'{'
	{ after(grammarAccess.getMachineAccess().getLeftCurlyBracketKeyword_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group_3__2__Impl
	rule__Machine__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getPathAnnotationsAssignment_3_2()); }
	(rule__Machine__PathAnnotationsAssignment_3_2)*
	{ after(grammarAccess.getMachineAccess().getPathAnnotationsAssignment_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Machine__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineAccess().getRightCurlyBracketKeyword_3_3()); }
	'}'
	{ after(grammarAccess.getMachineAccess().getRightCurlyBracketKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Import__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Import__Group__0__Impl
	rule__Import__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Import__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportAccess().getImportKeyword_0()); }
	'import'
	{ after(grammarAccess.getImportAccess().getImportKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Import__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Import__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Import__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getImportAccess().getImportURIAssignment_1()); }
	(rule__Import__ImportURIAssignment_1)
	{ after(grammarAccess.getImportAccess().getImportURIAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PathAnnotation__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathAnnotation__Group__0__Impl
	rule__PathAnnotation__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PathAnnotation__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathAnnotationAccess().getPathAnnotationAction_0()); }
	()
	{ after(grammarAccess.getPathAnnotationAccess().getPathAnnotationAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathAnnotation__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathAnnotation__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PathAnnotation__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathAnnotationAccess().getNameAssignment_1()); }
	(rule__PathAnnotation__NameAssignment_1)
	{ after(grammarAccess.getPathAnnotationAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PeripheralType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group__0__Impl
	rule__PeripheralType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getPeripheralTypeAction_0()); }
	()
	{ after(grammarAccess.getPeripheralTypeAccess().getPeripheralTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group__1__Impl
	rule__PeripheralType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getPeripheralTypeKeyword_1()); }
	'PeripheralType'
	{ after(grammarAccess.getPeripheralTypeAccess().getPeripheralTypeKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group__2__Impl
	rule__PeripheralType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getNameAssignment_2()); }
	(rule__PeripheralType__NameAssignment_2)
	{ after(grammarAccess.getPeripheralTypeAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group__3__Impl
	rule__PeripheralType__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_3()); }
	'{'
	{ after(grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group__4__Impl
	rule__PeripheralType__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getGroup_4()); }
	(rule__PeripheralType__Group_4__0)?
	{ after(grammarAccess.getPeripheralTypeAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group__5__Impl
	rule__PeripheralType__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getGroup_5()); }
	(rule__PeripheralType__Group_5__0)?
	{ after(grammarAccess.getPeripheralTypeAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_6()); }
	'}'
	{ after(grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PeripheralType__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_4__0__Impl
	rule__PeripheralType__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getActionsKeyword_4_0()); }
	'Actions'
	{ after(grammarAccess.getPeripheralTypeAccess().getActionsKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_4__1__Impl
	rule__PeripheralType__Group_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_4_1()); }
	'{'
	{ after(grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_4__2__Impl
	rule__PeripheralType__Group_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getActionsAssignment_4_2()); }
	(rule__PeripheralType__ActionsAssignment_4_2)*
	{ after(grammarAccess.getPeripheralTypeAccess().getActionsAssignment_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_4__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_4_3()); }
	'}'
	{ after(grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PeripheralType__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__0__Impl
	rule__PeripheralType__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getSetPointsKeyword_5_0()); }
	'SetPoints'
	{ after(grammarAccess.getPeripheralTypeAccess().getSetPointsKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__1__Impl
	rule__PeripheralType__Group_5__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_5_1()); }
	'{'
	{ after(grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__2__Impl
	rule__PeripheralType__Group_5__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getSetPointsAssignment_5_2()); }
	(rule__PeripheralType__SetPointsAssignment_5_2)*
	{ after(grammarAccess.getPeripheralTypeAccess().getSetPointsAssignment_5_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__3__Impl
	rule__PeripheralType__Group_5__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_5_3()); }
	'}'
	{ after(grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_5_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__4__Impl
	rule__PeripheralType__Group_5__5
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getAxesKeyword_5_4()); }
	'Axes'
	{ after(grammarAccess.getPeripheralTypeAccess().getAxesKeyword_5_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__5__Impl
	rule__PeripheralType__Group_5__6
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_5_5()); }
	'{'
	{ after(grammarAccess.getPeripheralTypeAccess().getLeftCurlyBracketKeyword_5_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__6__Impl
	rule__PeripheralType__Group_5__7
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getAxesAssignment_5_6()); }
	(rule__PeripheralType__AxesAssignment_5_6)*
	{ after(grammarAccess.getPeripheralTypeAccess().getAxesAssignment_5_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__7__Impl
	rule__PeripheralType__Group_5__8
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_5_7()); }
	'}'
	{ after(grammarAccess.getPeripheralTypeAccess().getRightCurlyBracketKeyword_5_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getGroup_5_8()); }
	(rule__PeripheralType__Group_5_8__0)?
	{ after(grammarAccess.getPeripheralTypeAccess().getGroup_5_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PeripheralType__Group_5_8__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5_8__0__Impl
	rule__PeripheralType__Group_5_8__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5_8__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getConversionKeyword_5_8_0()); }
	'Conversion'
	{ after(grammarAccess.getPeripheralTypeAccess().getConversionKeyword_5_8_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5_8__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PeripheralType__Group_5_8__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__Group_5_8__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralTypeAccess().getConversionAssignment_5_8_1()); }
	(rule__PeripheralType__ConversionAssignment_5_8_1)
	{ after(grammarAccess.getPeripheralTypeAccess().getConversionAssignment_5_8_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ActionType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ActionType__Group__0__Impl
	rule__ActionType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ActionType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getActionTypeAccess().getActionTypeAction_0()); }
	()
	{ after(grammarAccess.getActionTypeAccess().getActionTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ActionType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ActionType__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ActionType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getActionTypeAccess().getNameAssignment_1()); }
	(rule__ActionType__NameAssignment_1)
	{ after(grammarAccess.getActionTypeAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SetPoint__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SetPoint__Group__0__Impl
	rule__SetPoint__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSetPointAccess().getSetPointAction_0()); }
	()
	{ after(grammarAccess.getSetPointAccess().getSetPointAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SetPoint__Group__1__Impl
	rule__SetPoint__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSetPointAccess().getNameAssignment_1()); }
	(rule__SetPoint__NameAssignment_1)
	{ after(grammarAccess.getSetPointAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SetPoint__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSetPointAccess().getGroup_2()); }
	(rule__SetPoint__Group_2__0)?
	{ after(grammarAccess.getSetPointAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SetPoint__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SetPoint__Group_2__0__Impl
	rule__SetPoint__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSetPointAccess().getLeftSquareBracketKeyword_2_0()); }
	'['
	{ after(grammarAccess.getSetPointAccess().getLeftSquareBracketKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SetPoint__Group_2__1__Impl
	rule__SetPoint__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSetPointAccess().getUnitAssignment_2_1()); }
	(rule__SetPoint__UnitAssignment_2_1)
	{ after(grammarAccess.getSetPointAccess().getUnitAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SetPoint__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSetPointAccess().getRightSquareBracketKeyword_2_2()); }
	']'
	{ after(grammarAccess.getSetPointAccess().getRightSquareBracketKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Axis__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group__0__Impl
	rule__Axis__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getAxisAction_0()); }
	()
	{ after(grammarAccess.getAxisAccess().getAxisAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group__1__Impl
	rule__Axis__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getNameAssignment_1()); }
	(rule__Axis__NameAssignment_1)
	{ after(grammarAccess.getAxisAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group__2__Impl
	rule__Axis__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getGroup_2()); }
	(rule__Axis__Group_2__0)?
	{ after(grammarAccess.getAxisAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getGroup_3()); }
	(rule__Axis__Group_3__0)?
	{ after(grammarAccess.getAxisAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Axis__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group_2__0__Impl
	rule__Axis__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getLeftSquareBracketKeyword_2_0()); }
	'['
	{ after(grammarAccess.getAxisAccess().getLeftSquareBracketKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group_2__1__Impl
	rule__Axis__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getUnitAssignment_2_1()); }
	(rule__Axis__UnitAssignment_2_1)
	{ after(grammarAccess.getAxisAccess().getUnitAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getRightSquareBracketKeyword_2_2()); }
	']'
	{ after(grammarAccess.getAxisAccess().getRightSquareBracketKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Axis__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group_3__0__Impl
	rule__Axis__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getMovesKeyword_3_0()); }
	'moves'
	{ after(grammarAccess.getAxisAccess().getMovesKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group_3__1__Impl
	rule__Axis__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getSetPointsAssignment_3_1()); }
	(rule__Axis__SetPointsAssignment_3_1)
	{ after(grammarAccess.getAxisAccess().getSetPointsAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group_3__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getGroup_3_2()); }
	(rule__Axis__Group_3_2__0)*
	{ after(grammarAccess.getAxisAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Axis__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group_3_2__0__Impl
	rule__Axis__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getCommaKeyword_3_2_0()); }
	','
	{ after(grammarAccess.getAxisAccess().getCommaKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Axis__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisAccess().getSetPointsAssignment_3_2_1()); }
	(rule__Axis__SetPointsAssignment_3_2_1)
	{ after(grammarAccess.getAxisAccess().getSetPointsAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ResourceItem__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ResourceItem__Group__0__Impl
	rule__ResourceItem__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ResourceItem__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceItemAccess().getResourceItemAction_0()); }
	()
	{ after(grammarAccess.getResourceItemAccess().getResourceItemAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ResourceItem__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ResourceItem__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ResourceItem__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceItemAccess().getNameAssignment_1()); }
	(rule__ResourceItem__NameAssignment_1)
	{ after(grammarAccess.getResourceItemAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Resource__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group__0__Impl
	rule__Resource__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getResourceTypeAssignment_0()); }
	(rule__Resource__ResourceTypeAssignment_0)
	{ after(grammarAccess.getResourceAccess().getResourceTypeAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group__1__Impl
	rule__Resource__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getNameAssignment_1()); }
	(rule__Resource__NameAssignment_1)
	{ after(grammarAccess.getResourceAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group__2__Impl
	rule__Resource__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getGroup_2()); }
	(rule__Resource__Group_2__0)?
	{ after(grammarAccess.getResourceAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group__3__Impl
	rule__Resource__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getLeftCurlyBracketKeyword_3()); }
	'{'
	{ after(grammarAccess.getResourceAccess().getLeftCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group__4__Impl
	rule__Resource__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getPeripheralsAssignment_4()); }
	(rule__Resource__PeripheralsAssignment_4)*
	{ after(grammarAccess.getResourceAccess().getPeripheralsAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getRightCurlyBracketKeyword_5()); }
	'}'
	{ after(grammarAccess.getResourceAccess().getRightCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Resource__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group_2__0__Impl
	rule__Resource__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getLeftParenthesisKeyword_2_0()); }
	'('
	{ after(grammarAccess.getResourceAccess().getLeftParenthesisKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group_2__1__Impl
	rule__Resource__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getItemsAssignment_2_1()); }
	(rule__Resource__ItemsAssignment_2_1)
	{ after(grammarAccess.getResourceAccess().getItemsAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group_2__2__Impl
	rule__Resource__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getGroup_2_2()); }
	(rule__Resource__Group_2_2__0)*
	{ after(grammarAccess.getResourceAccess().getGroup_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getRightParenthesisKeyword_2_3()); }
	')'
	{ after(grammarAccess.getResourceAccess().getRightParenthesisKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Resource__Group_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group_2_2__0__Impl
	rule__Resource__Group_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getCommaKeyword_2_2_0()); }
	','
	{ after(grammarAccess.getResourceAccess().getCommaKeyword_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Resource__Group_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__Group_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getResourceAccess().getItemsAssignment_2_2_1()); }
	(rule__Resource__ItemsAssignment_2_2_1)
	{ after(grammarAccess.getResourceAccess().getItemsAssignment_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Peripheral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group__0__Impl
	rule__Peripheral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getNameAssignment_0()); }
	(rule__Peripheral__NameAssignment_0)
	{ after(grammarAccess.getPeripheralAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group__1__Impl
	rule__Peripheral__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getColonKeyword_1()); }
	':'
	{ after(grammarAccess.getPeripheralAccess().getColonKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group__2__Impl
	rule__Peripheral__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getTypeAssignment_2()); }
	(rule__Peripheral__TypeAssignment_2)
	{ after(grammarAccess.getPeripheralAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getGroup_3()); }
	(rule__Peripheral__Group_3__0)?
	{ after(grammarAccess.getPeripheralAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Peripheral__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3__0__Impl
	rule__Peripheral__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_0()); }
	'{'
	{ after(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3__1__Impl
	rule__Peripheral__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getGroup_3_1()); }
	(rule__Peripheral__Group_3_1__0)?
	{ after(grammarAccess.getPeripheralAccess().getGroup_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_2()); }
	'}'
	{ after(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Peripheral__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__0__Impl
	rule__Peripheral__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getGroup_3_1_0()); }
	(rule__Peripheral__Group_3_1_0__0)?
	{ after(grammarAccess.getPeripheralAccess().getGroup_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__1__Impl
	rule__Peripheral__Group_3_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getGroup_3_1_1()); }
	(rule__Peripheral__Group_3_1_1__0)?
	{ after(grammarAccess.getPeripheralAccess().getGroup_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__2__Impl
	rule__Peripheral__Group_3_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getProfilesKeyword_3_1_2()); }
	'Profiles'
	{ after(grammarAccess.getPeripheralAccess().getProfilesKeyword_3_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__3__Impl
	rule__Peripheral__Group_3_1__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getLeftParenthesisKeyword_3_1_3()); }
	'('
	{ after(grammarAccess.getPeripheralAccess().getLeftParenthesisKeyword_3_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__4__Impl
	rule__Peripheral__Group_3_1__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getProfilesAssignment_3_1_4()); }
	(rule__Peripheral__ProfilesAssignment_3_1_4)
	{ after(grammarAccess.getPeripheralAccess().getProfilesAssignment_3_1_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__5__Impl
	rule__Peripheral__Group_3_1__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getGroup_3_1_5()); }
	(rule__Peripheral__Group_3_1_5__0)*
	{ after(grammarAccess.getPeripheralAccess().getGroup_3_1_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__6__Impl
	rule__Peripheral__Group_3_1__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getRightParenthesisKeyword_3_1_6()); }
	')'
	{ after(grammarAccess.getPeripheralAccess().getRightParenthesisKeyword_3_1_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__7__Impl
	rule__Peripheral__Group_3_1__8
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getGroup_3_1_7()); }
	(rule__Peripheral__Group_3_1_7__0)?
	{ after(grammarAccess.getPeripheralAccess().getGroup_3_1_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getGroup_3_1_8()); }
	(rule__Peripheral__Group_3_1_8__0)?
	{ after(grammarAccess.getPeripheralAccess().getGroup_3_1_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Peripheral__Group_3_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_0__0__Impl
	rule__Peripheral__Group_3_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getAxisPositionsKeyword_3_1_0_0()); }
	'AxisPositions'
	{ after(grammarAccess.getPeripheralAccess().getAxisPositionsKeyword_3_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_0__1__Impl
	rule__Peripheral__Group_3_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_0_1()); }
	'{'
	{ after(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_0__2__Impl
	rule__Peripheral__Group_3_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getAxisPositionsAssignment_3_1_0_2()); }
	(rule__Peripheral__AxisPositionsAssignment_3_1_0_2)*
	{ after(grammarAccess.getPeripheralAccess().getAxisPositionsAssignment_3_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_0_3()); }
	'}'
	{ after(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Peripheral__Group_3_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_1__0__Impl
	rule__Peripheral__Group_3_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getSymbolicPositionsKeyword_3_1_1_0()); }
	'SymbolicPositions'
	{ after(grammarAccess.getPeripheralAccess().getSymbolicPositionsKeyword_3_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_1__1__Impl
	rule__Peripheral__Group_3_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_1_1()); }
	'{'
	{ after(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_1__2__Impl
	rule__Peripheral__Group_3_1_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getPositionsAssignment_3_1_1_2()); }
	(rule__Peripheral__PositionsAssignment_3_1_1_2)*
	{ after(grammarAccess.getPeripheralAccess().getPositionsAssignment_3_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_1_3()); }
	'}'
	{ after(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Peripheral__Group_3_1_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_5__0__Impl
	rule__Peripheral__Group_3_1_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getCommaKeyword_3_1_5_0()); }
	','
	{ after(grammarAccess.getPeripheralAccess().getCommaKeyword_3_1_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getProfilesAssignment_3_1_5_1()); }
	(rule__Peripheral__ProfilesAssignment_3_1_5_1)
	{ after(grammarAccess.getPeripheralAccess().getProfilesAssignment_3_1_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Peripheral__Group_3_1_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_7__0__Impl
	rule__Peripheral__Group_3_1_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getDistancesKeyword_3_1_7_0()); }
	'Distances'
	{ after(grammarAccess.getPeripheralAccess().getDistancesKeyword_3_1_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_7__1__Impl
	rule__Peripheral__Group_3_1_7__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_7_1()); }
	'{'
	{ after(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_7__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_7__2__Impl
	rule__Peripheral__Group_3_1_7__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_7__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getDistancesAssignment_3_1_7_2()); }
	(rule__Peripheral__DistancesAssignment_3_1_7_2)*
	{ after(grammarAccess.getPeripheralAccess().getDistancesAssignment_3_1_7_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_7__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_7__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_7__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_7_3()); }
	'}'
	{ after(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_7_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Peripheral__Group_3_1_8__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_8__0__Impl
	rule__Peripheral__Group_3_1_8__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_8__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getPathsKeyword_3_1_8_0()); }
	'Paths'
	{ after(grammarAccess.getPeripheralAccess().getPathsKeyword_3_1_8_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_8__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_8__1__Impl
	rule__Peripheral__Group_3_1_8__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_8__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_8_1()); }
	'{'
	{ after(grammarAccess.getPeripheralAccess().getLeftCurlyBracketKeyword_3_1_8_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_8__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_8__2__Impl
	rule__Peripheral__Group_3_1_8__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_8__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getPathsAssignment_3_1_8_2()); }
	(rule__Peripheral__PathsAssignment_3_1_8_2)*
	{ after(grammarAccess.getPeripheralAccess().getPathsAssignment_3_1_8_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_8__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Peripheral__Group_3_1_8__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__Group_3_1_8__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_8_3()); }
	'}'
	{ after(grammarAccess.getPeripheralAccess().getRightCurlyBracketKeyword_3_1_8_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Distance__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group__0__Impl
	rule__Distance__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getDistanceAction_0()); }
	()
	{ after(grammarAccess.getDistanceAccess().getDistanceAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group__1__Impl
	rule__Distance__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getNameAssignment_1()); }
	(rule__Distance__NameAssignment_1)
	{ after(grammarAccess.getDistanceAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getGroup_2()); }
	(rule__Distance__Group_2__0)?
	{ after(grammarAccess.getDistanceAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Distance__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group_2__0__Impl
	rule__Distance__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getLeftSquareBracketKeyword_2_0()); }
	'['
	{ after(grammarAccess.getDistanceAccess().getLeftSquareBracketKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group_2__1__Impl
	rule__Distance__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getSettlingAssignment_2_1()); }
	(rule__Distance__SettlingAssignment_2_1)
	{ after(grammarAccess.getDistanceAccess().getSettlingAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group_2__2__Impl
	rule__Distance__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getGroup_2_2()); }
	(rule__Distance__Group_2_2__0)*
	{ after(grammarAccess.getDistanceAccess().getGroup_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getRightSquareBracketKeyword_2_3()); }
	']'
	{ after(grammarAccess.getDistanceAccess().getRightSquareBracketKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Distance__Group_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group_2_2__0__Impl
	rule__Distance__Group_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getCommaKeyword_2_2_0()); }
	','
	{ after(grammarAccess.getDistanceAccess().getCommaKeyword_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Distance__Group_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__Group_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDistanceAccess().getSettlingAssignment_2_2_1()); }
	(rule__Distance__SettlingAssignment_2_2_1)
	{ after(grammarAccess.getDistanceAccess().getSettlingAssignment_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AxisPositionsMapEntry__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group__0__Impl
	rule__AxisPositionsMapEntry__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getAxisPositionsMapEntryAction_0()); }
	()
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getAxisPositionsMapEntryAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group__1__Impl
	rule__AxisPositionsMapEntry__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getKeyAssignment_1()); }
	(rule__AxisPositionsMapEntry__KeyAssignment_1)
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getKeyAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getGroup_2()); }
	(rule__AxisPositionsMapEntry__Group_2__0)?
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AxisPositionsMapEntry__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group_2__0__Impl
	rule__AxisPositionsMapEntry__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getLeftParenthesisKeyword_2_0()); }
	'('
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getLeftParenthesisKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group_2__1__Impl
	rule__AxisPositionsMapEntry__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getValueAssignment_2_1()); }
	(rule__AxisPositionsMapEntry__ValueAssignment_2_1)
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getValueAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group_2__2__Impl
	rule__AxisPositionsMapEntry__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getGroup_2_2()); }
	(rule__AxisPositionsMapEntry__Group_2_2__0)*
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getGroup_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getRightParenthesisKeyword_2_3()); }
	')'
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getRightParenthesisKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AxisPositionsMapEntry__Group_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group_2_2__0__Impl
	rule__AxisPositionsMapEntry__Group_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getCommaKeyword_2_2_0()); }
	','
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getCommaKeyword_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionsMapEntry__Group_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__Group_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionsMapEntryAccess().getValueAssignment_2_2_1()); }
	(rule__AxisPositionsMapEntry__ValueAssignment_2_2_1)
	{ after(grammarAccess.getAxisPositionsMapEntryAccess().getValueAssignment_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Position__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Position__Group__0__Impl
	rule__Position__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Position__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPositionAccess().getPositionAction_0()); }
	()
	{ after(grammarAccess.getPositionAccess().getPositionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Position__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Position__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Position__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPositionAccess().getNameAssignment_1()); }
	(rule__Position__NameAssignment_1)
	{ after(grammarAccess.getPositionAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SymbolicPosition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group__0__Impl
	rule__SymbolicPosition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getSymbolicPositionAction_0()); }
	()
	{ after(grammarAccess.getSymbolicPositionAccess().getSymbolicPositionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group__1__Impl
	rule__SymbolicPosition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getNameAssignment_1()); }
	(rule__SymbolicPosition__NameAssignment_1)
	{ after(grammarAccess.getSymbolicPositionAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getGroup_2()); }
	(rule__SymbolicPosition__Group_2__0)?
	{ after(grammarAccess.getSymbolicPositionAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SymbolicPosition__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group_2__0__Impl
	rule__SymbolicPosition__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getLeftParenthesisKeyword_2_0()); }
	'('
	{ after(grammarAccess.getSymbolicPositionAccess().getLeftParenthesisKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group_2__1__Impl
	rule__SymbolicPosition__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getAxisPositionAssignment_2_1()); }
	(rule__SymbolicPosition__AxisPositionAssignment_2_1)
	{ after(grammarAccess.getSymbolicPositionAccess().getAxisPositionAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group_2__2__Impl
	rule__SymbolicPosition__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getGroup_2_2()); }
	(rule__SymbolicPosition__Group_2_2__0)*
	{ after(grammarAccess.getSymbolicPositionAccess().getGroup_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getRightParenthesisKeyword_2_3()); }
	')'
	{ after(grammarAccess.getSymbolicPositionAccess().getRightParenthesisKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SymbolicPosition__Group_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group_2_2__0__Impl
	rule__SymbolicPosition__Group_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getCommaKeyword_2_2_0()); }
	','
	{ after(grammarAccess.getSymbolicPositionAccess().getCommaKeyword_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SymbolicPosition__Group_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__Group_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSymbolicPositionAccess().getAxisPositionAssignment_2_2_1()); }
	(rule__SymbolicPosition__AxisPositionAssignment_2_2_1)
	{ after(grammarAccess.getSymbolicPositionAccess().getAxisPositionAssignment_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__AxisPositionMapEntry__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionMapEntry__Group__0__Impl
	rule__AxisPositionMapEntry__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionMapEntryAccess().getAxisPositionMapEntryAction_0()); }
	()
	{ after(grammarAccess.getAxisPositionMapEntryAccess().getAxisPositionMapEntryAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionMapEntry__Group__1__Impl
	rule__AxisPositionMapEntry__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionMapEntryAccess().getKeyAssignment_1()); }
	(rule__AxisPositionMapEntry__KeyAssignment_1)
	{ after(grammarAccess.getAxisPositionMapEntryAccess().getKeyAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionMapEntry__Group__2__Impl
	rule__AxisPositionMapEntry__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionMapEntryAccess().getFullStopKeyword_2()); }
	'.'
	{ after(grammarAccess.getAxisPositionMapEntryAccess().getFullStopKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__AxisPositionMapEntry__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getAxisPositionMapEntryAccess().getValueAssignment_3()); }
	(rule__AxisPositionMapEntry__ValueAssignment_3)
	{ after(grammarAccess.getAxisPositionMapEntryAccess().getValueAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Profile__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Profile__Group__0__Impl
	rule__Profile__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Profile__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProfileAccess().getProfileAction_0()); }
	()
	{ after(grammarAccess.getProfileAccess().getProfileAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Profile__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Profile__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Profile__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProfileAccess().getNameAssignment_1()); }
	(rule__Profile__NameAssignment_1)
	{ after(grammarAccess.getProfileAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnidirectionalPath__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group__0__Impl
	rule__UnidirectionalPath__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getUnidirectionalPathAction_0()); }
	()
	{ after(grammarAccess.getUnidirectionalPathAccess().getUnidirectionalPathAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group__1__Impl
	rule__UnidirectionalPath__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getSourceAssignment_1()); }
	(rule__UnidirectionalPath__SourceAssignment_1)
	{ after(grammarAccess.getUnidirectionalPathAccess().getSourceAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group__2__Impl
	rule__UnidirectionalPath__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_2()); }
	'-->'
	{ after(grammarAccess.getUnidirectionalPathAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group__3__Impl
	rule__UnidirectionalPath__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getTargetAssignment_3()); }
	(rule__UnidirectionalPath__TargetAssignment_3)
	{ after(grammarAccess.getUnidirectionalPathAccess().getTargetAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group__4__Impl
	rule__UnidirectionalPath__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getAlternatives_4()); }
	(rule__UnidirectionalPath__Alternatives_4)
	{ after(grammarAccess.getUnidirectionalPathAccess().getAlternatives_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getGroup_5()); }
	(rule__UnidirectionalPath__Group_5__0)*
	{ after(grammarAccess.getUnidirectionalPathAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnidirectionalPath__Group_4_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_4_0__0__Impl
	rule__UnidirectionalPath__Group_4_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesKeyword_4_0_0()); }
	'profiles'
	{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesKeyword_4_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_4_0__1__Impl
	rule__UnidirectionalPath__Group_4_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_0_1()); }
	(rule__UnidirectionalPath__ProfilesAssignment_4_0_1)
	{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_4_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getGroup_4_0_2()); }
	(rule__UnidirectionalPath__Group_4_0_2__0)*
	{ after(grammarAccess.getUnidirectionalPathAccess().getGroup_4_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnidirectionalPath__Group_4_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_4_0_2__0__Impl
	rule__UnidirectionalPath__Group_4_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getCommaKeyword_4_0_2_0()); }
	','
	{ after(grammarAccess.getUnidirectionalPathAccess().getCommaKeyword_4_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_4_0_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_0_2_1()); }
	(rule__UnidirectionalPath__ProfilesAssignment_4_0_2_1)
	{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnidirectionalPath__Group_4_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_4_1__0__Impl
	rule__UnidirectionalPath__Group_4_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getProfileKeyword_4_1_0()); }
	'profile'
	{ after(grammarAccess.getUnidirectionalPathAccess().getProfileKeyword_4_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_4_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_4_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_1_1()); }
	(rule__UnidirectionalPath__ProfilesAssignment_4_1_1)
	{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnidirectionalPath__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_5__0__Impl
	rule__UnidirectionalPath__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getCommercialAtKeyword_5_0()); }
	'@'
	{ after(grammarAccess.getUnidirectionalPathAccess().getCommercialAtKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnidirectionalPath__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnidirectionalPathAccess().getAnnotationsAssignment_5_1()); }
	(rule__UnidirectionalPath__AnnotationsAssignment_5_1)
	{ after(grammarAccess.getUnidirectionalPathAccess().getAnnotationsAssignment_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BidirectionalPath__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group__0__Impl
	rule__BidirectionalPath__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getBidirectionalPathAction_0()); }
	()
	{ after(grammarAccess.getBidirectionalPathAccess().getBidirectionalPathAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group__1__Impl
	rule__BidirectionalPath__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getEndPointsAssignment_1()); }
	(rule__BidirectionalPath__EndPointsAssignment_1)
	{ after(grammarAccess.getBidirectionalPathAccess().getEndPointsAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group__2__Impl
	rule__BidirectionalPath__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getLessThanSignHyphenMinusGreaterThanSignKeyword_2()); }
	'<->'
	{ after(grammarAccess.getBidirectionalPathAccess().getLessThanSignHyphenMinusGreaterThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group__3__Impl
	rule__BidirectionalPath__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getEndPointsAssignment_3()); }
	(rule__BidirectionalPath__EndPointsAssignment_3)
	{ after(grammarAccess.getBidirectionalPathAccess().getEndPointsAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group__4__Impl
	rule__BidirectionalPath__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getAlternatives_4()); }
	(rule__BidirectionalPath__Alternatives_4)
	{ after(grammarAccess.getBidirectionalPathAccess().getAlternatives_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getGroup_5()); }
	(rule__BidirectionalPath__Group_5__0)*
	{ after(grammarAccess.getBidirectionalPathAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BidirectionalPath__Group_4_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_4_0__0__Impl
	rule__BidirectionalPath__Group_4_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getProfilesKeyword_4_0_0()); }
	'profiles'
	{ after(grammarAccess.getBidirectionalPathAccess().getProfilesKeyword_4_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_4_0__1__Impl
	rule__BidirectionalPath__Group_4_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_0_1()); }
	(rule__BidirectionalPath__ProfilesAssignment_4_0_1)
	{ after(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_4_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getGroup_4_0_2()); }
	(rule__BidirectionalPath__Group_4_0_2__0)*
	{ after(grammarAccess.getBidirectionalPathAccess().getGroup_4_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BidirectionalPath__Group_4_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_4_0_2__0__Impl
	rule__BidirectionalPath__Group_4_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getCommaKeyword_4_0_2_0()); }
	','
	{ after(grammarAccess.getBidirectionalPathAccess().getCommaKeyword_4_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_4_0_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_0_2_1()); }
	(rule__BidirectionalPath__ProfilesAssignment_4_0_2_1)
	{ after(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BidirectionalPath__Group_4_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_4_1__0__Impl
	rule__BidirectionalPath__Group_4_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getProfileKeyword_4_1_0()); }
	'profile'
	{ after(grammarAccess.getBidirectionalPathAccess().getProfileKeyword_4_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_4_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_4_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_1_1()); }
	(rule__BidirectionalPath__ProfilesAssignment_4_1_1)
	{ after(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BidirectionalPath__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_5__0__Impl
	rule__BidirectionalPath__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getCommercialAtKeyword_5_0()); }
	'@'
	{ after(grammarAccess.getBidirectionalPathAccess().getCommercialAtKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BidirectionalPath__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBidirectionalPathAccess().getAnnotationsAssignment_5_1()); }
	(rule__BidirectionalPath__AnnotationsAssignment_5_1)
	{ after(grammarAccess.getBidirectionalPathAccess().getAnnotationsAssignment_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FullMeshPath__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group__0__Impl
	rule__FullMeshPath__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getFullMeshPathAction_0()); }
	()
	{ after(grammarAccess.getFullMeshPathAccess().getFullMeshPathAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group__1__Impl
	rule__FullMeshPath__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getFullMeshKeyword_1()); }
	'FullMesh'
	{ after(grammarAccess.getFullMeshPathAccess().getFullMeshKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group__2__Impl
	rule__FullMeshPath__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getFullMeshPathAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group__3__Impl
	rule__FullMeshPath__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getAlternatives_3()); }
	(rule__FullMeshPath__Alternatives_3)
	{ after(grammarAccess.getFullMeshPathAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group__4__Impl
	rule__FullMeshPath__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getGroup_4()); }
	(rule__FullMeshPath__Group_4__0)*
	{ after(grammarAccess.getFullMeshPathAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group__5__Impl
	rule__FullMeshPath__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getEndPointsAssignment_5()); }
	(rule__FullMeshPath__EndPointsAssignment_5)*
	{ after(grammarAccess.getFullMeshPathAccess().getEndPointsAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getRightCurlyBracketKeyword_6()); }
	'}'
	{ after(grammarAccess.getFullMeshPathAccess().getRightCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FullMeshPath__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_3_0__0__Impl
	rule__FullMeshPath__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getProfilesKeyword_3_0_0()); }
	'profiles'
	{ after(grammarAccess.getFullMeshPathAccess().getProfilesKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_3_0__1__Impl
	rule__FullMeshPath__Group_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_0_1()); }
	(rule__FullMeshPath__ProfilesAssignment_3_0_1)
	{ after(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getGroup_3_0_2()); }
	(rule__FullMeshPath__Group_3_0_2__0)*
	{ after(grammarAccess.getFullMeshPathAccess().getGroup_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FullMeshPath__Group_3_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_3_0_2__0__Impl
	rule__FullMeshPath__Group_3_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getCommaKeyword_3_0_2_0()); }
	','
	{ after(grammarAccess.getFullMeshPathAccess().getCommaKeyword_3_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_3_0_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_0_2_1()); }
	(rule__FullMeshPath__ProfilesAssignment_3_0_2_1)
	{ after(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FullMeshPath__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_3_1__0__Impl
	rule__FullMeshPath__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getProfileKeyword_3_1_0()); }
	'profile'
	{ after(grammarAccess.getFullMeshPathAccess().getProfileKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_1_1()); }
	(rule__FullMeshPath__ProfilesAssignment_3_1_1)
	{ after(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FullMeshPath__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_4__0__Impl
	rule__FullMeshPath__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getCommercialAtKeyword_4_0()); }
	'@'
	{ after(grammarAccess.getFullMeshPathAccess().getCommercialAtKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FullMeshPath__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFullMeshPathAccess().getAnnotationsAssignment_4_1()); }
	(rule__FullMeshPath__AnnotationsAssignment_4_1)
	{ after(grammarAccess.getFullMeshPathAccess().getAnnotationsAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PathTargetReference__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group__0__Impl
	rule__PathTargetReference__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getPathTargetReferenceAction_0()); }
	()
	{ after(grammarAccess.getPathTargetReferenceAccess().getPathTargetReferenceAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group__1__Impl
	rule__PathTargetReference__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getPositionAssignment_1()); }
	(rule__PathTargetReference__PositionAssignment_1)
	{ after(grammarAccess.getPathTargetReferenceAccess().getPositionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getGroup_2()); }
	(rule__PathTargetReference__Group_2__0)?
	{ after(grammarAccess.getPathTargetReferenceAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PathTargetReference__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group_2__0__Impl
	rule__PathTargetReference__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getLeftSquareBracketKeyword_2_0()); }
	'['
	{ after(grammarAccess.getPathTargetReferenceAccess().getLeftSquareBracketKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group_2__1__Impl
	rule__PathTargetReference__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getSettlingAssignment_2_1()); }
	(rule__PathTargetReference__SettlingAssignment_2_1)
	{ after(grammarAccess.getPathTargetReferenceAccess().getSettlingAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group_2__2__Impl
	rule__PathTargetReference__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getGroup_2_2()); }
	(rule__PathTargetReference__Group_2_2__0)*
	{ after(grammarAccess.getPathTargetReferenceAccess().getGroup_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getRightSquareBracketKeyword_2_3()); }
	']'
	{ after(grammarAccess.getPathTargetReferenceAccess().getRightSquareBracketKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PathTargetReference__Group_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group_2_2__0__Impl
	rule__PathTargetReference__Group_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getCommaKeyword_2_2_0()); }
	','
	{ after(grammarAccess.getPathTargetReferenceAccess().getCommaKeyword_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PathTargetReference__Group_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__Group_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPathTargetReferenceAccess().getSettlingAssignment_2_2_1()); }
	(rule__PathTargetReference__SettlingAssignment_2_2_1)
	{ after(grammarAccess.getPathTargetReferenceAccess().getSettlingAssignment_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Machine__ImportsAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineAccess().getImportsImportParserRuleCall_1_0()); }
		ruleImport
		{ after(grammarAccess.getMachineAccess().getImportsImportParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__TypeAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineAccess().getTypeIDTerminalRuleCall_2_1_0()); }
		RULE_ID
		{ after(grammarAccess.getMachineAccess().getTypeIDTerminalRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__PathAnnotationsAssignment_3_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineAccess().getPathAnnotationsPathAnnotationParserRuleCall_3_2_0()); }
		rulePathAnnotation
		{ after(grammarAccess.getMachineAccess().getPathAnnotationsPathAnnotationParserRuleCall_3_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__PeripheralTypesAssignment_4_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineAccess().getPeripheralTypesPeripheralTypeParserRuleCall_4_0_0()); }
		rulePeripheralType
		{ after(grammarAccess.getMachineAccess().getPeripheralTypesPeripheralTypeParserRuleCall_4_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Machine__ResourcesAssignment_4_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineAccess().getResourcesResourceParserRuleCall_4_1_0()); }
		ruleResource
		{ after(grammarAccess.getMachineAccess().getResourcesResourceParserRuleCall_4_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Import__ImportURIAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathAnnotation__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPathAnnotationAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getPathAnnotationAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__NameAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralTypeAccess().getNameIDTerminalRuleCall_2_0()); }
		RULE_ID
		{ after(grammarAccess.getPeripheralTypeAccess().getNameIDTerminalRuleCall_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__ActionsAssignment_4_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralTypeAccess().getActionsActionTypeParserRuleCall_4_2_0()); }
		ruleActionType
		{ after(grammarAccess.getPeripheralTypeAccess().getActionsActionTypeParserRuleCall_4_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__SetPointsAssignment_5_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralTypeAccess().getSetPointsSetPointParserRuleCall_5_2_0()); }
		ruleSetPoint
		{ after(grammarAccess.getPeripheralTypeAccess().getSetPointsSetPointParserRuleCall_5_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__AxesAssignment_5_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralTypeAccess().getAxesAxisParserRuleCall_5_6_0()); }
		ruleAxis
		{ after(grammarAccess.getPeripheralTypeAccess().getAxesAxisParserRuleCall_5_6_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PeripheralType__ConversionAssignment_5_8_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralTypeAccess().getConversionSTRINGTerminalRuleCall_5_8_1_0()); }
		RULE_STRING
		{ after(grammarAccess.getPeripheralTypeAccess().getConversionSTRINGTerminalRuleCall_5_8_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ActionType__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getActionTypeAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getActionTypeAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSetPointAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getSetPointAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SetPoint__UnitAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSetPointAccess().getUnitIDTerminalRuleCall_2_1_0()); }
		RULE_ID
		{ after(grammarAccess.getSetPointAccess().getUnitIDTerminalRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getAxisAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__UnitAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisAccess().getUnitIDTerminalRuleCall_2_1_0()); }
		RULE_ID
		{ after(grammarAccess.getAxisAccess().getUnitIDTerminalRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__SetPointsAssignment_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisAccess().getSetPointsSetPointCrossReference_3_1_0()); }
		(
			{ before(grammarAccess.getAxisAccess().getSetPointsSetPointIDTerminalRuleCall_3_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getAxisAccess().getSetPointsSetPointIDTerminalRuleCall_3_1_0_1()); }
		)
		{ after(grammarAccess.getAxisAccess().getSetPointsSetPointCrossReference_3_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Axis__SetPointsAssignment_3_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisAccess().getSetPointsSetPointCrossReference_3_2_1_0()); }
		(
			{ before(grammarAccess.getAxisAccess().getSetPointsSetPointIDTerminalRuleCall_3_2_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getAxisAccess().getSetPointsSetPointIDTerminalRuleCall_3_2_1_0_1()); }
		)
		{ after(grammarAccess.getAxisAccess().getSetPointsSetPointCrossReference_3_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ResourceItem__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getResourceItemAccess().getNameIIDParserRuleCall_1_0()); }
		ruleIID
		{ after(grammarAccess.getResourceItemAccess().getNameIIDParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__ResourceTypeAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getResourceAccess().getResourceTypeResourceTypeEnumRuleCall_0_0()); }
		ruleResourceType
		{ after(grammarAccess.getResourceAccess().getResourceTypeResourceTypeEnumRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getResourceAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getResourceAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__ItemsAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getResourceAccess().getItemsResourceItemParserRuleCall_2_1_0()); }
		ruleResourceItem
		{ after(grammarAccess.getResourceAccess().getItemsResourceItemParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__ItemsAssignment_2_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getResourceAccess().getItemsResourceItemParserRuleCall_2_2_1_0()); }
		ruleResourceItem
		{ after(grammarAccess.getResourceAccess().getItemsResourceItemParserRuleCall_2_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Resource__PeripheralsAssignment_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getResourceAccess().getPeripheralsPeripheralParserRuleCall_4_0()); }
		rulePeripheral
		{ after(grammarAccess.getResourceAccess().getPeripheralsPeripheralParserRuleCall_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__NameAssignment_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralAccess().getNameIDTerminalRuleCall_0_0()); }
		RULE_ID
		{ after(grammarAccess.getPeripheralAccess().getNameIDTerminalRuleCall_0_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__TypeAssignment_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralAccess().getTypePeripheralTypeCrossReference_2_0()); }
		(
			{ before(grammarAccess.getPeripheralAccess().getTypePeripheralTypeIDTerminalRuleCall_2_0_1()); }
			RULE_ID
			{ after(grammarAccess.getPeripheralAccess().getTypePeripheralTypeIDTerminalRuleCall_2_0_1()); }
		)
		{ after(grammarAccess.getPeripheralAccess().getTypePeripheralTypeCrossReference_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__AxisPositionsAssignment_3_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralAccess().getAxisPositionsAxisPositionsMapEntryParserRuleCall_3_1_0_2_0()); }
		ruleAxisPositionsMapEntry
		{ after(grammarAccess.getPeripheralAccess().getAxisPositionsAxisPositionsMapEntryParserRuleCall_3_1_0_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__PositionsAssignment_3_1_1_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralAccess().getPositionsSymbolicPositionParserRuleCall_3_1_1_2_0()); }
		ruleSymbolicPosition
		{ after(grammarAccess.getPeripheralAccess().getPositionsSymbolicPositionParserRuleCall_3_1_1_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__ProfilesAssignment_3_1_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralAccess().getProfilesProfileParserRuleCall_3_1_4_0()); }
		ruleProfile
		{ after(grammarAccess.getPeripheralAccess().getProfilesProfileParserRuleCall_3_1_4_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__ProfilesAssignment_3_1_5_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralAccess().getProfilesProfileParserRuleCall_3_1_5_1_0()); }
		ruleProfile
		{ after(grammarAccess.getPeripheralAccess().getProfilesProfileParserRuleCall_3_1_5_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__DistancesAssignment_3_1_7_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralAccess().getDistancesDistanceParserRuleCall_3_1_7_2_0()); }
		ruleDistance
		{ after(grammarAccess.getPeripheralAccess().getDistancesDistanceParserRuleCall_3_1_7_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Peripheral__PathsAssignment_3_1_8_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPeripheralAccess().getPathsPathParserRuleCall_3_1_8_2_0()); }
		rulePath
		{ after(grammarAccess.getPeripheralAccess().getPathsPathParserRuleCall_3_1_8_2_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDistanceAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getDistanceAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__SettlingAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDistanceAccess().getSettlingAxisCrossReference_2_1_0()); }
		(
			{ before(grammarAccess.getDistanceAccess().getSettlingAxisIDTerminalRuleCall_2_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getDistanceAccess().getSettlingAxisIDTerminalRuleCall_2_1_0_1()); }
		)
		{ after(grammarAccess.getDistanceAccess().getSettlingAxisCrossReference_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Distance__SettlingAssignment_2_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDistanceAccess().getSettlingAxisCrossReference_2_2_1_0()); }
		(
			{ before(grammarAccess.getDistanceAccess().getSettlingAxisIDTerminalRuleCall_2_2_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getDistanceAccess().getSettlingAxisIDTerminalRuleCall_2_2_1_0_1()); }
		)
		{ after(grammarAccess.getDistanceAccess().getSettlingAxisCrossReference_2_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__KeyAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisPositionsMapEntryAccess().getKeyAxisCrossReference_1_0()); }
		(
			{ before(grammarAccess.getAxisPositionsMapEntryAccess().getKeyAxisIDTerminalRuleCall_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getAxisPositionsMapEntryAccess().getKeyAxisIDTerminalRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getAxisPositionsMapEntryAccess().getKeyAxisCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__ValueAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisPositionsMapEntryAccess().getValuePositionParserRuleCall_2_1_0()); }
		rulePosition
		{ after(grammarAccess.getAxisPositionsMapEntryAccess().getValuePositionParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionsMapEntry__ValueAssignment_2_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisPositionsMapEntryAccess().getValuePositionParserRuleCall_2_2_1_0()); }
		rulePosition
		{ after(grammarAccess.getAxisPositionsMapEntryAccess().getValuePositionParserRuleCall_2_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Position__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPositionAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getPositionAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSymbolicPositionAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getSymbolicPositionAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__AxisPositionAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSymbolicPositionAccess().getAxisPositionAxisPositionMapEntryParserRuleCall_2_1_0()); }
		ruleAxisPositionMapEntry
		{ after(grammarAccess.getSymbolicPositionAccess().getAxisPositionAxisPositionMapEntryParserRuleCall_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SymbolicPosition__AxisPositionAssignment_2_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSymbolicPositionAccess().getAxisPositionAxisPositionMapEntryParserRuleCall_2_2_1_0()); }
		ruleAxisPositionMapEntry
		{ after(grammarAccess.getSymbolicPositionAccess().getAxisPositionAxisPositionMapEntryParserRuleCall_2_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__KeyAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisPositionMapEntryAccess().getKeyAxisCrossReference_1_0()); }
		(
			{ before(grammarAccess.getAxisPositionMapEntryAccess().getKeyAxisIDTerminalRuleCall_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getAxisPositionMapEntryAccess().getKeyAxisIDTerminalRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getAxisPositionMapEntryAccess().getKeyAxisCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AxisPositionMapEntry__ValueAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAxisPositionMapEntryAccess().getValuePositionCrossReference_3_0()); }
		(
			{ before(grammarAccess.getAxisPositionMapEntryAccess().getValuePositionIDTerminalRuleCall_3_0_1()); }
			RULE_ID
			{ after(grammarAccess.getAxisPositionMapEntryAccess().getValuePositionIDTerminalRuleCall_3_0_1()); }
		)
		{ after(grammarAccess.getAxisPositionMapEntryAccess().getValuePositionCrossReference_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Profile__NameAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProfileAccess().getNameIDTerminalRuleCall_1_0()); }
		RULE_ID
		{ after(grammarAccess.getProfileAccess().getNameIDTerminalRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__SourceAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getSourceSymbolicPositionCrossReference_1_0()); }
		(
			{ before(grammarAccess.getUnidirectionalPathAccess().getSourceSymbolicPositionIDTerminalRuleCall_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getUnidirectionalPathAccess().getSourceSymbolicPositionIDTerminalRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getUnidirectionalPathAccess().getSourceSymbolicPositionCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__TargetAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getTargetPathTargetReferenceParserRuleCall_3_0()); }
		rulePathTargetReference
		{ after(grammarAccess.getUnidirectionalPathAccess().getTargetPathTargetReferenceParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__ProfilesAssignment_4_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_0_1_0()); }
		(
			{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_0_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_0_1_0_1()); }
		)
		{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__ProfilesAssignment_4_0_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_0_2_1_0()); }
		(
			{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1()); }
		)
		{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_0_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__ProfilesAssignment_4_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_1_1_0()); }
		(
			{ before(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_1_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_1_1_0_1()); }
		)
		{ after(grammarAccess.getUnidirectionalPathAccess().getProfilesProfileCrossReference_4_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnidirectionalPath__AnnotationsAssignment_5_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnidirectionalPathAccess().getAnnotationsPathAnnotationCrossReference_5_1_0()); }
		(
			{ before(grammarAccess.getUnidirectionalPathAccess().getAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getUnidirectionalPathAccess().getAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1()); }
		)
		{ after(grammarAccess.getUnidirectionalPathAccess().getAnnotationsPathAnnotationCrossReference_5_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__EndPointsAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getEndPointsPathTargetReferenceParserRuleCall_1_0()); }
		rulePathTargetReference
		{ after(grammarAccess.getBidirectionalPathAccess().getEndPointsPathTargetReferenceParserRuleCall_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__EndPointsAssignment_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getEndPointsPathTargetReferenceParserRuleCall_3_0()); }
		rulePathTargetReference
		{ after(grammarAccess.getBidirectionalPathAccess().getEndPointsPathTargetReferenceParserRuleCall_3_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__ProfilesAssignment_4_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_0_1_0()); }
		(
			{ before(grammarAccess.getBidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_0_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getBidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_0_1_0_1()); }
		)
		{ after(grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__ProfilesAssignment_4_0_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_0_2_1_0()); }
		(
			{ before(grammarAccess.getBidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getBidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_0_2_1_0_1()); }
		)
		{ after(grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_0_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__ProfilesAssignment_4_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_1_1_0()); }
		(
			{ before(grammarAccess.getBidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_1_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getBidirectionalPathAccess().getProfilesProfileIDTerminalRuleCall_4_1_1_0_1()); }
		)
		{ after(grammarAccess.getBidirectionalPathAccess().getProfilesProfileCrossReference_4_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BidirectionalPath__AnnotationsAssignment_5_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBidirectionalPathAccess().getAnnotationsPathAnnotationCrossReference_5_1_0()); }
		(
			{ before(grammarAccess.getBidirectionalPathAccess().getAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getBidirectionalPathAccess().getAnnotationsPathAnnotationIDTerminalRuleCall_5_1_0_1()); }
		)
		{ after(grammarAccess.getBidirectionalPathAccess().getAnnotationsPathAnnotationCrossReference_5_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__ProfilesAssignment_3_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_0_1_0()); }
		(
			{ before(grammarAccess.getFullMeshPathAccess().getProfilesProfileIDTerminalRuleCall_3_0_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getFullMeshPathAccess().getProfilesProfileIDTerminalRuleCall_3_0_1_0_1()); }
		)
		{ after(grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_0_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__ProfilesAssignment_3_0_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_0_2_1_0()); }
		(
			{ before(grammarAccess.getFullMeshPathAccess().getProfilesProfileIDTerminalRuleCall_3_0_2_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getFullMeshPathAccess().getProfilesProfileIDTerminalRuleCall_3_0_2_1_0_1()); }
		)
		{ after(grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_0_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__ProfilesAssignment_3_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_1_1_0()); }
		(
			{ before(grammarAccess.getFullMeshPathAccess().getProfilesProfileIDTerminalRuleCall_3_1_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getFullMeshPathAccess().getProfilesProfileIDTerminalRuleCall_3_1_1_0_1()); }
		)
		{ after(grammarAccess.getFullMeshPathAccess().getProfilesProfileCrossReference_3_1_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__AnnotationsAssignment_4_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFullMeshPathAccess().getAnnotationsPathAnnotationCrossReference_4_1_0()); }
		(
			{ before(grammarAccess.getFullMeshPathAccess().getAnnotationsPathAnnotationIDTerminalRuleCall_4_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getFullMeshPathAccess().getAnnotationsPathAnnotationIDTerminalRuleCall_4_1_0_1()); }
		)
		{ after(grammarAccess.getFullMeshPathAccess().getAnnotationsPathAnnotationCrossReference_4_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FullMeshPath__EndPointsAssignment_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFullMeshPathAccess().getEndPointsPathTargetReferenceParserRuleCall_5_0()); }
		rulePathTargetReference
		{ after(grammarAccess.getFullMeshPathAccess().getEndPointsPathTargetReferenceParserRuleCall_5_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__PositionAssignment_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPathTargetReferenceAccess().getPositionSymbolicPositionCrossReference_1_0()); }
		(
			{ before(grammarAccess.getPathTargetReferenceAccess().getPositionSymbolicPositionIDTerminalRuleCall_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getPathTargetReferenceAccess().getPositionSymbolicPositionIDTerminalRuleCall_1_0_1()); }
		)
		{ after(grammarAccess.getPathTargetReferenceAccess().getPositionSymbolicPositionCrossReference_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__SettlingAssignment_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPathTargetReferenceAccess().getSettlingAxisCrossReference_2_1_0()); }
		(
			{ before(grammarAccess.getPathTargetReferenceAccess().getSettlingAxisIDTerminalRuleCall_2_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getPathTargetReferenceAccess().getSettlingAxisIDTerminalRuleCall_2_1_0_1()); }
		)
		{ after(grammarAccess.getPathTargetReferenceAccess().getSettlingAxisCrossReference_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PathTargetReference__SettlingAssignment_2_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPathTargetReferenceAccess().getSettlingAxisCrossReference_2_2_1_0()); }
		(
			{ before(grammarAccess.getPathTargetReferenceAccess().getSettlingAxisIDTerminalRuleCall_2_2_1_0_1()); }
			RULE_ID
			{ after(grammarAccess.getPathTargetReferenceAccess().getSettlingAxisIDTerminalRuleCall_2_2_1_0_1()); }
		)
		{ after(grammarAccess.getPathTargetReferenceAccess().getSettlingAxisCrossReference_2_2_1_0()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
