/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.api.algorithm;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.api.MaxPlusException;
import org.eclipse.lsat.common.ludus.api.MinimumThroughputResult;
import org.eclipse.lsat.common.ludus.api.algorithm.MaxPlusAlgorithm;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.algorithms.Howard;
import org.eclipse.lsat.common.ludus.backend.automaton.ComputeMPA;
import org.eclipse.lsat.common.ludus.backend.automaton.MPATransition;
import org.eclipse.lsat.common.ludus.backend.automaton.MaxPlusAutomaton;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.ludus.backend.statespace.ComputeStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.MaxPlusStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.Transition;
import org.eclipse.lsat.common.mpt.api.NotAllResourcesLinkedException;
import org.eclipse.lsat.common.mpt.api.UnconnectedResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimumThroughputAlgorithm
extends MaxPlusAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimumThroughputAlgorithm.class);

    private static void runChecks(FSM<Location, Edge> fsm, Map<String, Matrix> matrixMap) throws MaxPlusException, NotAllResourcesLinkedException {
        MinimumThroughputAlgorithm.checkCyclic(fsm);
        MinimumThroughputAlgorithm.checkNoDeadlocks(fsm);
        MinimumThroughputAlgorithm.checkAllMatricesSameSize(matrixMap.values());
    }

    public static MinimumThroughputResult runMaxPlusStateSpace(FSM<Location, Edge> fsm, Map<String, Matrix> matrixMap) throws MaxPlusException, NotAllResourcesLinkedException, UnconnectedResourceException {
        MinimumThroughputAlgorithm.runChecks(fsm, matrixMap);
        Integer resourceCount = matrixMap.values().iterator().next().getRows();
        MaxPlusStateSpace mpss = ComputeStateSpace.computeMaxPlusStateSpace(fsm, resourceCount, matrixMap);
        LOGGER.info("Max-plus state space constructed: " + mpss.getVertices().size() + " states and " + mpss.getEdges().size() + " edges.");
        List<MaxPlusStateSpace> mpssSCCs = ComputeStateSpace.getSCCs(mpss);
        LOGGER.info("Computed the " + mpssSCCs.size() + " strongly connected components.");
        Tuple<Value, List<Object>> result = Tuple.of(Value.POSITIVE_INFINITY, new LinkedList());
        int i = 1;
        for (MaxPlusStateSpace mpssSCC : mpssSCCs) {
            Tuple<Value, List<Transition>> sccResult = Howard.runHoward(mpssSCC);
            LOGGER.info("Running Howard on component " + i + "/" + mpssSCCs.size());
            if (sccResult.getRight() == null) {
                throw new MaxPlusException("Throughput for component " + i + " cannot be determined due to floating-point precision issues.");
            }
            if (sccResult.getLeft().smallerThan(result.getLeft())) {
                result = sccResult;
            }
            ++i;
        }
        List<String> listOfEventNames = ((List)result.getRight()).stream().map(Transition::getEvent).collect(Collectors.toList());
        return new MinimumThroughputResult(result.getLeft().toDouble(), listOfEventNames);
    }

    public static MinimumThroughputResult runMaxPlusAutomaton(FSM<Location, Edge> fsm, Map<String, Matrix> matrixMap) throws MaxPlusException, NotAllResourcesLinkedException {
        MinimumThroughputAlgorithm.runChecks(fsm, matrixMap);
        Integer resourceCount = matrixMap.values().iterator().next().getRows();
        MaxPlusAutomaton<Location> mpa = ComputeMPA.computeMaxPlusAutomaton(fsm, resourceCount, matrixMap);
        LOGGER.info("Max-plus automaton constructed: " + mpa.getVertices().size() + " states and " + mpa.getEdges().size() + " edges.");
        List<MaxPlusAutomaton<Location>> mpaSCCs = ComputeMPA.getSCCs(mpa);
        LOGGER.info("Computed the " + mpaSCCs.size() + " strongly connected components.");
        Tuple result = Tuple.of(Value.POSITIVE_INFINITY, new LinkedList());
        int i = 1;
        for (MaxPlusAutomaton<Location> mpaSCC : mpaSCCs) {
            Tuple sccResult = Howard.runHoward(mpaSCC);
            LOGGER.info("Running Howard on component " + i + "/" + mpaSCCs.size());
            if (sccResult.getRight() == null) {
                throw new MaxPlusException("Throughput for component " + i + " cannot be determined due to floating-point precision issues.");
            }
            if (sccResult.getLeft().smallerThan(result.getLeft())) {
                result = sccResult;
            }
            ++i;
        }
        List<String> listOfEventNames = ((List)result.getRight()).stream().map(MPATransition::getEvent).collect(Collectors.toList());
        return new MinimumThroughputResult(result.getLeft().toDouble(), listOfEventNames);
    }
}

