/*
 * Decompiled with CFR 0.152.
 */
package activity.util;

import activity.Activity;
import activity.EventAction;
import activity.RaiseEvent;
import activity.RequireEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.lsat.common.graph.directed.editable.EdgQueries;

public class EventSequenceValidator {
    private EventSequenceValidator() {
    }

    public static void validate(List<Activity> activitySequence, ErrorRaiser errorRaiser) {
        LinkedHashMap<String, List<EventAction>> eventMaps = new LinkedHashMap<String, List<EventAction>>();
        LinkedHashSet<String> alreadyRaised = new LinkedHashSet<String>();
        int i = 0;
        while (i < activitySequence.size()) {
            Activity a = activitySequence.get(i);
            Iterable stream = EdgQueries.topologicalOrdering((Iterable)a.getNodes()).stream().filter(EventAction.class::isInstance).map(EventAction.class::cast)::iterator;
            for (EventAction eventAction : stream) {
                int numEventPending = EventSequenceValidator.updateEvents(eventMaps, eventAction);
                if (numEventPending < 0 && alreadyRaised.add(eventAction.getResource().fqn())) {
                    errorRaiser.raise(i, "EventAction '" + eventAction.getResource().fqn() + "' required for activity '" + a.getName() + "' but not raised before");
                    continue;
                }
                if (numEventPending <= 1 || !alreadyRaised.add(eventAction.getResource().fqn())) continue;
                errorRaiser.raise(i, "EventAction '" + eventAction.getResource().fqn() + "' in activity '" + a.getName() + "' raised more than once before consumed");
            }
            ++i;
        }
        for (Map.Entry e : eventMaps.entrySet()) {
            List eventList;
            if (alreadyRaised.contains(e.getKey()) || (eventList = (List)e.getValue()) == null || eventList.size() <= 0) continue;
            if (eventList.get(eventList.size() - 1) instanceof RaiseEvent) {
                eventList.remove(eventList.size() - 1);
            }
            if (EventSequenceValidator.countEvents(eventList) <= 0) continue;
            errorRaiser.raise(-1, "The total number 'raise' and 'requires' for event '" + (String)e.getKey() + "' should be equal in a dispatching sequence");
        }
    }

    private static int updateEvents(Map<String, List<EventAction>> eventsMap, EventAction eventAction) {
        List<EventAction> eventActions = eventsMap.get(eventAction.getResource().fqn());
        if (eventActions == null) {
            eventActions = new ArrayList<EventAction>();
            eventsMap.put(eventAction.getResource().fqn(), eventActions);
            if (eventAction instanceof RequireEvent) {
                return 0;
            }
        }
        eventActions.add(eventAction);
        return EventSequenceValidator.countEvents(eventActions);
    }

    private static int countEvents(List<EventAction> eventActions) {
        return eventActions.stream().mapToInt(e -> e instanceof RequireEvent ? -1 : 1).sum();
    }

    public static interface ErrorRaiser {
        public void raise(int var1, String var2);
    }
}

