/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.plcdata;

import java.util.List;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcGlobalVarList;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcObject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcResource;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PlcConfiguration
extends PlcObject {
    public final String name;
    public List<PlcGlobalVarList> globalVarLists = Lists.list();
    public List<PlcResource> resources = Lists.list();

    public PlcConfiguration(String name) {
        this.name = name;
    }

    public Box toBox() {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("CONFIGURATION %s", new Object[]{this.name});
        c.indent();
        for (PlcGlobalVarList globalVarList : this.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            c.add(globalVarList.toBox());
        }
        Assert.check((this.resources.size() <= 1 ? 1 : 0) != 0);
        for (PlcResource resource : this.resources) {
            c.add(resource.toBox());
        }
        c.dedent();
        c.add("END_CONFIGURATION");
        return c;
    }
}

