/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.qvto.util.internal;

import java.util.List;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractQvtLog
implements Log {
    protected abstract void doLog(LogLevel var1, String var2, Object ... var3);

    protected String createMessage(String aFormat, Object ... aArgs) {
        return MessageFormatter.arrayFormat((String)aFormat, (Object[])aArgs).getMessage();
    }

    public void log(int aLevel, String aMessage, Object aParam) {
        LogLevel level = LogLevel.valueOf(aLevel);
        LogParameterFormat paramFormat = LogParameterFormat.valueOf(aLevel);
        if (level == null || paramFormat == null) {
            this.doLog(LogLevel.Error, "Unknown log level {} is used in the current QVTO transformation. Only log levels 0-5, 10-15 and 20-25 are allowed.\nThe log message is: {}\nThe parameter is: {}", aLevel, aMessage, aParam);
            return;
        }
        switch (paramFormat) {
            case Data: {
                this.doLog(level, "{}, data: {}", aMessage, aParam);
                break;
            }
            case Single: {
                this.doLog(level, aMessage, aParam);
                break;
            }
            case Multi: {
                if (aParam instanceof List) {
                    this.doLog(level, aMessage, ((List)List.class.cast(aParam)).toArray());
                    break;
                }
                this.doLog(LogLevel.Error, "Unrecognized datatype {} is passed to a log statement with format string substitution. Use a List or Sequence to pass multiple arguments.\nThe log message is: {}\nThe parameter is: {}", aParam.getClass(), aMessage, aParam);
            }
        }
    }

    public void log(int aLevel, String aMessage) {
        LogLevel level = LogLevel.valueOf(aLevel);
        if (level == null) {
            this.doLog(LogLevel.Error, "Unknown log level {} is used in the current QVTO transformation. Only log levels 0-5, 10-15 and 20-25 are allowed.\nThe log message is: {}", aLevel, aMessage);
            return;
        }
        this.doLog(level, "{}", aMessage);
    }

    public void log(String aMessage, Object aParam) {
        this.doLog(LogLevel.Debug, "{}, data: {}", aMessage, aParam);
    }

    public void log(String aMessage) {
        this.doLog(LogLevel.Debug, "{}", aMessage);
    }

    protected static enum LogLevel {
        Trace(0),
        Debug(0),
        Info(1),
        Warning(2),
        Error(4),
        Fatal(4);

        private final int severity;

        private LogLevel(int severity) {
            this.severity = severity;
        }

        public int toSeverity() {
            return this.severity;
        }

        public static LogLevel valueOf(String string) {
            return Enum.valueOf(LogLevel.class, string);
        }
    }

    private static enum LogParameterFormat {
        Data,
        Single,
        Multi;


        public static LogParameterFormat valueOf(String string) {
            return Enum.valueOf(LogParameterFormat.class, string);
        }
    }
}

