/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Iterator;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFile;

public class RemoveIoDecls
implements CifToCifTransformation {
    private final boolean removePrintDecls;
    private final boolean removeCifSvgDecls;

    public RemoveIoDecls() {
        this(true, true);
    }

    public RemoveIoDecls(boolean removePrintDecls, boolean removeCifSvgDecls) {
        this.removePrintDecls = removePrintDecls;
        this.removeCifSvgDecls = removeCifSvgDecls;
    }

    @Override
    public void transform(Specification spec) {
        this.removeIoDecls((ComplexComponent)spec);
    }

    private void removeIoDecls(ComplexComponent comp) {
        if (!comp.getIoDecls().isEmpty()) {
            if (this.removePrintDecls && this.removeCifSvgDecls) {
                comp.getIoDecls().clear();
            } else {
                Iterator iter = comp.getIoDecls().iterator();
                while (iter.hasNext()) {
                    IoDecl decl = (IoDecl)iter.next();
                    boolean remove = false;
                    remove |= this.removePrintDecls && (decl instanceof Print || decl instanceof PrintFile);
                    if (!(remove |= this.removeCifSvgDecls && (decl instanceof SvgCopy || decl instanceof SvgFile || decl instanceof SvgIn || decl instanceof SvgOut || decl instanceof SvgMove))) continue;
                    iter.remove();
                }
            }
        }
        if (comp instanceof Group) {
            for (Component child : ((Group)comp).getComponents()) {
                if (child instanceof ComponentInst) continue;
                this.removeIoDecls((ComplexComponent)child);
            }
        }
        if (comp instanceof Group) {
            for (ComponentDef def : ((Group)comp).getDefinitions()) {
                this.removeIoDecls(def.getBody());
            }
        }
    }
}

