/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.p2order;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.mrtree.ILayoutPhase;
import org.eclipse.elk.alg.mrtree.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.mrtree.TreeUtil;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.mrtree.properties.InternalProperties;
import org.eclipse.elk.alg.mrtree.properties.MrTreeOptions;
import org.eclipse.elk.alg.mrtree.properties.OrderWeighting;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.properties.IProperty;

public class OrderBalance
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = new IntermediateProcessingConfiguration(1, EnumSet.of(IntermediateProcessorStrategy.ROOT_PROC, IntermediateProcessorStrategy.FAN_PROC, IntermediateProcessorStrategy.NEIGHBORS_PROC));
    private IProperty<Integer> weighting;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(TGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        TNode lM;
        progressMonitor.begin("Processor arrange node", 1.0f);
        this.weighting = ((OrderWeighting)((Object)tGraph.getProperty(MrTreeOptions.WEIGHTING))).equals((Object)OrderWeighting.DESCENDANTS) ? InternalProperties.DESCENDANTS : InternalProperties.FAN;
        TNode root = null;
        Iterator<TNode> it = tGraph.getNodes().iterator();
        while (root == null && it.hasNext()) {
            TNode tNode = it.next();
            if (!((Boolean)tNode.getProperty(InternalProperties.ROOT)).booleanValue()) continue;
            root = tNode;
        }
        if (root != null && (lM = TreeUtil.getLeftMost(root.getChildren())) != null && lM.getParent() != root) {
            TNode parent;
            TNode leftMost = parent = lM.getParent().getParent();
            while (leftMost.getProperty(InternalProperties.LEFTNEIGHBOR) != null) {
                leftMost = (TNode)((Object)leftMost.getProperty(InternalProperties.LEFTNEIGHBOR));
            }
            this.orderLevel(leftMost, false);
            for (TNode tNode : tGraph.getNodes()) {
                tNode.setProperty(InternalProperties.RIGHTNEIGHBOR, null);
                tNode.setProperty(InternalProperties.LEFTNEIGHBOR, null);
                tNode.setProperty(InternalProperties.RIGHTSIBLING, null);
                tNode.setProperty(InternalProperties.LEFTSIBLING, null);
            }
        }
    }

    private void orderLevel(TNode leftMost, boolean odd) {
        if (leftMost != null) {
            TNode currentNode = leftMost;
            while (currentNode != null) {
                List<TEdge> outgoing = currentNode.getOutgoingEdges();
                Collections.sort(outgoing, new SortTEdgeTargetProperty(this.weighting));
                LinkedList<TEdge> balanced = new LinkedList<TEdge>();
                boolean innerOdd = odd;
                while (!outgoing.isEmpty()) {
                    int index;
                    int gaps = (Integer)outgoing.get(0).getTarget().getProperty(InternalProperties.FAN);
                    if (innerOdd) {
                        index = balanced.size();
                        balanced.add(outgoing.get(0));
                    } else {
                        index = 0;
                        balanced.add(index, outgoing.get(0));
                    }
                    outgoing.remove(0);
                    innerOdd = !innerOdd;
                    int indexEnd = outgoing.size();
                    boolean leavesOdd = odd;
                    while (gaps > 0 && indexEnd > 0) {
                        if (outgoing.get(--indexEnd).getTarget().isLeaf()) {
                            --gaps;
                            if (leavesOdd) {
                                balanced.add(outgoing.get(indexEnd));
                            } else {
                                balanced.add(index, outgoing.get(indexEnd));
                            }
                            outgoing.remove(indexEnd);
                            leavesOdd = !leavesOdd;
                            continue;
                        }
                        gaps = 0;
                    }
                }
                currentNode.getOutgoingEdges().addAll(balanced);
                currentNode = (TNode)((Object)currentNode.getProperty(InternalProperties.RIGHTNEIGHBOR));
            }
            this.orderLevel(leftMost.getParent(), !odd);
        }
    }

    private static class SortTEdgeTargetProperty
    implements Comparator<TEdge> {
        private IProperty<Integer> property;

        SortTEdgeTargetProperty(IProperty<Integer> property) {
            this.property = property;
        }

        @Override
        public int compare(TEdge t1, TEdge t2) {
            return (Integer)t2.getTarget().getProperty(this.property) - (Integer)t1.getTarget().getProperty(this.property);
        }
    }
}

