/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.mrtree.intermediate.IntermediateProcessorStrategy;

public final class IntermediateProcessingConfiguration {
    public static final int BEFORE_PHASE_1 = 0;
    public static final int AFTER_PHASE_1 = 1;
    public static final int BEFORE_PHASE_2 = 1;
    public static final int AFTER_PHASE_2 = 2;
    public static final int BEFORE_PHASE_3 = 2;
    public static final int AFTER_PHASE_3 = 3;
    public static final int BEFORE_PHASE_4 = 3;
    public static final int AFTER_PHASE_4 = 4;
    public static final int INTERMEDIATE_PHASE_SLOTS = 5;
    private List<Set<IntermediateProcessorStrategy>> strategy = new ArrayList<Set<IntermediateProcessorStrategy>>(5);

    public IntermediateProcessingConfiguration() {
        int i = 0;
        while (i < 5) {
            this.strategy.add(EnumSet.noneOf(IntermediateProcessorStrategy.class));
            ++i;
        }
    }

    public IntermediateProcessingConfiguration(IntermediateProcessingConfiguration init) {
        int i = 0;
        while (i < 5) {
            this.strategy.add(EnumSet.copyOf(init.strategy.get(i)));
            ++i;
        }
    }

    public IntermediateProcessingConfiguration(int slotIndex, IntermediateProcessorStrategy processor) {
        this();
        this.addAll(slotIndex, EnumSet.of(processor));
    }

    public IntermediateProcessingConfiguration(int slotIndex, Collection<IntermediateProcessorStrategy> processors) {
        this();
        this.addAll(slotIndex, processors);
    }

    public IntermediateProcessingConfiguration(Collection<IntermediateProcessorStrategy> beforePhase1, Collection<IntermediateProcessorStrategy> beforePhase2) {
        this();
        this.addAll(0, beforePhase1).addAll(1, beforePhase2);
    }

    public IntermediateProcessingConfiguration(Collection<IntermediateProcessorStrategy> beforePhase1, Collection<IntermediateProcessorStrategy> beforePhase2, Collection<IntermediateProcessorStrategy> beforePhase3) {
        this();
        this.addAll(0, beforePhase1).addAll(1, beforePhase2).addAll(2, beforePhase3);
    }

    public IntermediateProcessingConfiguration(Collection<IntermediateProcessorStrategy> beforePhase1, Collection<IntermediateProcessorStrategy> beforePhase2, Collection<IntermediateProcessorStrategy> beforePhase3, Collection<IntermediateProcessorStrategy> beforePhase4) {
        this();
        this.addAll(0, beforePhase1).addAll(1, beforePhase2).addAll(2, beforePhase3).addAll(3, beforePhase4);
    }

    public EnumSet<IntermediateProcessorStrategy> getProcessors(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= 5) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 5.");
        }
        return EnumSet.copyOf(this.strategy.get(slotIndex));
    }

    public void addLayoutProcessor(int slotIndex, IntermediateProcessorStrategy processor) {
        if (slotIndex < 0 || slotIndex >= 5) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 5.");
        }
        this.strategy.get(slotIndex).add(processor);
    }

    public IntermediateProcessingConfiguration addAll(int slotIndex, Collection<IntermediateProcessorStrategy> processors) {
        if (slotIndex < 0 || slotIndex >= 5) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 5.");
        }
        if (processors != null) {
            this.strategy.get(slotIndex).addAll(processors);
        }
        return this;
    }

    public IntermediateProcessingConfiguration addAll(IntermediateProcessingConfiguration operand) {
        if (operand != null) {
            int i = 0;
            while (i < 5) {
                this.strategy.get(i).addAll((Collection<IntermediateProcessorStrategy>)operand.strategy.get(i));
                ++i;
            }
        }
        return this;
    }

    public void removeLayoutProcessor(int slotIndex, IntermediateProcessorStrategy processor) {
        if (slotIndex < 0 || slotIndex >= 5) {
            throw new IllegalArgumentException("slotIndex must be >= 0 and < 5.");
        }
        this.strategy.get(slotIndex).remove((Object)processor);
    }

    public void clear() {
        for (Set<IntermediateProcessorStrategy> set : this.strategy) {
            set.clear();
        }
    }
}

