/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.verify;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.verify.ResultNode;

public final class SpecNode {
    private final TraceView view;
    private final File specFile;
    private final List<ResultNode> results = new ArrayList<ResultNode>();

    public SpecNode(File f, TraceView v) {
        this.specFile = f;
        this.view = v;
        this.results.add(new ResultNode(InformativePrefix.BAD, this.view));
        this.results.add(new ResultNode(InformativePrefix.GOOD, this.view));
        this.results.add(new ResultNode(InformativePrefix.NON_INFORMATIVE, this.view));
    }

    public File getSpecFile() {
        return this.specFile;
    }

    public List<ResultNode> getResults() {
        return this.results;
    }

    public void add(VerificationResult vr) {
        for (ResultNode r : this.results) {
            r.add(vr);
        }
    }

    public boolean refreshSpecNode(long lastModified) {
        lastModified = Math.max(lastModified, this.specFile.lastModified());
        boolean allEmpty = true;
        for (ResultNode rn : this.results) {
            boolean emptyResultNode = rn.refresh(lastModified);
            allEmpty = emptyResultNode & allEmpty;
        }
        return allEmpty;
    }
}

