/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.awt.Paint;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.ui.AnalysisUtil;
import org.eclipse.trace4cps.ui.dialog.BehaviorWizard;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;

public class BehaviorClassesAction
extends AbstractTraceViewAction {
    public BehaviorClassesAction(TraceView view) {
        super(view);
        this.setText("Behavioral classes");
    }

    public boolean isEnabled() {
        return this.view.getNumTraces() == 1 && this.view.hasClaims(true);
    }

    @Override
    protected void doRun() throws TraceException {
        BehaviorWizard wizard = new BehaviorWizard(this.view);
        if (new WizardDialog(this.view.getEditorSite().getShell(), (IWizard)wizard).open() == 1) {
            return;
        }
        String idAtt = wizard.getIdAttribute();
        Set<String> uniqueness = wizard.getUniqueness();
        Map<IAttributeAware, Paint> hl = AnalysisUtil.computeAnomalyHistogramHighlight(this.view.getTrace(), idAtt, uniqueness);
        this.viewCfg.setHighlightMap(hl);
        this.view.update();
    }
}

