/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.CrossingMatrixFiller;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.NorthSouthEdgeNeighbouringNodeCrossingsCounter;
import org.eclipse.elk.alg.layered.p3order.GraphInfoHolder;
import org.eclipse.elk.alg.layered.p3order.counting.CrossingsCounter;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public final class SwitchDecider {
    private final LNode[] freeLayer;
    private final CrossingsCounter leftInLayerCounter;
    private final CrossingsCounter rightInLayerCounter;
    private final NorthSouthEdgeNeighbouringNodeCrossingsCounter northSouthCounter;
    private final CrossingMatrixFiller crossingMatrixFiller;
    private GraphInfoHolder graphData;
    private CrossingsCounter parentCrossCounter;
    private boolean countCrossingsCausedByPortSwitch;

    public SwitchDecider(int freeLayerIndex, LNode[][] graph, CrossingMatrixFiller crossingMatrixFiller, int[] portPositions, GraphInfoHolder graphData, boolean oneSided) {
        this.crossingMatrixFiller = crossingMatrixFiller;
        this.graphData = graphData;
        if (freeLayerIndex >= graph.length) {
            throw new IndexOutOfBoundsException("Greedy SwitchDecider: Free layer not in graph.");
        }
        this.freeLayer = graph[freeLayerIndex];
        this.leftInLayerCounter = new CrossingsCounter(portPositions);
        this.leftInLayerCounter.initPortPositionsForInLayerCrossings(this.freeLayer, PortSide.WEST);
        this.rightInLayerCounter = new CrossingsCounter(portPositions);
        this.rightInLayerCounter.initPortPositionsForInLayerCrossings(this.freeLayer, PortSide.EAST);
        this.northSouthCounter = new NorthSouthEdgeNeighbouringNodeCrossingsCounter(this.freeLayer);
        boolean bl = this.countCrossingsCausedByPortSwitch = !oneSided && graphData.hasParent() && !graphData.dontSweepInto() && this.freeLayer[0].getType() == LNode.NodeType.EXTERNAL_PORT;
        if (this.countCrossingsCausedByPortSwitch) {
            this.initParentCrossingsCounters(freeLayerIndex, graph.length);
        }
    }

    private void initParentCrossingsCounters(int freeLayerIndex, int length) {
        boolean rightMostLayer;
        GraphInfoHolder parentGraphData = this.graphData.parentGraphData();
        LNode[][] parentNodeOrder = parentGraphData.currentNodeOrder();
        int[] portPos = parentGraphData.portPositions();
        this.parentCrossCounter = new CrossingsCounter(portPos);
        int parentNodeLayerPos = this.graphData.parent().getLayer().id;
        LNode[] leftLayer = parentNodeLayerPos > 0 ? parentNodeOrder[parentNodeLayerPos - 1] : new LNode[]{};
        LNode[] middleLayer = parentNodeOrder[parentNodeLayerPos];
        LNode[] rightLayer = parentNodeLayerPos < parentNodeOrder.length - 1 ? parentNodeOrder[parentNodeLayerPos + 1] : new LNode[]{};
        boolean bl = rightMostLayer = freeLayerIndex == length - 1;
        if (rightMostLayer) {
            this.parentCrossCounter.initForCountingBetween(middleLayer, rightLayer);
        } else {
            this.parentCrossCounter.initForCountingBetween(leftLayer, middleLayer);
        }
    }

    public void notifyOfSwitch(LNode upperNode, LNode lowerNode) {
        this.leftInLayerCounter.switchNodes(upperNode, lowerNode, PortSide.WEST);
        this.rightInLayerCounter.switchNodes(upperNode, lowerNode, PortSide.EAST);
        if (this.countCrossingsCausedByPortSwitch) {
            LPort upperPort = (LPort)((Object)upperNode.getProperty(InternalProperties.ORIGIN));
            LPort lowerPort = (LPort)((Object)lowerNode.getProperty(InternalProperties.ORIGIN));
            this.parentCrossCounter.switchPorts(upperPort, lowerPort);
        }
    }

    public boolean doesSwitchReduceCrossings(int upperNodeIndex, int lowerNodeIndex) {
        if (this.constraintsPreventSwitch(upperNodeIndex, lowerNodeIndex)) {
            return false;
        }
        LNode upperNode = this.freeLayer[upperNodeIndex];
        LNode lowerNode = this.freeLayer[lowerNodeIndex];
        Pair<Integer, Integer> leftInlayer = this.leftInLayerCounter.countInLayerCrossingsBetweenNodesInBothOrders(upperNode, lowerNode, PortSide.WEST);
        Pair<Integer, Integer> rightInlayer = this.rightInLayerCounter.countInLayerCrossingsBetweenNodesInBothOrders(upperNode, lowerNode, PortSide.EAST);
        this.northSouthCounter.countCrossings(upperNode, lowerNode);
        int upperLowerCrossings = this.crossingMatrixFiller.getCrossingMatrixEntry(upperNode, lowerNode) + (Integer)leftInlayer.getFirst() + (Integer)rightInlayer.getFirst() + this.northSouthCounter.getUpperLowerCrossings();
        int lowerUpperCrossings = this.crossingMatrixFiller.getCrossingMatrixEntry(lowerNode, upperNode) + (Integer)leftInlayer.getSecond() + (Integer)rightInlayer.getSecond() + this.northSouthCounter.getLowerUpperCrossings();
        if (this.countCrossingsCausedByPortSwitch) {
            LPort upperPort = (LPort)((Object)upperNode.getProperty(InternalProperties.ORIGIN));
            LPort lowerPort = (LPort)((Object)lowerNode.getProperty(InternalProperties.ORIGIN));
            Pair<Integer, Integer> crossingNumbers = this.parentCrossCounter.countCrossingsBetweenPortsInBothOrders(upperPort, lowerPort);
            upperLowerCrossings += ((Integer)crossingNumbers.getFirst()).intValue();
            lowerUpperCrossings += ((Integer)crossingNumbers.getSecond()).intValue();
        }
        return upperLowerCrossings > lowerUpperCrossings;
    }

    private boolean constraintsPreventSwitch(int nodeIndex, int lowerNodeIndex) {
        LNode upperNode = this.freeLayer[nodeIndex];
        LNode lowerNode = this.freeLayer[lowerNodeIndex];
        return this.haveSuccessorConstraints(upperNode, lowerNode) || this.haveLayoutUnitConstraints(upperNode, lowerNode) || this.areNormalAndNorthSouthPortDummy(upperNode, lowerNode);
    }

    private boolean haveSuccessorConstraints(LNode upperNode, LNode lowerNode) {
        List constraints = (List)upperNode.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS);
        boolean hasSuccessorConstraint = constraints != null && constraints.size() != 0 && constraints.contains((Object)lowerNode);
        return hasSuccessorConstraint;
    }

    private boolean haveLayoutUnitConstraints(LNode upperNode, LNode lowerNode) {
        boolean hasLayoutUnitConstraint;
        boolean neitherNodeIsLongEdgeDummy = upperNode.getType() != LNode.NodeType.LONG_EDGE && lowerNode.getType() != LNode.NodeType.LONG_EDGE;
        LNode upperLayoutUnit = (LNode)((Object)upperNode.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
        LNode lowerLayoutUnit = (LNode)((Object)lowerNode.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
        boolean nodesHaveLayoutUnits = this.partOfMultiNodeLayoutUnit(upperNode, upperLayoutUnit) || this.partOfMultiNodeLayoutUnit(lowerNode, lowerLayoutUnit);
        boolean areInDifferentLayoutUnits = upperLayoutUnit != lowerLayoutUnit;
        boolean upperNodeHasNorthernEdges = this.hasEdgesOnSide(upperNode, PortSide.NORTH);
        boolean lowerNodeHasSouthernEdges = this.hasEdgesOnSide(lowerNode, PortSide.SOUTH);
        boolean bl = hasLayoutUnitConstraint = nodesHaveLayoutUnits && areInDifferentLayoutUnits || upperNodeHasNorthernEdges || lowerNodeHasSouthernEdges;
        return neitherNodeIsLongEdgeDummy && hasLayoutUnitConstraint;
    }

    private boolean hasEdgesOnSide(LNode node, PortSide side) {
        List<LPort> ports = node.getPortSideView(side);
        for (LPort port : ports) {
            if (port.getProperty(InternalProperties.PORT_DUMMY) == null && !port.getConnectedEdges().iterator().hasNext()) continue;
            return true;
        }
        return false;
    }

    private boolean partOfMultiNodeLayoutUnit(LNode node, LNode layoutUnit) {
        return layoutUnit != null && layoutUnit != node;
    }

    private boolean areNormalAndNorthSouthPortDummy(LNode upperNode, LNode lowerNode) {
        return this.isNorthSouthPortNode(upperNode) && this.isNormalNode(lowerNode) || this.isNorthSouthPortNode(lowerNode) && this.isNormalNode(upperNode);
    }

    private boolean isNormalNode(LNode node) {
        return node.getType() == LNode.NodeType.NORMAL;
    }

    private boolean isNorthSouthPortNode(LNode node) {
        return node.getType() == LNode.NodeType.NORTH_SOUTH_PORT;
    }

    public static enum CrossingCountSide {
        WEST,
        EAST;

    }
}

