/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.LongEdgeSplitter;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LabelDummyInserter
implements ILayoutProcessor {
    private static final Predicate<LLabel> CENTER_LABEL = new Predicate<LLabel>(){

        public boolean apply(LLabel label) {
            return label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.CENTER;
        }
    };

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label dummy insertions", 1.0f);
        ArrayList newDummyNodes = Lists.newArrayList();
        double labelSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_LABEL);
        Direction layoutDirection = (Direction)layeredGraph.getProperty(LayeredOptions.DIRECTION);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    if (edge.getSource().getNode() == edge.getTarget().getNode() || !Iterables.any(edge.getLabels(), CENTER_LABEL)) continue;
                    ArrayList representedLabels = Lists.newArrayListWithCapacity((int)edge.getLabels().size());
                    LNode dummyNode = new LNode(layeredGraph);
                    dummyNode.setType(LNode.NodeType.LABEL);
                    dummyNode.setProperty(InternalProperties.ORIGIN, (Object)edge);
                    dummyNode.setProperty(InternalProperties.REPRESENTED_LABELS, representedLabels);
                    dummyNode.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
                    dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, (Object)edge.getSource());
                    dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, (Object)edge.getTarget());
                    newDummyNodes.add(dummyNode);
                    LongEdgeSplitter.splitEdge(edge, dummyNode);
                    double thickness = (Double)edge.getProperty(LayeredOptions.EDGE_THICKNESS);
                    if (thickness < 0.0) {
                        thickness = 0.0;
                        edge.setProperty(LayeredOptions.EDGE_THICKNESS, thickness);
                    }
                    double portPos = Math.floor(thickness / 2.0);
                    for (LPort dummyPort : dummyNode.getPorts()) {
                        dummyPort.getPosition().y = portPos;
                    }
                    KVector dummySize = dummyNode.getSize();
                    ListIterator<LLabel> iterator = edge.getLabels().listIterator();
                    while (iterator.hasNext()) {
                        LLabel label = iterator.next();
                        if (label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) != EdgeLabelPlacement.CENTER) continue;
                        if (layoutDirection.isVertical()) {
                            dummySize.x += label.getSize().x + labelSpacing;
                            dummySize.y = Math.max(dummySize.y, label.getSize().y);
                        } else {
                            dummySize.x = Math.max(dummySize.x, label.getSize().x);
                            dummySize.y += label.getSize().y + labelSpacing;
                        }
                        representedLabels.add(label);
                        iterator.remove();
                    }
                    if (layoutDirection.isVertical()) {
                        dummySize.x -= labelSpacing;
                        dummySize.y += labelSpacing + thickness;
                        continue;
                    }
                    dummySize.y += labelSpacing + thickness;
                }
            }
        }
        layeredGraph.getLayerlessNodes().addAll(newDummyNodes);
        monitor.done();
    }
}

