/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import java.util.Collection;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;

abstract class AbstractGraphPlacer {
    AbstractGraphPlacer() {
    }

    public abstract void combine(List<LGraph> var1, LGraph var2);

    protected void moveGraphs(LGraph destGraph, Collection<LGraph> sourceGraphs, double offsetx, double offsety) {
        for (LGraph sourceGraph : sourceGraphs) {
            this.moveGraph(destGraph, sourceGraph, offsetx, offsety);
        }
    }

    protected void moveGraph(LGraph destGraph, LGraph sourceGraph, double offsetx, double offsety) {
        KVector graphOffset = sourceGraph.getOffset().add(offsetx, offsety);
        for (LNode node : sourceGraph.getLayerlessNodes()) {
            node.getPosition().add(graphOffset);
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    edge.getBendPoints().offset(graphOffset);
                    KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        junctionPoints.offset(graphOffset);
                    }
                    for (LLabel label : edge.getLabels()) {
                        label.getPosition().add(graphOffset);
                    }
                }
            }
            destGraph.getLayerlessNodes().add(node);
            node.setGraph(destGraph);
        }
    }

    protected void offsetGraphs(Collection<LGraph> graphs, double offsetx, double offsety) {
        for (LGraph graph : graphs) {
            this.offsetGraph(graph, offsetx, offsety);
        }
    }

    protected void offsetGraph(LGraph graph, double offsetx, double offsety) {
        KVector graphOffset = new KVector(offsetx, offsety);
        for (LNode node : graph.getLayerlessNodes()) {
            node.getPosition().add(graphOffset);
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    edge.getBendPoints().offset(graphOffset);
                    KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        junctionPoints.offset(graphOffset);
                    }
                    for (LLabel label : edge.getLabels()) {
                        label.getPosition().add(graphOffset);
                    }
                }
            }
        }
    }
}

