/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timinganalysis.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TimingAnalysisLaunchMainTab
extends AbstractLaunchConfigurationTab
implements TimingAnalysisLaunchAttributes {
    private DataBindingContext m_bindingContext;
    private final SelectionListener checkbox_selection_listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TimingAnalysisLaunchMainTab.this.scheduleUpdateJob();
        }
    };
    private Text textModelIFile;
    private Text textSettingIFile;
    private Button btnPaperscript;
    private Group grpGanttType;
    private Button btnGantt;
    private Button btnCriticalPathGantt;
    private Button btnNoGantt;
    private Button btnRemoveClaimReleaseDependencies;
    private Button btnStochasticImpact;

    public String getName() {
        return "Timing Analysis";
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout();
        container.setLayout((Layout)gl_container);
        container.setLayoutData((Object)new GridData(1808));
        this.textModelIFile = this.createFileDialog(container, "Activity Dispatching", "dispatching");
        this.textSettingIFile = this.createFileDialog(container, "Physical settings file", "setting");
        this.grpGanttType = new Group(container, 0);
        this.grpGanttType.setLayout((Layout)new GridLayout(1, false));
        this.grpGanttType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpGanttType.setText("Show");
        this.btnNoGantt = new Button((Composite)this.grpGanttType, 16);
        this.btnNoGantt.setText("no Gantt chart");
        this.btnNoGantt.addSelectionListener(this.checkbox_selection_listener);
        this.btnGantt = new Button((Composite)this.grpGanttType, 16);
        this.btnGantt.addSelectionListener(this.checkbox_selection_listener);
        this.btnGantt.setText("Gantt chart");
        this.btnCriticalPathGantt = new Button((Composite)this.grpGanttType, 16);
        this.btnCriticalPathGantt.setText("Gantt chart with critical path");
        this.btnCriticalPathGantt.addSelectionListener(this.checkbox_selection_listener);
        this.btnStochasticImpact = new Button((Composite)this.grpGanttType, 16);
        this.btnStochasticImpact.setText("Gantt chart using stochastic impact analysis");
        this.btnStochasticImpact.addSelectionListener(this.checkbox_selection_listener);
        Group grpOptions = new Group(container, 0);
        grpOptions.setLayout((Layout)new GridLayout(1, false));
        grpOptions.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpOptions.setText("Options");
        this.btnPaperscript = new Button((Composite)grpOptions, 32);
        this.btnPaperscript.setText("Show web animation");
        this.btnPaperscript.addSelectionListener(this.checkbox_selection_listener);
        this.btnRemoveClaimReleaseDependencies = new Button((Composite)grpOptions, 32);
        this.btnRemoveClaimReleaseDependencies.setText("Remove dependencies for claims and releases");
        this.btnRemoveClaimReleaseDependencies.addSelectionListener(this.checkbox_selection_listener);
        this.m_bindingContext = this.initDataBindings();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.textModelIFile.setText(configuration.getAttribute(MODEL_IFILE, ""));
            this.textSettingIFile.setText(configuration.getAttribute(SETTING_IFILE, ""));
            this.btnNoGantt.setSelection(configuration.getAttribute(NO_GANTT_CHART, false));
            this.btnGantt.setSelection(configuration.getAttribute(GANTT_CHART, true));
            this.btnCriticalPathGantt.setSelection(configuration.getAttribute(CRITICAL_PATH, false));
            this.btnStochasticImpact.setSelection(configuration.getAttribute(STOCHASTIC_IMPACT, false));
            this.btnPaperscript.setSelection(configuration.getAttribute(PAPERSCRIPT_ANIMATION, false));
            this.btnRemoveClaimReleaseDependencies.setSelection(configuration.getAttribute(REMOVE_CLAIMS_RELEASES_DEPENDENCIES, false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IFile settingIFile;
        IFile modelIFile = TimingAnalysisLaunchMainTab.getSelectedIFile(this.textModelIFile);
        ArrayList<IFile> mappedResources = new ArrayList<IFile>();
        if (modelIFile != null) {
            configuration.setAttribute(MODEL_IFILE, modelIFile.getFullPath().toString());
            mappedResources.add(modelIFile);
        }
        if ((settingIFile = TimingAnalysisLaunchMainTab.getSelectedIFile(this.textSettingIFile)) != null) {
            configuration.setAttribute(SETTING_IFILE, settingIFile.getFullPath().toString());
            mappedResources.add(settingIFile);
        }
        configuration.setMappedResources(mappedResources.toArray(new IResource[mappedResources.size()]));
        configuration.setAttribute(NO_GANTT_CHART, this.btnNoGantt.getSelection());
        configuration.setAttribute(GANTT_CHART, this.btnGantt.getSelection());
        configuration.setAttribute(CRITICAL_PATH, this.btnCriticalPathGantt.getSelection());
        configuration.setAttribute(STOCHASTIC_IMPACT, this.btnStochasticImpact.getSelection());
        configuration.setAttribute(PAPERSCRIPT_ANIMATION, this.btnPaperscript.getSelection());
        configuration.setAttribute(REMOVE_CLAIMS_RELEASES_DEPENDENCIES, this.btnRemoveClaimReleaseDependencies.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        if (TimingAnalysisLaunchMainTab.getSelectedIFile(this.textModelIFile) == null) {
            this.setErrorMessage("Please select an existing activity dispatching file");
            return false;
        }
        if (TimingAnalysisLaunchMainTab.getSelectedIFile(this.textSettingIFile) == null) {
            this.setWarningMessage("Physical settings file not selected. The project default will be used");
            return true;
        }
        String preferredName = this.getPreferredName();
        ArrayList<String> possibleNames = new ArrayList<String>(Arrays.asList(this.getPreferredName(TimingAnalysisLaunchAttributes.GANTT_CHART), this.getPreferredName(TimingAnalysisLaunchAttributes.CRITICAL_PATH), this.getPreferredName(TimingAnalysisLaunchAttributes.STOCHASTIC_IMPACT), this.getPreferredName(TimingAnalysisLaunchAttributes.NO_GANTT_CHART)));
        possibleNames.remove(this.getPreferredName());
        if (possibleNames.contains(launchConfig.getName())) {
            this.setWarningMessage("Reserved name, consider change to: " + preferredName);
            return true;
        }
        return true;
    }

    private Text createFileDialog(Composite container, String title, final String fileExtension) {
        Group grpActivityDispatching = new Group(container, 0);
        grpActivityDispatching.setLayout((Layout)new GridLayout(2, false));
        grpActivityDispatching.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpActivityDispatching.setText(title);
        final Text textField = new Text((Composite)grpActivityDispatching, 2048);
        textField.setEditable(false);
        textField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowseMdl = new Button((Composite)grpActivityDispatching, 0);
        btnBrowseMdl.setText("Browse...");
        btnBrowseMdl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile iFile = TimingAnalysisLaunchMainTab.this.selectFile(fileExtension, textField);
                if (iFile != null) {
                    textField.setText(iFile.getFullPath().toString());
                    TimingAnalysisLaunchMainTab.this.scheduleUpdateJob();
                }
            }
        });
        return textField;
    }

    private String getPreferredName(String showTargetName) {
        return TimingAnalysisUtil.getLaunchName(TimingAnalysisLaunchMainTab.getSelectedIFile(this.textModelIFile), TimingAnalysisLaunchMainTab.getSelectedIFile(this.textSettingIFile), showTargetName);
    }

    private String getPreferredName() {
        if (this.btnPaperscript.getSelection() || this.btnRemoveClaimReleaseDependencies.getSelection()) {
            return null;
        }
        return TimingAnalysisUtil.getLaunchName(TimingAnalysisLaunchMainTab.getSelectedIFile(this.textModelIFile), TimingAnalysisLaunchMainTab.getSelectedIFile(this.textSettingIFile), this.getSelectedShow());
    }

    private String getSelectedShow() {
        if (this.btnGantt.getSelection()) {
            return GANTT_CHART;
        }
        if (this.btnCriticalPathGantt.getSelection()) {
            return CRITICAL_PATH;
        }
        if (this.btnStochasticImpact.getSelection()) {
            return STOCHASTIC_IMPACT;
        }
        return NO_GANTT_CHART;
    }

    private IFile selectFile(final String fileExtension, Text field) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle("Select " + fileExtension + " file");
        dialog.setMessage("Select " + fileExtension + " file to execute scheduling");
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return Objects.equals(((IFile)element).getFileExtension(), fileExtension);
                }
                return element instanceof IContainer;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length <= 0) {
                    return new Status(4, "org.eclipse.lsat.timinganalysis.ui", 0, "Please select a " + fileExtension + " file!", null);
                }
                return new Status(0, "org.eclipse.lsat.timinganalysis.ui", 0, "OK", null);
            }
        });
        IFile selectedFile = TimingAnalysisLaunchMainTab.getSelectedIFile(field);
        if (selectedFile != null) {
            dialog.setInitialSelection((Object)selectedFile);
        }
        dialog.open();
        return (IFile)dialog.getFirstResult();
    }

    private static IFile getSelectedIFile(Text textField) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path modelIPath = new Path(textField.getText());
        if (!modelIPath.isEmpty() && wsRoot.exists((IPath)modelIPath)) {
            return wsRoot.getFile((IPath)modelIPath);
        }
        return null;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

