/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.lsat.common.ludus.backend.graph.Graph;

public class Tarjan<V, E> {
    private Stack<V> stack;
    private List<Set<V>> components;
    private Map<V, Integer> indexMap;
    private Map<V, Integer> lowlinkMap;
    private Integer index;

    public List<Set<V>> computeSCCs(Graph<V, E> graph) {
        this.stack = new Stack();
        this.components = new ArrayList<Set<V>>();
        this.indexMap = new HashMap<V, Integer>();
        this.lowlinkMap = new HashMap<V, Integer>();
        this.index = 0;
        for (V v : graph.getVertices()) {
            if (this.indexMap.containsKey(v)) continue;
            this.computeSCC(graph, v);
        }
        return this.components;
    }

    private void computeSCC(Graph<V, E> graph, V v) {
        this.indexMap.put((Integer)v, this.index);
        this.lowlinkMap.put((Integer)v, this.index);
        this.index = this.index + 1;
        this.stack.push(v);
        for (E e : graph.outgoingEdgesOf(v)) {
            V w = graph.getEdgeTarget(e);
            if (!this.indexMap.containsKey(w)) {
                this.computeSCC(graph, w);
                this.lowlinkMap.put((Integer)v, Math.min(this.lowlinkMap.get(v), this.lowlinkMap.get(w)));
                continue;
            }
            if (!this.stack.contains(w)) continue;
            this.lowlinkMap.put((Integer)v, Math.min(this.lowlinkMap.get(v), this.indexMap.get(w)));
        }
        if (this.lowlinkMap.get(v).equals(this.indexMap.get(v))) {
            V w;
            HashSet<V> scc = new HashSet<V>();
            do {
                w = this.stack.pop();
                scc.add(w);
            } while (!w.equals(v));
            this.components.add(scc);
        }
    }
}

