/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.lsat.motioncalculator.MotionProfile;
import org.eclipse.lsat.motioncalculator.MotionProfileParameter;

public final class MotionSetPoint
implements Serializable {
    private static final long serialVersionUID = 2406048417109387877L;
    private final String id;
    private BigDecimal from;
    private BigDecimal to;
    private BigDecimal distance;
    private boolean settling;
    private String motionProfileId;
    private transient MotionProfile motionProfile;
    private final Map<String, BigDecimal> arguments = new LinkedHashMap<String, BigDecimal>();

    public MotionSetPoint(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public BigDecimal getFrom() {
        return this.from;
    }

    public void setFrom(BigDecimal from) {
        this.from = from;
    }

    public BigDecimal getTo() {
        return this.to;
    }

    public void setTo(BigDecimal to) {
        this.to = to;
    }

    public BigDecimal getDistance() {
        return this.distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }

    public boolean doesMove() {
        return this.distance.compareTo(BigDecimal.ZERO) != 0;
    }

    public void setSettling(boolean settling) {
        this.settling = settling;
    }

    public boolean isSettling() {
        return this.settling;
    }

    public MotionProfile getMotionProfile() {
        return this.motionProfile;
    }

    public void setMotionProfile(MotionProfile motionProfile) {
        this.motionProfile = motionProfile;
        this.motionProfileId = this.motionProfile != null ? this.motionProfile.getKey() : null;
    }

    public Map<String, BigDecimal> getMotionProfileArguments() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public void setMotionProfileArgument(String key, BigDecimal value) {
        this.arguments.put(key, value);
    }

    public BigDecimal getMotionProfileArgument(String key) {
        return this.getMotionProfileArgument(key, null);
    }

    public BigDecimal getMotionProfileArgument(String key, BigDecimal defaultValue) throws IllegalArgumentException {
        MotionProfileParameter parameter;
        if (this.motionProfile != null && (parameter = this.motionProfile.getParameter(key)) == null) {
            throw new IllegalArgumentException(String.format("Programming error: Motion profile %s does not define parameter %s", this.motionProfile.getName(), key));
        }
        return this.arguments.getOrDefault(key, defaultValue);
    }

    public String toString() {
        return String.format("Distance=%f, From=%f, To=%f, %s", this.distance, this.from, this.to, this.motionProfileId);
    }
}

