/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.mandas.docker.AllowNulls;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.AttachedNetwork;
import org.mandas.docker.client.messages.ImmutableNetworkSettings;
import org.mandas.docker.client.messages.PortBinding;

@JsonDeserialize(builder=ImmutableNetworkSettings.Builder.class)
@Value.Immutable
public interface NetworkSettings {
    @Deprecated
    @JsonProperty(value="IPAddress")
    @Nullable
    public String ipAddress();

    @Deprecated
    @JsonProperty(value="IPPrefixLen")
    @Nullable
    public Integer ipPrefixLen();

    @JsonProperty(value="Gateway")
    @Nullable
    public String gateway();

    @JsonProperty(value="Bridge")
    @Nullable
    public String bridge();

    @JsonProperty(value="PortMapping")
    @Nullable
    public Map<String, Map<String, String>> portMapping();

    @JsonIgnore
    @Nullable
    @Value.Derived
    default public Map<String, List<PortBinding>> ports() {
        if (this.nullValuedPorts() == null) {
            return null;
        }
        return this.nullValuedPorts().entrySet().stream().collect(Collectors.toMap(k -> (String)k.getKey(), k -> k.getValue() == null ? Collections.emptyList() : (List)k.getValue()));
    }

    @JsonProperty(value="Ports")
    @Nullable
    @AllowNulls
    public Map<String, List<PortBinding>> nullValuedPorts();

    @Deprecated
    @JsonProperty(value="MacAddress")
    @Nullable
    public String macAddress();

    @JsonProperty(value="Networks")
    @Nullable
    public Map<String, AttachedNetwork> networks();

    @JsonProperty(value="EndpointID")
    @Nullable
    public String endpointId();

    @JsonProperty(value="SandboxID")
    @Nullable
    public String sandboxId();

    @JsonProperty(value="SandboxKey")
    @Nullable
    public String sandboxKey();

    @Deprecated
    @JsonProperty(value="HairpinMode")
    @Nullable
    public Boolean hairpinMode();

    @Deprecated
    @JsonProperty(value="LinkLocalIPv6Address")
    @Nullable
    public String linkLocalIPv6Address();

    @Deprecated
    @JsonProperty(value="LinkLocalIPv6PrefixLen")
    @Nullable
    public Integer linkLocalIPv6PrefixLen();

    @JsonProperty(value="GlobalIPv6Address")
    @Nullable
    public String globalIPv6Address();

    @JsonProperty(value="GlobalIPv6PrefixLen")
    @Nullable
    public Integer globalIPv6PrefixLen();

    @JsonProperty(value="IPv6Gateway")
    @Nullable
    public String ipv6Gateway();

    public static Builder builder() {
        return ImmutableNetworkSettings.builder();
    }

    public static interface Builder {
        public Builder ipAddress(String var1);

        public Builder ipPrefixLen(Integer var1);

        public Builder gateway(String var1);

        public Builder bridge(String var1);

        public Builder portMapping(Map<String, ? extends Map<String, String>> var1);

        public Builder nullValuedPorts(Map<String, ? extends List<PortBinding>> var1);

        public Builder macAddress(String var1);

        public Builder networks(Map<String, ? extends AttachedNetwork> var1);

        public Builder endpointId(String var1);

        public Builder sandboxId(String var1);

        public Builder sandboxKey(String var1);

        public Builder hairpinMode(Boolean var1);

        public Builder linkLocalIPv6Address(String var1);

        public Builder linkLocalIPv6PrefixLen(Integer var1);

        public Builder globalIPv6Address(String var1);

        public Builder globalIPv6PrefixLen(Integer var1);

        public Builder ipv6Gateway(String var1);

        public NetworkSettings build();
    }
}

