/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.Arrays;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SchemaDocumentationType;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.HoverCapabilities;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public abstract class XMLSchemaHoverDocumentationTypeTest
extends AbstractCacheBasedTest {
    private static final String schemaName = "docAppinfo.xsd";
    private static final String schemaPath = "src/test/resources/docAppinfo.xsd";
    private static final String docPrefix = "**xs:documentation**:" + System.lineSeparator() + System.lineSeparator();
    private static final String appinfoPrefix = "**xs:appinfo**:" + System.lineSeparator() + System.lineSeparator();
    private static String source;
    private static String plainTextDocPrefix;
    private static String plainTextAppinfoPrefix;
    private static String plainTextSource;
    private String extraAttributes = "";

    @BeforeAll
    public static void setup() throws URI.MalformedURIException {
        source = "Source: [docAppinfo.xsd](" + XMLSchemaHoverDocumentationTypeTest.getXMLSchemaFileURI(schemaName) + ")";
        plainTextSource = "Source: docAppinfo.xsd";
    }

    @Test
    public void testHoverAttributeNameDoc() throws BadLocationException, URI.MalformedURIException {
        this.assertAttributeNameDocHover("attribute name documentation", SchemaDocumentationType.documentation, true);
        this.assertAttributeNameDocHover(null, SchemaDocumentationType.appinfo, true);
        this.assertAttributeNameDocHover("attribute name documentation", SchemaDocumentationType.all, true);
        this.assertAttributeNameDocHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverAttributeNameAppinfo() throws BadLocationException, URI.MalformedURIException {
        this.assertAttributeNameAppinfoHover(null, SchemaDocumentationType.documentation, true);
        this.assertAttributeNameAppinfoHover("attribute name appinfo", SchemaDocumentationType.appinfo, true);
        this.assertAttributeNameAppinfoHover("attribute name appinfo", SchemaDocumentationType.all, true);
        this.assertAttributeNameAppinfoHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverAttributeNameBoth() throws BadLocationException, URI.MalformedURIException {
        this.assertAttributeNameBothHover("attribute name documentation", SchemaDocumentationType.documentation, true);
        this.assertAttributeNameBothHover("attribute name appinfo", SchemaDocumentationType.appinfo, true);
        this.assertAttributeNameBothHover(docPrefix + "attribute name documentation" + System.lineSeparator() + System.lineSeparator() + appinfoPrefix + "attribute name appinfo", SchemaDocumentationType.all, true);
        this.assertAttributeNameBothHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverAttributeValueDoc() throws BadLocationException, URI.MalformedURIException {
        this.assertAttributeValueDocHover("attribute value documentation", SchemaDocumentationType.documentation, true);
        this.assertAttributeValueDocHover(null, SchemaDocumentationType.appinfo, true);
        this.assertAttributeValueDocHover("attribute value documentation", SchemaDocumentationType.all, true);
        this.assertAttributeValueDocHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverAttributeValueAppinfo() throws BadLocationException, URI.MalformedURIException {
        this.assertAttributeValueAppinfoHover(null, SchemaDocumentationType.documentation, true);
        this.assertAttributeValueAppinfoHover("attribute value appinfo", SchemaDocumentationType.appinfo, true);
        this.assertAttributeValueAppinfoHover("attribute value appinfo", SchemaDocumentationType.all, true);
        this.assertAttributeValueAppinfoHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverAttributeValueBoth() throws BadLocationException, URI.MalformedURIException {
        this.assertAttributeValueBothHover("attribute value documentation", SchemaDocumentationType.documentation, true);
        this.assertAttributeValueBothHover("attribute value appinfo", SchemaDocumentationType.appinfo, true);
        this.assertAttributeValueBothHover(docPrefix + "attribute value documentation" + System.lineSeparator() + System.lineSeparator() + appinfoPrefix + "attribute value appinfo", SchemaDocumentationType.all, true);
        this.assertAttributeValueBothHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverElementDoc() throws BadLocationException, URI.MalformedURIException {
        this.assertElementDocHover("element documentation", SchemaDocumentationType.documentation, true);
        this.assertElementDocHover(null, SchemaDocumentationType.appinfo, true);
        this.assertElementDocHover("element documentation", SchemaDocumentationType.all, true);
        this.assertElementDocHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverElementAppinfo() throws BadLocationException, URI.MalformedURIException {
        this.assertElementAppinfoHover(null, SchemaDocumentationType.documentation, true);
        this.assertElementAppinfoHover("element appinfo", SchemaDocumentationType.appinfo, true);
        this.assertElementAppinfoHover("element appinfo", SchemaDocumentationType.all, true);
        this.assertElementAppinfoHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverElementBoth() throws BadLocationException, URI.MalformedURIException {
        this.assertElementBothHover("element documentation", SchemaDocumentationType.documentation, true);
        this.assertElementBothHover("element appinfo", SchemaDocumentationType.appinfo, true);
        this.assertElementBothHover(docPrefix + "element documentation" + System.lineSeparator() + System.lineSeparator() + appinfoPrefix + "element appinfo", SchemaDocumentationType.all, true);
        this.assertElementBothHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverElementBothPlainText() throws BadLocationException, URI.MalformedURIException {
        this.assertElementBothHover("element documentation", SchemaDocumentationType.documentation, false);
        this.assertElementBothHover("element appinfo", SchemaDocumentationType.appinfo, false);
        this.assertElementBothHover(plainTextDocPrefix + "element documentation" + System.lineSeparator() + System.lineSeparator() + plainTextAppinfoPrefix + "element appinfo", SchemaDocumentationType.all, false);
        this.assertElementBothHover(null, SchemaDocumentationType.none, false);
    }

    @Test
    public void testHoverMultipleBoth() throws BadLocationException, URI.MalformedURIException {
        String documentation = "first element documentation" + System.lineSeparator() + System.lineSeparator() + "second element documentation" + System.lineSeparator() + System.lineSeparator() + "third element documentation";
        String appinfo = "first element appinfo" + System.lineSeparator() + System.lineSeparator() + "second element appinfo" + System.lineSeparator() + System.lineSeparator() + "third element appinfo";
        this.assertElementMultipleBothHover(documentation, SchemaDocumentationType.documentation, true);
        this.assertElementMultipleBothHover(appinfo, SchemaDocumentationType.appinfo, true);
        this.assertElementMultipleBothHover(docPrefix + documentation + System.lineSeparator() + System.lineSeparator() + appinfoPrefix + appinfo, SchemaDocumentationType.all, true);
        this.assertElementMultipleBothHover(null, SchemaDocumentationType.none, true);
    }

    @Test
    public void testHoverMultipleBothPlainText() throws BadLocationException, URI.MalformedURIException {
        String documentation = "first element documentation" + System.lineSeparator() + System.lineSeparator() + "second element documentation" + System.lineSeparator() + System.lineSeparator() + "third element documentation";
        String appinfo = "first element appinfo" + System.lineSeparator() + System.lineSeparator() + "second element appinfo" + System.lineSeparator() + System.lineSeparator() + "third element appinfo";
        this.assertElementMultipleBothHover(documentation, SchemaDocumentationType.documentation, false);
        this.assertElementMultipleBothHover(appinfo, SchemaDocumentationType.appinfo, false);
        this.assertElementMultipleBothHover(plainTextDocPrefix + documentation + System.lineSeparator() + System.lineSeparator() + plainTextAppinfoPrefix + appinfo, SchemaDocumentationType.all, false);
        this.assertElementMultipleBothHover(null, SchemaDocumentationType.none, false);
    }

    @Test
    public void testHoverNoAnnotation() throws BadLocationException, URI.MalformedURIException {
        this.assertElementHoverNoAnnotation(SchemaDocumentationType.all, true);
        this.assertElementHoverNoAnnotation(SchemaDocumentationType.appinfo, true);
        this.assertElementHoverNoAnnotation(SchemaDocumentationType.documentation, true);
        this.assertElementHoverNoAnnotation(SchemaDocumentationType.none, true);
        this.assertElementHoverNoAnnotation(SchemaDocumentationType.all, false);
        this.assertElementHoverNoAnnotation(SchemaDocumentationType.appinfo, false);
        this.assertElementHoverNoAnnotation(SchemaDocumentationType.documentation, false);
        this.assertElementHoverNoAnnotation(SchemaDocumentationType.none, false);
    }

    @Test
    public void testHoverWhitespaceAnnotation() throws BadLocationException, URI.MalformedURIException {
        this.assertElementHoverWhitespaceAnnotation(SchemaDocumentationType.all, true);
        this.assertElementHoverWhitespaceAnnotation(SchemaDocumentationType.appinfo, true);
        this.assertElementHoverWhitespaceAnnotation(SchemaDocumentationType.documentation, true);
        this.assertElementHoverWhitespaceAnnotation(SchemaDocumentationType.none, true);
        this.assertElementHoverWhitespaceAnnotation(SchemaDocumentationType.all, false);
        this.assertElementHoverWhitespaceAnnotation(SchemaDocumentationType.appinfo, false);
        this.assertElementHoverWhitespaceAnnotation(SchemaDocumentationType.documentation, false);
        this.assertElementHoverWhitespaceAnnotation(SchemaDocumentationType.none, false);
    }

    private void assertAttributeNameDocHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\tattribu|teNameOnlyDocumentation=\"onlyDocumentation\">\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertAttributeValueDocHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\tattributeNameOnlyDocumentation=\"o|nlyDocumentation\">\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertAttributeNameAppinfoHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\ta|ttributeNameOnlyAppinfo=\"onlyAppinfo\">\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertAttributeValueAppinfoHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\tattributeNameOnlyAppinfo=\"o|nlyAppinfo\">\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertAttributeNameBothHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\ta|ttributeNameBoth=\"bothDocumentationAndAppinfo\">\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertAttributeValueBothHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\tattributeNameBoth=\"b|othDocumentationAndAppinfo\">\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertElementDocHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\t<e|lementOnlyDocumentation></elementOnlyDocumentation>\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertElementAppinfoHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\t<e|lementOnlyAppinfo></elementOnlyAppinfo>\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertElementBothHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\t<e|lementBoth></elementBoth>\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertElementMultipleBothHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\t<e|lementMultipleBoth></elementMultipleBoth>\n</root>\n";
        this.assertHover(xml, expected, docSource, markdownSupported);
    }

    private void assertElementHoverNoAnnotation(SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\t<e|lementNoAnnotation></elementNoAnnotation>\n</root>\n";
        this.assertHover(xml, null, docSource, markdownSupported);
    }

    private void assertElementHoverWhitespaceAnnotation(SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\t<e|lementWhitespaceAnnotation></elementWhitespaceAnnotation>\n</root>\n";
        this.assertHover(xml, null, docSource, markdownSupported);
    }

    private void assertHover(String xml, String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
        if (expected != null) {
            String currSource = markdownSupported ? source : plainTextSource;
            StringBuilder content = new StringBuilder(expected);
            content.append(System.lineSeparator());
            content.append(System.lineSeparator());
            content.append(currSource);
            expected = content.toString();
        }
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, schemaPath, expected, null, this.createSharedSettings(docSource, markdownSupported));
    }

    private SharedSettings createSharedSettings(SchemaDocumentationType docSource, boolean markdownSupported) {
        SharedSettings settings = new SharedSettings();
        if (markdownSupported) {
            HoverCapabilities capabilities = new HoverCapabilities(Arrays.asList("markdown"), Boolean.valueOf(false));
            settings.getHoverSettings().setCapabilities(capabilities);
        }
        settings.getPreferences().setShowSchemaDocumentationType(docSource);
        return settings;
    }

    private static String getXMLSchemaFileURI(String schemaURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("xsd/" + schemaURI), (String)"src/test/resources/test.xml", (boolean)true).replace("///", "/");
    }

    static {
        plainTextDocPrefix = "xs:documentation:" + System.lineSeparator() + System.lineSeparator();
        plainTextAppinfoPrefix = "xs:appinfo:" + System.lineSeparator() + System.lineSeparator();
    }

    @Nested
    public static class DerivedTypeTest
    extends XMLSchemaHoverDocumentationTypeTest {
        public DerivedTypeTest() {
            this.extraAttributes = "  xsi:type=\"Derived\"";
        }

        @Test
        public void testHoverDerivedAttributeNameDoc() throws BadLocationException, URI.MalformedURIException {
            this.assertDerivedAttributeNameDocHover("derived attribute name documentation", SchemaDocumentationType.documentation, true);
            this.assertDerivedAttributeNameDocHover(null, SchemaDocumentationType.appinfo, true);
            this.assertDerivedAttributeNameDocHover("derived attribute name documentation", SchemaDocumentationType.all, true);
            this.assertDerivedAttributeNameDocHover(null, SchemaDocumentationType.none, true);
        }

        @Test
        public void testHoverDerivedElementDoc() throws BadLocationException, URI.MalformedURIException {
            this.assertDerivedElementDocHover("derived element documentation", SchemaDocumentationType.documentation, true);
            this.assertDerivedElementDocHover(null, SchemaDocumentationType.appinfo, true);
            this.assertDerivedElementDocHover("derived element documentation", SchemaDocumentationType.all, true);
            this.assertDerivedElementDocHover(null, SchemaDocumentationType.none, true);
        }

        private void assertDerivedAttributeNameDocHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
            String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\tderivedAttribu|teNameOnlyDocumentation=\"onlyDocumentation\">\n</root>\n";
            super.assertHover(xml, expected, docSource, markdownSupported);
        }

        private void assertDerivedElementDocHover(String expected, SchemaDocumentationType docSource, boolean markdownSupported) throws BadLocationException {
            String xml = "<root\n\txmlns=\"http://docAppinfo\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://docAppinfo xsd/docAppinfo.xsd\"\n" + this.extraAttributes + "\t<derivedE|lementOnlyDocumentation></derivedElementOnlyDocumentation>\n</root>\n";
            super.assertHover(xml, expected, docSource, markdownSupported);
        }
    }

    @Nested
    public static class BaseTypeTest
    extends XMLSchemaHoverDocumentationTypeTest {
    }
}

