/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.dom.DOMCharacterData;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDElementDecl;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lemminx.dom.DTDNotationDecl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMParserTest {
    @Test
    public void testSingleElement() {
        DOMElement html = DOMParserTest.createElement("html", 0, 6, 13, true);
        DOMParserTest.assertDocument("<html></html>", (DOMNode)html);
    }

    @Test
    public void testNestedElement() {
        DOMElement body = DOMParserTest.createElement("body", 6, 12, 19, true);
        DOMElement html = DOMParserTest.createElement("html", 0, 19, 26, true);
        html.addChild((DOMNode)body);
        DOMParserTest.assertDocument("<html><body></body></html>", (DOMNode)html);
    }

    @Test
    public void testGetTextContentWithSimpleContent() throws Exception {
        this.assertTextContent("<a><b><c>Hello</c></b></a>", "Hello", Document::getDocumentElement);
    }

    @Test
    public void testGetTextContentWithMixedContent() throws Exception {
        this.assertTextContent("<a>H<b>e<c>ll</c></b>o</a>", "Hello", Document::getDocumentElement);
    }

    @Test
    public void testGetTextContentWithComplexContent() throws Exception {
        this.assertTextContent("<a><b>H</b><c>e</c><b>ll</b><x>o</x></a>", "Hello", Document::getDocumentElement);
    }

    @Test
    public void testGetTextContentWithCharContent() throws Exception {
        this.assertTextContent("<text>Hello</text>", "Hello", Document::getDocumentElement);
    }

    @Test
    public void testGetTextContentWithCDATAContent() throws Exception {
        this.assertTextContent("<a><b><c><![CDATA[Hello]]></c></b></a>", "Hello", Document::getDocumentElement);
    }

    @Test
    public void testGetTextContentWithComment() throws Exception {
        this.assertTextContent("<a><b><c>Hello</c><!-- comments must not be included --></b></a>", "Hello", Document::getDocumentElement);
    }

    @Test
    public void testGetTextIsNullForDocument() throws Exception {
        this.assertTextContent("<a>Hello</a>", null, (Document d) -> d);
    }

    @Test
    public void testGetTextContentWithPI() throws Exception {
        this.assertTextContent("<a><b><c>Hello</c><?PI must not be included ?></b></a>", "Hello", Document::getDocumentElement);
    }

    private void assertTextContent(String xml, String expected, Function<Document, Node> nodeExtractor) throws Exception {
        this.assertTextContent((Document)DOMParser.getInstance().parse(xml, "uri", null), expected, nodeExtractor);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.assertTextContent(builder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))), expected, nodeExtractor);
    }

    private void assertTextContent(Document document, String expected, Function<Document, Node> nodeExtractor) {
        String textContent = nodeExtractor.apply(document).getTextContent();
        if (expected != null) {
            Assertions.assertNotNull((Object)textContent);
        }
        Assertions.assertEquals((Object)expected, (Object)textContent);
    }

    @Test
    public void testNestedElements() {
        DOMElement head = DOMParserTest.createElement("head", 6, 12, 19, true);
        DOMElement body = DOMParserTest.createElement("body", 19, 25, 32, true);
        DOMElement html = DOMParserTest.createElement("html", 0, 32, 39, true);
        html.addChild((DOMNode)head);
        html.addChild((DOMNode)body);
        DOMParserTest.assertDocument("<html><head></head><body></body></html>", (DOMNode)html);
    }

    @Test
    public void testNestedNestedElements() {
        DOMElement c = DOMParserTest.createElement("c", 6, 9, 13, true);
        DOMElement b = DOMParserTest.createElement("b", 3, 13, 17, true);
        b.addChild((DOMNode)c);
        DOMElement a = DOMParserTest.createElement("a", 0, 17, 21, true);
        a.addChild((DOMNode)b);
        DOMParserTest.assertDocument("<a><b><c></c></b></a>", (DOMNode)a);
    }

    @Test
    public void testSelfClosing() {
        DOMElement br = DOMParserTest.createElement("br", 0, null, 5, true);
        DOMParserTest.assertDocument("<br/>", (DOMNode)br);
    }

    @Test
    public void testNestedSelfClosingTag() {
        DOMElement br = DOMParserTest.createElement("br", 5, null, 10, true);
        DOMElement span = DOMParserTest.createElement("span", 10, 16, 23, true);
        DOMElement div = DOMParserTest.createElement("div", 0, 23, 29, true);
        div.addChild((DOMNode)br);
        div.addChild((DOMNode)span);
        DOMParserTest.assertDocument("<div><br/><span></span></div>", (DOMNode)div);
    }

    @Test
    public void testEmptyTagT() {
        DOMElement br = DOMParserTest.createElement("br", 0, null, 4, false);
        DOMParserTest.assertDocument("<br>", (DOMNode)br);
    }

    @Test
    public void singleEndTag() {
        DOMElement meta = DOMParserTest.createElement("meta", 0, 0, 7, false);
        DOMParserTest.assertDocument("</meta>", (DOMNode)meta);
        Assertions.assertFalse((boolean)meta.hasStartTag());
        Assertions.assertTrue((boolean)meta.hasEndTag());
        Assertions.assertEquals((int)0, (int)meta.getEndTagOpenOffset());
    }

    @Test
    public void insideEndTag() {
        DOMElement meta = DOMParserTest.createElement("meta", 6, 6, 13, false);
        DOMElement html = DOMParserTest.createElement("html", 0, 13, 20, true);
        html.addChild((DOMNode)meta);
        DOMParserTest.assertDocument("<html></meta></html>", (DOMNode)html);
        Assertions.assertFalse((boolean)meta.hasStartTag());
        Assertions.assertTrue((boolean)meta.hasEndTag());
        Assertions.assertEquals((int)6, (int)meta.getEndTagOpenOffset());
    }

    @Test
    public void testEndTagInsideElement() {
        DOMElement div = DOMParserTest.createElement("div", 0, 5, 11, true);
        DOMParserTest.assertDocument("<div></div><div>", (DOMNode)div);
    }

    @Test
    public void testStartTagInsideElement() {
        DOMElement div2 = DOMParserTest.createElement("div", 5, 10, 16, true);
        DOMElement div = DOMParserTest.createElement("div", 0, null, 16, false);
        div.addChild((DOMNode)div2);
        DOMParserTest.assertDocument("<div><div></div>", (DOMNode)div);
    }

    @Test
    public void testStartTagInsideElement2() {
        DOMElement div = DOMParserTest.createElement("div", 5, null, 10, false);
        DOMElement cat = DOMParserTest.createElement("cat", 0, 10, 16, true);
        cat.addChild((DOMNode)div);
        DOMParserTest.assertDocument("<cat><div></cat>", (DOMNode)cat);
    }

    @Test
    public void testMultipleStartTagInsideElement() {
        DOMElement span = DOMParserTest.createElement("span", 9, null, 15, false);
        DOMElement div = DOMParserTest.createElement("div", 4, null, 15, false);
        div.addChild((DOMNode)span);
        DOMElement h1 = DOMParserTest.createElement("h1", 0, 15, 20, true);
        h1.addChild((DOMNode)div);
        DOMParserTest.assertDocument("<h1><div><span></h1>", (DOMNode)h1);
    }

    @Test
    public void testAttributeInElement() {
        DOMElement div = DOMParserTest.createElement("div", 0, 17, 23, true);
        this.insertIntoAttributes((DOMNode)div, "key", "\"value\"");
        DOMParserTest.assertDocument("<div key=\"value\"></div>", (DOMNode)div);
    }

    @Test
    public void testAttributesInElement() {
        DOMElement div = DOMParserTest.createElement("div", 0, 30, 36, true);
        this.insertIntoAttributes((DOMNode)div, "key", "\"value\"");
        this.insertIntoAttributes((DOMNode)div, "key2", "\"value\"");
        DOMParserTest.assertDocument("<div key=\"value\" key2=\"value\"></div>", (DOMNode)div);
    }

    @Test
    public void testAttributesInSelfClosingElement() {
        DOMElement div = DOMParserTest.createElement("div", 0, null, 31, true);
        this.insertIntoAttributes((DOMNode)div, "key", "\"value\"");
        this.insertIntoAttributes((DOMNode)div, "key2", "\"value\"");
        DOMParserTest.assertDocument("<div key=\"value\" key2=\"value\"/>", (DOMNode)div);
    }

    @Test
    public void testAttributeEmptyValue() {
        DOMElement div = DOMParserTest.createElement("div", 0, 12, 18, true);
        this.insertIntoAttributes((DOMNode)div, "key", "\"\"");
        DOMParserTest.assertDocument("<div key=\"\"></div>", (DOMNode)div);
    }

    @Test
    public void testAttributeNoValue() {
        DOMElement div = DOMParserTest.createElement("div", 0, 10, 16, true);
        this.insertIntoAttributes((DOMNode)div, "key", null);
        DOMParserTest.assertDocument("<div key=></div>", (DOMNode)div);
    }

    @Test
    public void testAttributeNoClosingQuotation() {
        DOMElement div = DOMParserTest.createElement("div", 0, null, 22, false);
        this.insertIntoAttributes((DOMNode)div, "key", "\"value></div>");
        DOMParserTest.assertDocument("<div key=\"value></div>", (DOMNode)div);
    }

    @Test
    public void testCDATABasicTest() {
        DOMCDATASection text = DOMParserTest.createCDATANode("testText", 5, 25, true);
        DOMElement div = DOMParserTest.createElement("div", 0, 25, 31, true);
        div.addChild((DOMNode)text);
        DOMParserTest.assertDocument("<div><![CDATA[testText]]></div>", (DOMNode)div);
    }

    @Test
    public void testCDATAWithOtherElement() {
        DOMCDATASection text = DOMParserTest.createCDATANode("TEXT", 5, 21, true);
        DOMElement a = DOMParserTest.createElement("a", 21, 24, 28, true);
        DOMElement div = DOMParserTest.createElement("div", 0, 28, 34, true);
        div.addChild((DOMNode)text);
        div.addChild((DOMNode)a);
        DOMParserTest.assertDocument("<div><![CDATA[TEXT]]><a></a></div>", (DOMNode)div);
    }

    @Test
    public void testCDATANotClosedButNested() {
        DOMCDATASection text = DOMParserTest.createCDATANode("testText]</div>", 5, 29, false);
        DOMElement div = DOMParserTest.createElement("div", 0, null, 29, false);
        div.addChild((DOMNode)text);
        DOMParserTest.assertDocument("<div><![CDATA[testText]</div>", (DOMNode)div);
    }

    @Test
    public void testCDATANotClosedNotNested() {
        DOMCDATASection text = DOMParserTest.createCDATANode("testText]/div>", 5, 28, false);
        DOMElement div = DOMParserTest.createElement("div", 0, null, 28, false);
        div.addChild((DOMNode)text);
        DOMParserTest.assertDocument("<div><![CDATA[testText]/div>", (DOMNode)div);
    }

    @Test
    public void testCDATABasicWithAngledBracket() {
        DOMCDATASection text = DOMParserTest.createCDATANode("<>", 5, 19, true);
        DOMElement div = DOMParserTest.createElement("div", 0, 19, 25, true);
        div.addChild((DOMNode)text);
        DOMParserTest.assertDocument("<div><![CDATA[<>]]></div>", (DOMNode)div);
    }

    @Test
    public void testClosedWithIncompleteEndTag() {
        DOMElement div = DOMParserTest.createElement("div", 0, null, 14, false);
        DOMElement divaaaz = DOMParserTest.createElement("divaaaz", 5, 5, 14, false);
        div.addChild((DOMNode)divaaaz);
        DOMParserTest.assertDocument("<div></divaaaz", (DOMNode)div);
    }

    @Test
    public void testNonClosedAndIncomplete() {
        DOMElement h = DOMParserTest.createElement("h", 14, null, 16, false);
        DOMElement hello = DOMParserTest.createElement("hello", 7, 16, 24, true);
        DOMElement test1 = DOMParserTest.createElement("test1", 0, null, 24, false);
        test1.addChild((DOMNode)hello);
        hello.addChild((DOMNode)h);
        DOMParserTest.assertDocument("<test1><hello><h</hello>", (DOMNode)test1);
    }

    @Test
    public void testWithNewLineCharacters() {
        DOMElement n = DOMParserTest.createElement("n", 6, 12, 16, true);
        DOMElement t = DOMParserTest.createElement("t", 0, 17, 21, true);
        t.addChild((DOMNode)n);
        DOMText text = DOMParserTest.createTextNode("\n  ", 9, 12, true);
        n.addChild((DOMNode)text);
        DOMParserTest.assertDocument("<t>\n  <n>\n  </n>\n</t>", (DOMNode)t);
    }

    @Test
    public void testProlog() {
        DOMProcessingInstruction prolog = DOMParserTest.createPrologNode("xml", 0, 38, true);
        this.insertIntoAttributes((DOMNode)prolog, "version", "\"1.0\"");
        this.insertIntoAttributes((DOMNode)prolog, "encoding", "\"UTF-8\"");
        DOMParserTest.assertDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", (DOMNode)prolog);
    }

    @Test
    public void testPI() {
        DOMNode processingInstruction = DOMParserTest.createPINode("m2e", 6, 20, true, "he haa");
        DOMElement html = DOMParserTest.createElement("html", 0, 20, 27, true);
        html.addChild(processingInstruction);
        DOMParserTest.assertDocument("<html><?m2e he haa?></html>", (DOMNode)html);
    }

    @Disabled
    @Test
    public void testPIXMLStyleSheet() {
        DOMNode processingInstruction = DOMParserTest.createPINode("xml-stylesheet", 6, 60, true, "");
        this.insertIntoAttributes(processingInstruction, "href", "\"my-style.css\"");
        this.insertIntoAttributes(processingInstruction, "type", "\"text/css\"");
        DOMElement html = DOMParserTest.createElement("html", 0, 60, 67, true);
        html.addChild(processingInstruction);
        DOMParserTest.assertDocument("<html><?xml-stylesheet href=\"my-style.css\" type=\"text/css\"?></html>", (DOMNode)html);
    }

    @Test
    public void testPIXMLStyleSheetMispelled() {
        DOMNode processingInstruction = DOMParserTest.createPINode("xml-stylesheetBAD", 6, 63, true, "href=\"my-style.css\" type=\"text/css\"");
        DOMElement html = DOMParserTest.createElement("html", 0, 63, 70, true);
        html.addChild(processingInstruction);
        DOMParserTest.assertDocument("<html><?xml-stylesheetBAD href=\"my-style.css\" type=\"text/css\"?></html>", (DOMNode)html);
    }

    @Test
    public void testPISpaces() {
        DOMNode processingInstruction = DOMParserTest.createPINode("m2e", 6, 28, true, "he haa");
        DOMElement html = DOMParserTest.createElement("html", 0, 28, 35, true);
        html.addChild(processingInstruction);
        DOMParserTest.assertDocument("<html><?m2e    he haa     ?></html>", (DOMNode)html);
    }

    @Test
    public void testPISpaces2() {
        DOMNode processingInstruction = DOMParserTest.createPINode("m2e", 8, 22, true, "he haa");
        DOMElement html = DOMParserTest.createElement("html", 0, 24, 31, true);
        html.addChild(processingInstruction);
        DOMParserTest.assertDocument("<html>  <?m2e he haa?>  </html>", (DOMNode)html);
    }

    @Test
    public void testPICloseToProlog() {
        DOMNode processingInstruction = DOMParserTest.createPINode("xmll", 0, 24, true, "this is content");
        DOMParserTest.assertDocument("<?xmll this is content?>", processingInstruction);
    }

    @Test
    public void testPINoContent() {
        DOMNode processingInstruction = DOMParserTest.createPINode("m2e", 0, 7, true, "");
        DOMParserTest.assertDocument("<?m2e?>", processingInstruction);
    }

    @Test
    public void testPINoContentButSpace() {
        DOMNode processingInstruction = DOMParserTest.createPINode("m2e", 0, 8, true, "");
        DOMParserTest.assertDocument("<?m2e ?>", processingInstruction);
    }

    @Test
    public void testPrologNoContent() {
        DOMProcessingInstruction prolog = DOMParserTest.createPrologNode("xml", 0, 7, true);
        DOMParserTest.assertDocument("<?xml?>", (DOMNode)prolog);
    }

    @Test
    public void testPrologNoContentButSpace() {
        DOMProcessingInstruction prolog = DOMParserTest.createPrologNode("xml", 0, 8, true);
        DOMParserTest.assertDocument("<?xml ?>", (DOMNode)prolog);
    }

    @Test
    public void testCommentSingle() {
        DOMComment comment = DOMParserTest.createCommentNode(" test ", 0, 13, true);
        DOMParserTest.assertDocument("<!-- test -->", (DOMNode)comment);
    }

    @Test
    public void testContentTextHasTag() {
        DOMText textNode = DOMParserTest.createTextNode("  eek  ", 6, 13, true);
        DOMElement html = DOMParserTest.createElement("html", 0, 13, 20, true);
        html.addChild((DOMNode)textNode);
        DOMParserTest.assertDocument("<html>  eek  </html>", (DOMNode)html);
    }

    @Test
    public void testUnclosedEndTagWithTrailingElement() {
        DOMElement root = DOMParserTest.createElement("root", 0, 29, 36, true);
        DOMElement elementA = DOMParserTest.createElement("a", 7, 17, 20, true);
        DOMElement elementB = DOMParserTest.createElement("b", 21, 24, 28, true);
        DOMText content = DOMParserTest.createTextNode("Content", 10, 17, true);
        root.addChild((DOMNode)elementA);
        root.addChild((DOMNode)elementB);
        elementA.addChild((DOMNode)content);
        DOMParserTest.assertDocument("<root> <a>Content</a <b></b> </root>", (DOMNode)root);
    }

    @Test
    public void testUnclosedEndTagWithTrailingComment() {
        DOMElement root = DOMParserTest.createElement("root", 0, 38, 45, true);
        DOMElement elementA = DOMParserTest.createElement("a", 7, 17, 20, true);
        DOMComment comment = DOMParserTest.createCommentNode(" comment ", 21, 37, true);
        DOMText content = DOMParserTest.createTextNode("Content", 10, 17, true);
        root.addChild((DOMNode)elementA);
        root.addChild((DOMNode)comment);
        elementA.addChild((DOMNode)content);
        DOMParserTest.assertDocument("<root> <a>Content</a <!-- comment --> </root>", (DOMNode)root);
    }

    @Test
    public void testWhitespaceIsParsed() {
        DOMText textNodeBefore = DOMParserTest.createTextNode("\r\n\r\n", 3, 7, true);
        DOMElement a = DOMParserTest.createElement("a", 0, 18, 22, true);
        DOMElement b = DOMParserTest.createElement("b", 7, 10, 14, true);
        DOMText textNodeAfter = DOMParserTest.createTextNode("\r\n\r\n", 14, 18, true);
        a.addChild((DOMNode)textNodeBefore);
        a.addChild((DOMNode)b);
        a.addChild((DOMNode)textNodeAfter);
        DOMParserTest.assertDocument("<a>\r\n\r\n<b></b>\r\n\r\n</a>", (DOMNode)a, false);
    }

    @Test
    public void testPreserveWhitespaceContent() {
        DOMElement a = DOMParserTest.createElement("a", 0, 14, 18, true);
        DOMElement b = DOMParserTest.createElement("b", 3, 10, 14, true);
        DOMText whitespaceContent = DOMParserTest.createTextNode("\r\n\r\n", 6, 10, true);
        a.addChild((DOMNode)b);
        b.addChild((DOMNode)whitespaceContent);
        DOMParserTest.assertDocument("<a><b>\r\n\r\n</b></a>", (DOMNode)a);
    }

    @Test
    public void elementOffsets() {
        DOMDocument document = DOMParser.getInstance().parse("<a></a>", "", null);
        DOMElement a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertEquals((Object)"a", (Object)a.getTagName());
        Assertions.assertEquals((int)0, (int)a.getStart());
        Assertions.assertEquals((int)0, (int)a.getStartTagOpenOffset());
        Assertions.assertEquals((int)2, (int)a.getStartTagCloseOffset());
        Assertions.assertEquals((int)3, (int)a.getEndTagOpenOffset());
        Assertions.assertEquals((int)7, (int)a.getEnd());
        Assertions.assertFalse((boolean)a.isInStartTag(0));
        Assertions.assertTrue((boolean)a.isInStartTag(1));
        Assertions.assertTrue((boolean)a.isInStartTag(2));
        Assertions.assertFalse((boolean)a.isInStartTag(3));
    }

    @Test
    public void startTag() {
        DOMDocument document = DOMParser.getInstance().parse("<", "", null);
        DOMElement a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertFalse((boolean)a.hasTagName());
        Assertions.assertTrue((boolean)a.hasStartTag());
        Assertions.assertFalse((boolean)a.hasEndTag());
        document = DOMParser.getInstance().parse("<a", "", null);
        a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertTrue((boolean)a.hasTagName());
        Assertions.assertEquals((Object)"a", (Object)a.getTagName());
        Assertions.assertTrue((boolean)a.hasStartTag());
        Assertions.assertFalse((boolean)a.isStartTagClosed());
        Assertions.assertFalse((boolean)a.hasEndTag());
        document = DOMParser.getInstance().parse("<a>", "", null);
        a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertTrue((boolean)a.hasTagName());
        Assertions.assertEquals((Object)"a", (Object)a.getTagName());
        Assertions.assertTrue((boolean)a.hasStartTag());
        Assertions.assertTrue((boolean)a.isStartTagClosed());
        Assertions.assertFalse((boolean)a.hasEndTag());
        document = DOMParser.getInstance().parse("<a></a", "", null);
        a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertTrue((boolean)a.hasTagName());
        Assertions.assertEquals((Object)"a", (Object)a.getTagName());
        Assertions.assertTrue((boolean)a.hasStartTag());
        Assertions.assertTrue((boolean)a.isStartTagClosed());
        Assertions.assertTrue((boolean)a.hasEndTag());
        Assertions.assertFalse((boolean)a.isEndTagClosed());
        document = DOMParser.getInstance().parse("<a></a>", "", null);
        a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertTrue((boolean)a.hasTagName());
        Assertions.assertEquals((Object)"a", (Object)a.getTagName());
        Assertions.assertTrue((boolean)a.hasStartTag());
        Assertions.assertTrue((boolean)a.isStartTagClosed());
        Assertions.assertTrue((boolean)a.hasEndTag());
        Assertions.assertTrue((boolean)a.isEndTagClosed());
    }

    @Test
    public void endTag() {
        DOMDocument document = DOMParser.getInstance().parse("</", "", null);
        DOMElement a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertFalse((boolean)a.hasTagName());
        Assertions.assertFalse((boolean)a.hasStartTag());
        Assertions.assertTrue((boolean)a.hasEndTag());
        Assertions.assertTrue((boolean)a.isOrphanEndTag());
        document = DOMParser.getInstance().parse("</a", "", null);
        a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertTrue((boolean)a.hasTagName());
        Assertions.assertFalse((boolean)a.hasStartTag());
        Assertions.assertTrue((boolean)a.hasEndTag());
        Assertions.assertTrue((boolean)a.isOrphanEndTag());
        document = DOMParser.getInstance().parse("<a></", "", null);
        a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertTrue((boolean)a.hasChildNodes());
        DOMNode child = a.getChild(0);
        Assertions.assertNotNull((Object)child);
        Assertions.assertTrue((boolean)child.isElement());
        DOMElement invalidEndTag = (DOMElement)child;
        Assertions.assertFalse((boolean)invalidEndTag.hasTagName());
        Assertions.assertFalse((boolean)invalidEndTag.hasStartTag());
        Assertions.assertTrue((boolean)invalidEndTag.hasEndTag());
        Assertions.assertTrue((boolean)invalidEndTag.isOrphanEndTag());
        document = DOMParser.getInstance().parse("<root><a></</root>", "", null);
        DOMElement root = document.getDocumentElement();
        Assertions.assertNotNull((Object)root);
        Assertions.assertTrue((boolean)root.hasChildNodes());
        a = (DOMElement)root.getChild(0);
        Assertions.assertNotNull((Object)a);
        Assertions.assertTrue((boolean)a.hasChildNodes());
        child = a.getChild(0);
        Assertions.assertNotNull((Object)child);
        Assertions.assertTrue((boolean)child.isElement());
        invalidEndTag = (DOMElement)child;
        Assertions.assertFalse((boolean)invalidEndTag.hasTagName());
        Assertions.assertFalse((boolean)invalidEndTag.hasStartTag());
        Assertions.assertTrue((boolean)invalidEndTag.hasEndTag());
        Assertions.assertTrue((boolean)invalidEndTag.isOrphanEndTag());
    }

    @Test
    public void testDoctype1() {
        String xml = "<!DOCTYPE note [\n  <!ENTITY nbsp \"&#xA0;\"> \n  <!ENTITY writer \"Writer: Donald Duck.\">\n  <!ENTITY copyright \"Copyright: W3Schools.\">\n]>";
        String internal = "\n  <!ENTITY nbsp \"&#xA0;\"> \n  <!ENTITY writer \"Writer: Donald Duck.\">\n  <!ENTITY copyright \"Copyright: W3Schools.\">\n";
        DOMDocument document = DOMParser.getInstance().parse(xml, "note.xml", null);
        DOMParserTest.assertDoctype((DOMDocumentType)document.getChild(0), 0, 134, "note", null, null, null, internal);
    }

    @Test
    public void testDoctype2() {
        String xml = "<!DOCTYPE html SYSTEM\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\n  [\n    <!ENTITY nbsp \"&#xA0;\"> \n    <!ENTITY writer \"Writer: Donald Duck.\">\n    <!ENTITY copyright \"Copyright: W3Schools.\">\n  ]\n>";
        String internal = "\n    <!ENTITY nbsp \"&#xA0;\"> \n    <!ENTITY writer \"Writer: Donald Duck.\">\n    <!ENTITY copyright \"Copyright: W3Schools.\">\n  ";
        DOMDocument document = DOMParser.getInstance().parse(xml, "", null);
        DOMParserTest.assertDoctype((DOMDocumentType)document.getChild(0), 0, 212, "html", DOMDocumentType.DocumentTypeKind.SYSTEM.name(), null, "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"", internal);
    }

    @Test
    public void testDTDEntity() {
        String xml = "<!DOCTYPE note [\n  <!ENTITY writer SYSTEM \"https://www.w3schools.com/entities.dtd\">\n]>";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 86, 10, 14, null, null, null, null, null, null, 15, 85);
        doctype.closed = true;
        DTDEntityDecl entity = DOMParserTest.createEntityDecl(19, 83, 28, 34, null, null, 35, 41, null, null, 42, 82, null, null);
        entity.closed = true;
        doctype.addChild((DOMNode)entity);
        DOMDocument document = DOMParser.getInstance().parse(xml, "", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testDTDAllTypes() {
        String xml = "<!DOCTYPE note [\n  <!ENTITY writer SYSTEM \"https://www.w3schools.com/entities.dtd\">\n  <!ELEMENT from (#PCDATA)>\n  <!ATTLIST payment type CDATA \"check\">\n] >";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 155, 10, 14, null, null, null, null, null, null, 15, 153);
        doctype.closed = true;
        DTDEntityDecl entity = DOMParserTest.createEntityDecl(19, 83, 28, 34, null, null, 35, 41, null, null, 42, 82, null, null);
        entity.closed = true;
        DTDElementDecl element = DOMParserTest.createElementDecl(86, 111, 96, 100, null, null, 101, 110, null, null);
        element.closed = true;
        DTDAttlistDecl attlist = DOMParserTest.createAttlistDecl(114, 151, 124, 131, 132, 136, 137, 142, 143, 150, null, null);
        attlist.closed = true;
        doctype.addChild((DOMNode)entity);
        doctype.addChild((DOMNode)element);
        doctype.addChild((DOMNode)attlist);
        DOMDocument document = DOMParser.getInstance().parse(xml, "", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testDTDExternal() {
        String dtd = "<!ENTITY writer SYSTEM \"https://www.w3schools.com/entities.dtd\">\n<!ELEMENT from (#PCDATA)>\n<!ATTLIST payment type CDATA \"check\">";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 128, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDEntityDecl entity = DOMParserTest.createEntityDecl(0, 64, 9, 15, null, null, 16, 22, null, null, 23, 63, null, null);
        entity.closed = true;
        DTDElementDecl element = DOMParserTest.createElementDecl(65, 90, 75, 79, null, null, 80, 89, null, null);
        element.closed = true;
        DTDAttlistDecl attlist = DOMParserTest.createAttlistDecl(91, 128, 101, 108, 109, 113, 114, 119, 120, 127, null, null);
        attlist.closed = true;
        doctype.addChild((DOMNode)entity);
        doctype.addChild((DOMNode)element);
        doctype.addChild((DOMNode)attlist);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testDTDExternal2() {
        String dtd = "<!ATTLIST auth-constraint id ID #IMPLIED>\n<!ELEMENT auth-constraint (description?, role-name*)>";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 95, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDAttlistDecl attlist = DOMParserTest.createAttlistDecl(0, 41, 10, 25, 26, 28, 29, 31, 32, 40, null, null);
        attlist.closed = true;
        DTDElementDecl element = DOMParserTest.createElementDecl(42, 95, 52, 67, null, null, 68, 94, null, null);
        element.closed = true;
        doctype.addChild((DOMNode)attlist);
        doctype.addChild((DOMNode)element);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testDTDExternalUnrecognizedParameters() {
        String dtd = "<!ENTITY writer SYSTEM >\n<!ELEMENT from (#PCDATA)\n<!ATTLIST payment type \"check\">";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 81, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDEntityDecl entity = DOMParserTest.createEntityDecl(0, 24, 9, 15, null, null, 16, 22, null, null, null, null, null, null);
        entity.closed = true;
        DTDElementDecl element = DOMParserTest.createElementDecl(25, 50, 35, 39, null, null, 40, 49, null, null);
        element.closed = false;
        DTDAttlistDecl attlist = DOMParserTest.createAttlistDecl(50, 81, 60, 67, 68, 72, null, null, null, null, 73, 80);
        attlist.closed = true;
        doctype.addChild((DOMNode)entity);
        doctype.addChild((DOMNode)element);
        doctype.addChild((DOMNode)attlist);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testDTDExternalUnrecognizedParameters2() {
        String dtd = "<!ENTITY writer SYSTEM  \n<!ELEMENT from (#PCDATA)\n<!ATTLIST payment type \"check\">";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 81, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDEntityDecl entity = DOMParserTest.createEntityDecl(0, 25, 9, 15, null, null, 16, 22, null, null, null, null, null, null);
        entity.closed = false;
        DTDElementDecl element = DOMParserTest.createElementDecl(25, 50, 35, 39, null, null, 40, 49, null, null);
        element.closed = false;
        DTDAttlistDecl attlist = DOMParserTest.createAttlistDecl(50, 81, 60, 67, 68, 72, null, null, null, null, 73, 80);
        attlist.closed = true;
        doctype.addChild((DOMNode)entity);
        doctype.addChild((DOMNode)element);
        doctype.addChild((DOMNode)attlist);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testDTDExternalUnrecognizedParameters3() {
        String dtd = "<!ATTLIST name \n<!ELEMENT name >";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 32, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDAttlistDecl attlist = DOMParserTest.createAttlistDecl(0, 16, 10, 14, null, null, null, null, null, null, null, null);
        attlist.closed = false;
        DTDElementDecl element = DOMParserTest.createElementDecl(16, 32, 26, 30, null, null, null, null, null, null);
        element.closed = true;
        doctype.addChild((DOMNode)attlist);
        doctype.addChild((DOMNode)element);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testDTDExternalElementContentUnclosed() {
        String dtd = "<!ELEMENT name (aa,bb >";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 23, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDElementDecl element = DOMParserTest.createElementDecl(0, 23, 10, 14, null, null, 15, 22, null, null);
        element.closed = true;
        doctype.addChild((DOMNode)element);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testATTLISTMultipleInternal() {
        String dtd = "<!ATTLIST Institution\n    to CDATA #REQUIRED\n    from CDATA #REQUIRED>";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 70, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDAttlistDecl attlist = DOMParserTest.createAttlistDecl(0, 70, 10, 21, 26, 28, 29, 34, 35, 44, null, null);
        attlist.closed = true;
        DTDAttlistDecl attlistInternal = DOMParserTest.createAttlistDecl(-1, -1, null, null, 49, 53, 54, 59, 60, 69, null, null);
        attlistInternal.closed = true;
        doctype.addChild((DOMNode)attlist);
        attlist.addAdditionalAttDecl(attlistInternal);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testNotation() {
        String dtd = "<!NOTATION jpg PUBLIC \"JPG 1.0\">\n<!NOTATION png PUBLIC \"JPG 1.0\" \"image/gif\">\n<!NOTATION gif SYSTEM \"image/gif\">";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 112, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDNotationDecl notation1 = DOMParserTest.createNotationDecl(0, 32, 11, 14, 15, 21, 22, 31, null, null, null, null);
        notation1.closed = true;
        DTDNotationDecl notation2 = DOMParserTest.createNotationDecl(33, 77, 44, 47, 48, 54, 55, 64, 65, 76, null, null);
        notation2.closed = true;
        DTDNotationDecl notation3 = DOMParserTest.createNotationDecl(78, 112, 89, 92, 93, 99, null, null, 100, 111, null, null);
        notation3.closed = true;
        doctype.addChild((DOMNode)notation1);
        doctype.addChild((DOMNode)notation2);
        doctype.addChild((DOMNode)notation3);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testNotationMissingEndTag() {
        String dtd = "<!NOTATION jpg PUBLIC \"JPG# 1.0\"\n<!NOTATION png PUBLIC \"JPG 1.0\" \"image/gif\">";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 77, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDNotationDecl notation1 = DOMParserTest.createNotationDecl(0, 33, 11, 14, 15, 21, 22, 32, null, null, null, null);
        notation1.closed = false;
        DTDNotationDecl notation2 = DOMParserTest.createNotationDecl(33, 77, 44, 47, 48, 54, 55, 64, 65, 76, null, null);
        notation2.closed = true;
        doctype.addChild((DOMNode)notation1);
        doctype.addChild((DOMNode)notation2);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testNotationMissingEndTagMissingAndExtraValues() {
        String dtd = "<!NOTATION jpg PUBLIC \"JPG# 1.0\"\n<!NOTATION png PUBLIC \"JPG 1.0\" \"image/gif\" BAD>";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 81, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DTDNotationDecl notation1 = DOMParserTest.createNotationDecl(0, 33, 11, 14, 15, 21, 22, 32, null, null, null, null);
        notation1.closed = false;
        DTDNotationDecl notation2 = DOMParserTest.createNotationDecl(33, 81, 44, 47, 48, 54, 55, 64, 65, 76, 77, 80);
        notation2.closed = true;
        doctype.addChild((DOMNode)notation1);
        doctype.addChild((DOMNode)notation2);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testUnrecognizedDTDTagName() {
        String dtd = "<!DOTATION png PUBLIC \"JPG 1.0\" \"image/gif\" BAD>";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 48, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DOMText text = DOMParserTest.createTextNode("<!DOTATION png PUBLIC \"JPG 1.0\" \"image/gif\" BAD>", 0, 48, true);
        doctype.addChild((DOMNode)text);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    @Test
    public void testExternalDTDCommentBeforeDecl() {
        String dtd = "<!-- c --> <!ELEMENT png PUBLIC \"JPG 1.0\" \"image/gif\" BAD>";
        DOMDocumentType doctype = DOMParserTest.createDoctypeNode(0, 58, null, null, null, null, null, null, null, null, null, null);
        doctype.closed = true;
        DOMComment comment = DOMParserTest.createCommentNode(" c ", 0, 10, true);
        DTDElementDecl element = DOMParserTest.createElementDecl(11, 58, 21, 24, null, null, null, null, 25, 57);
        element.closed = true;
        doctype.addChild((DOMNode)comment);
        doctype.addChild((DOMNode)element);
        DOMDocument document = DOMParser.getInstance().parse(dtd, "name.dtd", null);
        DOMParserTest.compareTrees((DOMNode)doctype, document.getChild(0));
    }

    private static DOMCDATASection createCDATANode(String content, int start, int end, boolean closed) {
        MockCDataSection n = (MockCDataSection)DOMParserTest.createNode((short)4, null, start, null, end, closed);
        n.content = content;
        return n;
    }

    private static DOMComment createCommentNode(String content, int start, int end, boolean closed) {
        MockComment n = (MockComment)DOMParserTest.createNode((short)8, null, start, null, end, closed);
        n.content = content;
        return n;
    }

    private static DOMText createTextNode(String content, int start, int end, boolean closed) {
        MockText n = (MockText)DOMParserTest.createNode((short)3, null, start, null, end, closed);
        n.content = content;
        return n;
    }

    private static DOMProcessingInstruction createPrologNode(String tag, int start, int end, boolean closed) {
        DOMProcessingInstruction n = (DOMProcessingInstruction)DOMParserTest.createNode((short)7, tag, start, null, end, closed);
        n.prolog = true;
        return n;
    }

    private static DOMNode createPINode(String tag, int start, int end, boolean closed, String content) {
        MockProcessingInstruction n = (MockProcessingInstruction)DOMParserTest.createNode((short)7, tag, start, null, end, closed);
        n.content = content;
        n.processingInstruction = true;
        return n;
    }

    private static DOMElement createElement(String tag, int start, Integer endTagStart, int end, boolean closed) {
        return (DOMElement)DOMParserTest.createNode((short)1, tag, start, endTagStart, end, closed);
    }

    private static DTDAttlistDecl createAttlistDecl(int start, int end, Integer elementNameStart, Integer elementNameEnd, Integer attributeNameStart, Integer attributeNameEnd, Integer attributeTypeStart, Integer attributeTypeEnd, Integer attributeValueStart, Integer attributeValueEnd, Integer unrecognizedStart, Integer unrecognizedEnd) {
        DTDAttlistDecl attlist = new DTDAttlistDecl(start, end);
        if (elementNameStart != null && elementNameEnd != null) {
            attlist.setName(elementNameStart.intValue(), elementNameEnd.intValue());
        }
        attlist.attributeName = attributeNameStart != null ? new DTDDeclParameter(null, attributeNameStart.intValue(), attributeNameEnd.intValue()) : null;
        attlist.attributeType = attributeTypeStart != null ? new DTDDeclParameter(null, attributeTypeStart.intValue(), attributeTypeEnd.intValue()) : null;
        attlist.attributeValue = attributeValueStart != null ? new DTDDeclParameter(null, attributeValueStart.intValue(), attributeValueEnd.intValue()) : null;
        attlist.unrecognized = unrecognizedStart != null ? new DTDDeclParameter(null, unrecognizedStart.intValue(), unrecognizedEnd.intValue()) : null;
        attlist.end = end;
        return attlist;
    }

    private static DTDElementDecl createElementDecl(int start, int end, Integer nameStart, Integer nameEnd, Integer categoryStart, Integer categoryEnd, Integer contentStart, Integer contentEnd, Integer unrecognizedStart, Integer unrecognizedEnd) {
        DTDElementDecl element = new DTDElementDecl(start, end);
        if (nameStart != null && nameEnd != null) {
            element.setName(nameStart.intValue(), nameEnd.intValue());
        }
        element.category = categoryStart != null ? new DTDDeclParameter(null, categoryStart.intValue(), categoryEnd.intValue()) : null;
        element.content = contentStart != null ? new DTDDeclParameter(null, contentStart.intValue(), contentEnd.intValue()) : null;
        element.unrecognized = unrecognizedStart != null ? new DTDDeclParameter(null, unrecognizedStart.intValue(), unrecognizedEnd.intValue()) : null;
        element.end = end;
        return element;
    }

    private static DTDEntityDecl createEntityDecl(int start, int end, Integer nameStart, Integer nameEnd, Integer valueStart, Integer valueEnd, Integer kindStart, Integer kindEnd, Integer publicIdStart, Integer publicIdEnd, Integer systemIdStart, Integer systemIdEnd, Integer unrecognizedStart, Integer unrecognizedEnd) {
        DTDEntityDecl entity = new DTDEntityDecl(start, end);
        if (nameStart != null && nameEnd != null) {
            entity.setName(nameStart.intValue(), nameEnd.intValue());
        }
        DTDDeclParameter dTDDeclParameter = entity.value = valueStart != null ? new DTDDeclParameter(null, valueStart.intValue(), valueEnd.intValue()) : null;
        if (kindStart != null && kindEnd != null) {
            entity.setKind(kindStart.intValue(), kindEnd.intValue());
        }
        if (publicIdStart != null && publicIdEnd != null) {
            entity.setPublicId(publicIdStart.intValue(), publicIdEnd.intValue());
        }
        if (systemIdStart != null && systemIdEnd != null) {
            entity.setSystemId(systemIdStart.intValue(), systemIdEnd.intValue());
        }
        entity.unrecognized = unrecognizedStart != null ? new DTDDeclParameter(null, unrecognizedStart.intValue(), unrecognizedEnd.intValue()) : null;
        entity.end = end;
        return entity;
    }

    private static DTDNotationDecl createNotationDecl(int start, int end, Integer nameStart, Integer nameEnd, Integer kindStart, Integer kindEnd, Integer publicIdStart, Integer publicIdEnd, Integer systemIdStart, Integer systemIdEnd, Integer unrecognizedStart, Integer unrecognizedEnd) {
        DTDNotationDecl notation = new DTDNotationDecl(start, end);
        notation.getEnd();
        if (nameStart != null && nameEnd != null) {
            notation.setName(nameStart.intValue(), nameEnd.intValue());
        }
        if (kindStart != null && kindEnd != null) {
            notation.setKind(kindStart.intValue(), kindEnd.intValue());
        }
        if (publicIdStart != null && publicIdEnd != null) {
            notation.setPublicId(publicIdStart.intValue(), publicIdEnd.intValue());
        }
        if (systemIdStart != null && systemIdEnd != null) {
            notation.setSystemId(systemIdStart.intValue(), systemIdEnd.intValue());
        }
        notation.unrecognized = unrecognizedStart != null ? new DTDDeclParameter((DTDDeclNode)notation, unrecognizedStart.intValue(), unrecognizedEnd.intValue()) : null;
        notation.end = end;
        return notation;
    }

    private static DOMDocumentType createDoctypeNode(int start, int end, Integer nameStart, Integer nameEnd, Integer kindStart, Integer kindEnd, Integer publicIdStart, Integer publicIdEnd, Integer systemIdStart, Integer systemIdEnd, Integer internalSubsetStart, Integer internalSubsetEnd) {
        DOMDocumentType doctype = new DOMDocumentType(start, end);
        if (nameStart != null && nameEnd != null) {
            doctype.setName(nameStart.intValue(), nameEnd.intValue());
        }
        if (kindStart != null && kindEnd != null) {
            doctype.setKind(kindStart.intValue(), kindEnd.intValue());
        }
        if (publicIdStart != null && publicIdEnd != null) {
            doctype.setPublicId(publicIdStart.intValue(), publicIdEnd.intValue());
        }
        if (systemIdStart != null && systemIdEnd != null) {
            doctype.setSystemId(systemIdStart.intValue(), systemIdEnd.intValue());
        }
        if (internalSubsetStart != null && internalSubsetEnd != null) {
            doctype.setStartInternalSubset(internalSubsetStart.intValue());
            doctype.setEndInternalSubset(internalSubsetEnd.intValue());
        }
        doctype.end = end;
        return doctype;
    }

    private static DOMNode createNode(short nodeType, String tag, int start, Integer endTagStart, int end, boolean closed) {
        DOMNode n = DOMParserTest.createNode(nodeType, start, end);
        DOMParserTest.setRestOfNode(n, tag, endTagStart, closed);
        return n;
    }

    private static void assertDoctype(DOMDocumentType doctype, int start, int end, String name, String kind, String publicId, String systemId, String internalDTD) {
        Assertions.assertEquals((int)start, (int)doctype.getStart());
        Assertions.assertEquals((int)end, (int)doctype.getEnd());
        Assertions.assertEquals((Object)name, (Object)doctype.getName());
        Assertions.assertEquals((Object)kind, (Object)doctype.getKind());
        Assertions.assertEquals((Object)publicId, (Object)doctype.getPublicId());
        Assertions.assertEquals((Object)systemId, (Object)doctype.getSystemId());
        Assertions.assertEquals((Object)internalDTD, (Object)doctype.getInternalSubset());
    }

    private static DOMNode createNode(short nodeType, int start, int end) {
        switch (nodeType) {
            case 1: {
                return new DOMElement(start, end);
            }
            case 7: {
                return new MockProcessingInstruction(start, end);
            }
            case 4: {
                return new MockCDataSection(start, end);
            }
            case 3: {
                return new MockText(start, end);
            }
            case 8: {
                return new MockComment(start, end);
            }
        }
        return new MockNode(start, end);
    }

    private static void setRestOfNode(DOMNode n, String tag, Integer endTagStart, boolean closed) {
        if (n.isElement()) {
            ((DOMElement)n).tag = tag;
            ((DOMElement)n).endTagOpenOffset = endTagStart != null ? endTagStart : -1;
        } else if (n instanceof DOMProcessingInstruction) {
            ((DOMProcessingInstruction)n).target = tag;
            ((DOMProcessingInstruction)n).endTagOpenOffset = endTagStart != null ? endTagStart : -1;
        }
        n.closed = closed;
    }

    private static void assertDocument(String input, DOMNode expectedNode) {
        DOMDocument document = DOMParser.getInstance().parse(input, "uri", null);
        DOMNode actualNode = document.getChild(0);
        DOMParserTest.compareTrees(expectedNode, actualNode);
    }

    private static void assertDocument(String input, DOMNode expectedNode, boolean ignoreWhitespace) {
        DOMDocument document = DOMParser.getInstance().parse(input, "uri", null, ignoreWhitespace);
        DOMNode actualNode = document.getChild(0);
        DOMParserTest.compareTrees(expectedNode, actualNode);
    }

    private static void compareTrees(DOMNode expectedNode, DOMNode actualNode) {
        DTDAttlistDecl actualTemp;
        DTDAttlistDecl expectedTemp;
        if (expectedNode.isElement()) {
            Assertions.assertEquals((Object)((DOMElement)expectedNode).getTagName(), (Object)((DOMElement)actualNode).getTagName());
            Assertions.assertEquals((int)((DOMElement)expectedNode).getEndTagOpenOffset(), (int)((DOMElement)actualNode).getEndTagOpenOffset());
        } else if (expectedNode.isProcessingInstruction() || expectedNode.isProlog()) {
            Assertions.assertEquals((Object)((DOMProcessingInstruction)expectedNode).getTarget(), (Object)((DOMProcessingInstruction)actualNode).getTarget());
            Assertions.assertEquals((int)((DOMProcessingInstruction)expectedNode).getEndTagStart(), (int)((DOMProcessingInstruction)actualNode).getEndTagStart());
        }
        Assertions.assertEquals((int)expectedNode.start, (int)actualNode.start);
        Assertions.assertEquals((int)expectedNode.end, (int)actualNode.end);
        Assertions.assertEquals((Object)expectedNode.getAttributeNodes(), (Object)actualNode.getAttributeNodes());
        if (expectedNode.isCharacterData()) {
            Assertions.assertEquals((Object)((DOMCharacterData)expectedNode).getData(), (Object)((DOMCharacterData)actualNode).getData());
        }
        if (expectedNode.isDTDAttListDecl()) {
            Assertions.assertEquals((Object)true, (Object)actualNode.isDTDAttListDecl());
            expectedTemp = (DTDAttlistDecl)expectedNode;
            actualTemp = (DTDAttlistDecl)actualNode;
            Assertions.assertEquals((Object)expectedTemp.getNameParameter(), (Object)actualTemp.getNameParameter());
            Assertions.assertEquals((Object)expectedTemp.attributeName, (Object)actualTemp.attributeName);
            Assertions.assertEquals((Object)expectedTemp.attributeType, (Object)actualTemp.attributeType);
            Assertions.assertEquals((Object)expectedTemp.attributeValue, (Object)actualTemp.attributeValue);
            Assertions.assertEquals((Object)expectedTemp.unrecognized, (Object)actualTemp.unrecognized);
            List expectedInternalChildren = expectedTemp.getInternalChildren();
            List actualInternalChildren = actualTemp.getInternalChildren();
            Assertions.assertEquals((Object)(expectedInternalChildren == null ? 1 : 0), (Object)(actualInternalChildren == null ? 1 : 0));
            if (expectedInternalChildren != null) {
                Assertions.assertEquals((int)expectedInternalChildren.size(), (int)actualInternalChildren.size());
                for (int i = 0; i < expectedTemp.getInternalChildren().size(); ++i) {
                    DOMParserTest.assertInternalAttlist((DTDAttlistDecl)expectedInternalChildren.get(i), (DTDAttlistDecl)actualInternalChildren.get(i));
                }
            }
        }
        if (expectedNode.isDTDElementDecl()) {
            Assertions.assertEquals((Object)true, (Object)actualNode.isDTDElementDecl());
            expectedTemp = (DTDElementDecl)expectedNode;
            actualTemp = (DTDElementDecl)actualNode;
            Assertions.assertEquals((Object)expectedTemp.getNameParameter(), (Object)actualTemp.getNameParameter());
            Assertions.assertEquals((Object)expectedTemp.category, (Object)actualTemp.category);
            Assertions.assertEquals((Object)expectedTemp.content, (Object)actualTemp.content);
            Assertions.assertEquals((Object)expectedTemp.unrecognized, (Object)actualTemp.unrecognized);
        } else if (expectedNode.isDTDEntityDecl()) {
            Assertions.assertEquals((Object)true, (Object)actualNode.isDTDEntityDecl());
            expectedTemp = (DTDEntityDecl)expectedNode;
            actualTemp = (DTDEntityDecl)actualNode;
            Assertions.assertEquals((Object)expectedTemp.getNameParameter(), (Object)actualTemp.getNameParameter());
            Assertions.assertEquals((Object)expectedTemp.value, (Object)actualTemp.value);
            Assertions.assertEquals((Object)expectedTemp.kind, (Object)actualTemp.kind);
            Assertions.assertEquals((Object)expectedTemp.publicId, (Object)actualTemp.publicId);
            Assertions.assertEquals((Object)expectedTemp.systemId, (Object)actualTemp.systemId);
            Assertions.assertEquals((Object)expectedTemp.unrecognized, (Object)actualTemp.unrecognized);
        } else if (expectedNode.isDTDNotationDecl()) {
            Assertions.assertEquals((Object)true, (Object)actualNode.isDTDNotationDecl());
            expectedTemp = (DTDNotationDecl)expectedNode;
            actualTemp = (DTDNotationDecl)actualNode;
            Assertions.assertEquals((Object)expectedTemp.getNameParameter(), (Object)actualTemp.getNameParameter());
            Assertions.assertEquals((Object)expectedTemp.kind, (Object)actualTemp.kind);
            Assertions.assertEquals((Object)expectedTemp.publicId, (Object)actualTemp.publicId);
            Assertions.assertEquals((Object)expectedTemp.systemId, (Object)actualTemp.systemId);
            Assertions.assertEquals((Object)expectedTemp.unrecognized, (Object)actualTemp.unrecognized);
        } else if (expectedNode.isDoctype()) {
            Assertions.assertEquals((Object)true, (Object)actualNode.isDoctype());
            expectedTemp = (DOMDocumentType)expectedNode;
            actualTemp = (DOMDocumentType)actualNode;
            Assertions.assertEquals((Object)expectedTemp.getNameParameter(), (Object)actualTemp.getNameParameter());
            Assertions.assertEquals((Object)expectedTemp.kind, (Object)actualTemp.kind);
            Assertions.assertEquals((Object)expectedTemp.publicId, (Object)actualTemp.publicId);
            Assertions.assertEquals((Object)expectedTemp.systemId, (Object)actualTemp.systemId);
            Assertions.assertEquals((Object)expectedTemp.internalSubset, (Object)actualTemp.internalSubset);
        } else if (expectedNode.isGenericDTDDecl()) {
            expectedTemp = (DTDDeclNode)expectedNode;
            actualTemp = (DTDDeclNode)actualNode;
            Assertions.assertEquals((int)expectedTemp.unrecognized.start, (int)actualTemp.unrecognized.start);
            Assertions.assertEquals((int)expectedTemp.unrecognized.end, (int)actualTemp.unrecognized.end);
        }
        Assertions.assertEquals((Object)expectedNode.isClosed(), (Object)actualNode.isClosed());
        Assertions.assertEquals((Object)expectedNode.isCDATA(), (Object)actualNode.isCDATA());
        Assertions.assertEquals((Object)expectedNode.isProcessingInstruction(), (Object)actualNode.isProcessingInstruction());
        Assertions.assertEquals((Object)expectedNode.isProlog(), (Object)actualNode.isProlog());
        Assertions.assertEquals((int)expectedNode.getChildren().size(), (int)actualNode.getChildren().size());
        for (int i = 0; i < expectedNode.getChildren().size(); ++i) {
            DOMParserTest.compareTrees(expectedNode.getChild(i), actualNode.getChild(i));
        }
    }

    public static void assertInternalAttlist(DTDAttlistDecl expected, DTDAttlistDecl actual) {
        Assertions.assertEquals((Object)expected.getElementName(), (Object)actual.getElementName());
        Assertions.assertEquals((Object)expected.attributeName, (Object)actual.attributeName);
        Assertions.assertEquals((Object)expected.attributeType, (Object)actual.attributeType);
        Assertions.assertEquals((Object)expected.attributeValue, (Object)actual.attributeValue);
    }

    public void insertIntoAttributes(DOMNode n, String key, String value) {
        n.setAttribute(key, value);
    }

    public DOMDocument getXMLDocument(String input) {
        return DOMParser.getInstance().parse(input, "uri", null);
    }

    private static class MockNode
    extends DOMNode {
        public MockNode(int start, int end) {
            super(start, end);
        }

        public String getNodeName() {
            return null;
        }

        public short getNodeType() {
            return 0;
        }
    }

    private static class MockComment
    extends DOMComment {
        public String content;

        public MockComment(int start, int end) {
            super(start, end);
        }

        public String getData() {
            return this.content;
        }
    }

    private static class MockText
    extends DOMText {
        public String content;

        public MockText(int start, int end) {
            super(start, end);
        }

        public String getData() {
            return this.content;
        }
    }

    private static class MockCDataSection
    extends DOMCDATASection {
        public String content;

        public MockCDataSection(int start, int end) {
            super(start, end);
        }

        public String getData() {
            return this.content;
        }
    }

    private static class MockProcessingInstruction
    extends DOMProcessingInstruction {
        public String content;

        public MockProcessingInstruction(int start, int end) {
            super(start, end);
        }

        public String getData() {
            return this.content;
        }
    }
}

