/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xmlmodel.contentmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.XMLModel;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.utils.StringUtils;

public class CMXMLModelContentModelProvider
implements ContentModelProvider {
    private static final String XML_MODEL_BINDING_KIND = "xml-model";
    private final ContentModelManager modelManager;

    public CMXMLModelContentModelProvider(ContentModelManager modelManager) {
        this.modelManager = modelManager;
    }

    @Override
    public boolean adaptFor(DOMDocument document, boolean internal) {
        if (internal) {
            return false;
        }
        return document.hasXMLModel();
    }

    @Override
    public boolean adaptFor(String uri) {
        return false;
    }

    @Override
    public Collection<ContentModelProvider.Identifier> getIdentifiers(DOMDocument xmlDocument, String namespaceURI) {
        List<XMLModel> xmlModels = xmlDocument.getXMLModels();
        if (xmlModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ContentModelProvider.Identifier> identifiers = new ArrayList<ContentModelProvider.Identifier>();
        for (XMLModel xmlModel : xmlModels) {
            String href;
            if (!xmlModel.isApplicable() || StringUtils.isEmpty(href = xmlModel.getHref())) continue;
            identifiers.add(new ContentModelProvider.Identifier(null, href, xmlModel.getHrefNode(), XML_MODEL_BINDING_KIND));
        }
        return identifiers;
    }

    @Override
    public CMDocument createCMDocument(String uri, boolean resolveExternalEntities) {
        ContentModelProvider modelProvider = this.modelManager.getModelProviderByURI(uri);
        return modelProvider != null ? modelProvider.createCMDocument(uri, resolveExternalEntities) : null;
    }

    @Override
    public CMDocument createInternalCMDocument(DOMDocument xmlDocument, boolean resolveExternalEntities) {
        return null;
    }
}

