/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsi;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.xsi.settings.XSISchemaLocationSplit;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XSIFormatterExperimentalTest
extends AbstractCacheBasedTest {
    @Test
    public void xsiSchemaLocationSplitNone() throws BadLocationException {
        String content;
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.none, (XMLFormattingOptions)settings.getFormattingSettings());
        String expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
        settings = XSIFormatterExperimentalTest.createSettings();
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.none, (XMLFormattingOptions)settings.getFormattingSettings());
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElement() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setSplitAttributes(false);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(false);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n                                                                                 http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                                                                                 http://www.springframework.org/schema/util\r\n                                                                                 http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 4, " "), XMLAssert.te(2, 57, 3, 4, " "), XMLAssert.te(3, 24, 4, 8, ""), XMLAssert.te(4, 51, 4, 52, "\r\n                                                                                 "), XMLAssert.te(4, 112, 5, 8, "\r\n                                                                                 "), XMLAssert.te(5, 50, 5, 51, "\r\n                                                                                 "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithPreserveLineBreaks() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n  xmlns=\"http://www.springframework.org/schema/beans\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  xmlns:util=\"http://www.springframework.org/schema/util\"\r\n  xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n                      http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                      http://www.springframework.org/schema/util\r\n                      http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 4, "\r\n  "), XMLAssert.te(2, 55, 3, 4, "\r\n  "), XMLAssert.te(3, 57, 4, 4, "\r\n  "), XMLAssert.te(4, 59, 5, 4, "\r\n  "), XMLAssert.te(5, 24, 6, 8, ""), XMLAssert.te(6, 51, 6, 52, "\r\n                      "), XMLAssert.te(6, 112, 7, 8, "\r\n                      "), XMLAssert.te(7, 50, 7, 51, "\r\n                      "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithSplitAttribute() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n                        http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                        http://www.springframework.org/schema/util\r\n                        http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(5, 24, 6, 8, ""), XMLAssert.te(6, 51, 6, 52, "\r\n                        "), XMLAssert.te(6, 112, 7, 8, "\r\n                        "), XMLAssert.te(7, 50, 7, 51, "\r\n                        "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    public String toString() {
        return "XSIFormatterExperimentalTest []";
    }

    @Test
    public void xsiSchemaLocationSplitOnPair() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setSplitAttributes(false);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(false);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onPair, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                                                                                 http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 4, " "), XMLAssert.te(2, 78, 3, 8, ""), XMLAssert.te(3, 112, 4, 8, "\r\n                                                                                 "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnPairWithSplitAttribute() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onPair, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(5, 24, 6, 8, ""), XMLAssert.te(6, 112, 7, 8, "\r\n                        "), XMLAssert.te(7, 111, 9, 0, " "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnPairWithPreserveLineBreaks() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onPair, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"   xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                                                                            http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 4, "\r\n  "), XMLAssert.te(2, 57, 2, 60, " "), XMLAssert.te(2, 80, 3, 8, ""), XMLAssert.te(3, 112, 4, 8, "\r\n                                                                            "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnPairWasElement() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onPair, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n                        http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                        http://www.springframework.org/schema/util\r\n                        http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n                        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(5, 67, 6, 24, " "), XMLAssert.te(7, 66, 8, 24, " "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationEmpty() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=</beans>";
        XSIFormatterExperimentalTest.assertFormat(content, content, settings, new TextEdit[0]);
        content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"</beans>";
        XSIFormatterExperimentalTest.assertFormat(content, content, settings, new TextEdit[0]);
        content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"\"</beans>";
        XSIFormatterExperimentalTest.assertFormat(content, content, settings, new TextEdit[0]);
        content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=";
        XSIFormatterExperimentalTest.assertFormat(content, content, settings, new TextEdit[0]);
        content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"";
        XSIFormatterExperimentalTest.assertFormat(content, content, settings, new TextEdit[0]);
        content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"\"";
        XSIFormatterExperimentalTest.assertFormat(content, content, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithTabs() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(false);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t http://www.springframework.org/schema/beans/spring-beans.xsd\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t http://www.springframework.org/schema/util\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t http://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 4, " "), XMLAssert.te(2, 57, 3, 4, " "), XMLAssert.te(3, 24, 4, 8, ""), XMLAssert.te(4, 51, 4, 52, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t "), XMLAssert.te(4, 112, 5, 8, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t "), XMLAssert.te(5, 50, 5, 51, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t "), XMLAssert.te(5, 111, 7, 0, " "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithTabsWithSplitAttribute() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        settings.getFormattingSettings().setSplitAttributes(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n\t\txmlns=\"http://www.springframework.org/schema/beans\"\r\n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\t\txmlns:util=\"http://www.springframework.org/schema/util\"\r\n\t\txsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n\t\t\t\t\t\t\thttp://www.springframework.org/schema/beans/spring-beans.xsd\r\n\t\t\t\t\t\t\thttp://www.springframework.org/schema/util\r\n\t\t\t\t\t\t\thttp://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 4, "\r\n\t\t"), XMLAssert.te(2, 55, 3, 4, "\r\n\t\t"), XMLAssert.te(3, 57, 4, 4, "\r\n\t\t"), XMLAssert.te(4, 59, 5, 4, "\r\n\t\t"), XMLAssert.te(5, 24, 6, 8, ""), XMLAssert.te(6, 51, 6, 52, "\r\n\t\t\t\t\t\t\t"), XMLAssert.te(6, 112, 7, 8, "\r\n\t\t\t\t\t\t\t"), XMLAssert.te(7, 50, 7, 51, "\r\n\t\t\t\t\t\t\t"), XMLAssert.te(7, 111, 9, 0, " "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithTabsWithPreserveLineBreaksOnSome() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n\txmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/beans/spring-beans.xsd\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/util\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 4, "\r\n\t"), XMLAssert.te(2, 109, 3, 4, "\r\n\t"), XMLAssert.te(3, 80, 4, 8, ""), XMLAssert.te(4, 51, 4, 52, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(4, 112, 5, 8, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(5, 50, 5, 51, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(5, 111, 7, 0, " "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithTabsWithPreserveLineBreaksWithDiffIndent() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n      xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n      xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n\txmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/beans/spring-beans.xsd\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/util\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 6, "\r\n\t"), XMLAssert.te(2, 111, 3, 6, "\r\n\t"), XMLAssert.te(3, 82, 4, 8, ""), XMLAssert.te(4, 51, 4, 52, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(4, 112, 5, 8, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(5, 50, 5, 51, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(5, 111, 7, 0, " "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithTabsWithPreserveLineBreaksWithMultiTabIndent() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n        xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n        xmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n\txmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txmlns:util=\"http://www.springframework.org/schema/util\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/beans/spring-beans.xsd\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/util\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thttp://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 8, "\r\n\t"), XMLAssert.te(2, 113, 3, 8, "\r\n\t"), XMLAssert.te(3, 84, 4, 8, ""), XMLAssert.te(4, 51, 4, 52, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(4, 112, 5, 8, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(5, 50, 5, 51, "\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"), XMLAssert.te(5, 111, 7, 0, " "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsiSchemaLocationSplitOnElementWithTabsWithPreserveLineBreaks() throws BadLocationException {
        SharedSettings settings = XSIFormatterExperimentalTest.createSettings();
        settings.getFormattingSettings().setTabSize(4);
        settings.getFormattingSettings().setInsertSpaces(false);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        XSISchemaLocationSplit.setSplit((XSISchemaLocationSplit)XSISchemaLocationSplit.onElement, (XMLFormattingOptions)settings.getFormattingSettings());
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n    xmlns=\"http://www.springframework.org/schema/beans\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:util=\"http://www.springframework.org/schema/util\"\r\n    xsi:schemaLocation=\"\r\n        http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n        http://www.springframework.org/schema/util http://www.springframework.org/schema/util/spring-util.xsd\">\r\n\r\n</beans>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans\r\n\txmlns=\"http://www.springframework.org/schema/beans\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txmlns:util=\"http://www.springframework.org/schema/util\"\r\n\txsi:schemaLocation=\"http://www.springframework.org/schema/beans\r\n\t\t\t\t\t\thttp://www.springframework.org/schema/beans/spring-beans.xsd\r\n\t\t\t\t\t\thttp://www.springframework.org/schema/util\r\n\t\t\t\t\t\thttp://www.springframework.org/schema/util/spring-util.xsd\"> </beans>";
        XSIFormatterExperimentalTest.assertFormat(content, expected, settings, XMLAssert.te(1, 6, 2, 4, "\r\n\t"), XMLAssert.te(2, 55, 3, 4, "\r\n\t"), XMLAssert.te(3, 57, 4, 4, "\r\n\t"), XMLAssert.te(4, 59, 5, 4, "\r\n\t"), XMLAssert.te(5, 24, 6, 8, ""), XMLAssert.te(6, 51, 6, 52, "\r\n\t\t\t\t\t\t"), XMLAssert.te(6, 112, 7, 8, "\r\n\t\t\t\t\t\t"), XMLAssert.te(7, 50, 7, 51, "\r\n\t\t\t\t\t\t"), XMLAssert.te(7, 111, 9, 0, " "));
        XSIFormatterExperimentalTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XSIFormatterExperimentalTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XSIFormatterExperimentalTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }

    private static SharedSettings createSettings() {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setTabSize(2);
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(true);
        settings.getFormattingSettings().setExperimental(true);
        return settings;
    }
}

