/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.completion;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLCompletionBasedOnRelaxNGCompactSyntaxTest
extends BaseFileTempTest {
    @Test
    public void completionInRoot() throws BadLocationException {
        String xml = "<?xml-model href=\"addressBook.rnc\" ?>\r\n<|";
        XMLCompletionBasedOnRelaxNGCompactSyntaxTest.testCompletionFor(xml, XMLAssert.c("addressBook", XMLAssert.te(1, 0, 1, 1, "<addressBook></addressBook>"), "<addressBook"));
    }

    @Test
    public void completionForElements() throws BadLocationException {
        String xml = "<?xml-model href=\"addressBook.rnc\" ?>\r\n<addressBook>\r\n<|\r\n</addressBook>";
        XMLCompletionBasedOnRelaxNGCompactSyntaxTest.testCompletionFor(xml, XMLAssert.c("card", XMLAssert.te(2, 0, 2, 1, "<card></card>"), "<card"));
    }

    @Test
    public void completionForAttributeNames() throws BadLocationException {
        String xml = "<?xml-model href=\"addressBook.rnc\" ?>\r\n<addressBook>\r\n<card |></card>\r\n</addressBook>";
        XMLCompletionBasedOnRelaxNGCompactSyntaxTest.testCompletionFor(xml, XMLAssert.c("id", XMLAssert.te(2, 6, 2, 6, "id=\"\""), "id"));
    }

    public static void testCompletionFor(String value, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), value, null, null, "src/test/resources/relaxng/test.xml", null, true, expectedItems);
    }
}

