/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class XMLCompletionBasedForRelaxNGGrammarTest
extends BaseFileTempTest {
    @Test
    public void completionOnRoot() throws BadLocationException {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\">\r\n  <|\r\n</grammar>";
        XMLCompletionBasedForRelaxNGGrammarTest.testCompletionFor(xml, 6, XMLAssert.c("include", XMLAssert.te(1, 2, 1, 3, "<include href=\"\"></include>"), "<include"), XMLAssert.c("div", XMLAssert.te(1, 2, 1, 3, "<div></div>"), "<div"), XMLAssert.c("start", XMLAssert.te(1, 2, 1, 3, "<start></start>"), "<start"), XMLAssert.c("define", XMLAssert.te(1, 2, 1, 3, "<define name=\"\"></define>"), "<define"));
    }

    @Test
    public void completionOnElementNoName() throws BadLocationException {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\t<start>\r\n\t\t<ref name=\"foo\"/>\r\n\t</start>\r\n\t<define name=\"foo\">\r\n\t\t\t<element>\r\n\t\t\t\t<|\r\n\t\t\t</element>\r\n\t</define>\r\n</grammar>";
        XMLCompletionBasedForRelaxNGGrammarTest.testCompletionFor(xml, 6, XMLAssert.c("choice", XMLAssert.te(7, 4, 7, 5, "<choice></choice>"), "<choice"), XMLAssert.c("nsName", XMLAssert.te(7, 4, 7, 5, "<nsName></nsName>"), "<nsName"), XMLAssert.c("name", XMLAssert.te(7, 4, 7, 5, "<name></name>"), "<name"), XMLAssert.c("anyName", XMLAssert.te(7, 4, 7, 5, "<anyName></anyName>"), "<anyName"));
    }

    @Test
    public void completionOnElementWithName() throws BadLocationException {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n\tdatatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n\t<start>\r\n\t\t<ref name=\"foo\"/>\r\n\t</start>\r\n\t<define name=\"foo\">\r\n\t\t\t<element name=\"foo\">\r\n\t\t\t\t<|\r\n\t\t\t</element>\r\n\t</define>\r\n</grammar>";
        XMLCompletionBasedForRelaxNGGrammarTest.testCompletionFor(xml, 21, XMLAssert.c("interleave", XMLAssert.te(7, 4, 7, 5, "<interleave></interleave>"), "<interleave"), XMLAssert.c("zeroOrMore", XMLAssert.te(7, 4, 7, 5, "<zeroOrMore></zeroOrMore>"), "<zeroOrMore"), XMLAssert.c("grammar", XMLAssert.te(7, 4, 7, 5, "<grammar></grammar>"), "<grammar"), XMLAssert.c("ref", XMLAssert.te(7, 4, 7, 5, "<ref name=\"\"></ref>"), "<ref"), XMLAssert.c("value", XMLAssert.te(7, 4, 7, 5, "<value></value>"), "<value"), XMLAssert.c("choice", XMLAssert.te(7, 4, 7, 5, "<choice></choice>"), "<choice"), XMLAssert.c("notAllowed", XMLAssert.te(7, 4, 7, 5, "<notAllowed></notAllowed>"), "<notAllowed"), XMLAssert.c("element", XMLAssert.te(7, 4, 7, 5, "<element></element>"), "<element"), XMLAssert.c("group", XMLAssert.te(7, 4, 7, 5, "<group></group>"), "<group"), XMLAssert.c("attribute", XMLAssert.te(7, 4, 7, 5, "<attribute></attribute>"), "<attribute"), XMLAssert.c("text", XMLAssert.te(7, 4, 7, 5, "<text></text>"), "<text"), XMLAssert.c("data", XMLAssert.te(7, 4, 7, 5, "<data type=\"\"></data>"), "<data"), XMLAssert.c("oneOrMore", XMLAssert.te(7, 4, 7, 5, "<oneOrMore></oneOrMore>"), "<oneOrMore"), XMLAssert.c("externalRef", XMLAssert.te(7, 4, 7, 5, "<externalRef href=\"\"></externalRef>"), "<externalRef"), XMLAssert.c("list", XMLAssert.te(7, 4, 7, 5, "<list></list>"), "<list"), XMLAssert.c("parentRef", XMLAssert.te(7, 4, 7, 5, "<parentRef name=\"\"></parentRef>"), "<parentRef"), XMLAssert.c("empty", XMLAssert.te(7, 4, 7, 5, "<empty></empty>"), "<empty"), XMLAssert.c("optional", XMLAssert.te(7, 4, 7, 5, "<optional></optional>"), "<optional"), XMLAssert.c("mixed", XMLAssert.te(7, 4, 7, 5, "<mixed></mixed>"), "<mixed"));
    }

    private static void testCompletionFor(String value, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(new XMLLanguageService(), value, null, null, "src/test/resources/relaxng/test.xml", expectedCount, true, expectedItems);
    }
}

