/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.XMLFoldingSettings;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLFoldings {
    private static Logger LOGGER = Logger.getLogger(XMLFoldings.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;
    private static final Pattern REGION_PATTERN = Pattern.compile("\\s*#(region\\b)|(endregion\\b)");

    public XMLFoldings(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<FoldingRange> getFoldingRanges(TextDocument document, XMLFoldingSettings context, CancelChecker cancelChecker) {
        Scanner scanner = XMLScanner.createScanner(document.getText());
        TokenType token = scanner.scan();
        List<FoldingRange> ranges = new ArrayList<FoldingRange>();
        ArrayList<TagInfo> stack = new ArrayList<TagInfo>();
        String lastTagName = null;
        int prevStart = -1;
        try {
            int rangeLimit;
            while (token != TokenType.EOS) {
                cancelChecker.checkCanceled();
                switch (token) {
                    case StartTag: {
                        String tagName = scanner.getTokenText();
                        int startLine = document.positionAt(scanner.getTokenOffset()).getLine();
                        stack.add(new TagInfo(startLine, tagName));
                        lastTagName = tagName;
                        break;
                    }
                    case EndTag: {
                        lastTagName = scanner.getTokenText();
                        break;
                    }
                    case StartTagClose: {
                        if (lastTagName != null) break;
                    }
                    case EndTagClose: 
                    case StartTagSelfClose: {
                        int i;
                        for (i = stack.size() - 1; i >= 0 && !((TagInfo)stack.get((int)i)).tagName.equals(lastTagName); --i) {
                        }
                        if (i < 0) break;
                        TagInfo stackElement = (TagInfo)stack.get(i);
                        int j = stack.size() - 1;
                        while (j >= i) {
                            stack.remove(j--);
                        }
                        int startLine = stackElement.startLine;
                        int endLine = document.positionAt(scanner.getTokenOffset()).getLine();
                        if (endLine <= startLine || prevStart == startLine) break;
                        prevStart = XMLFoldings.addRange(new FoldingRange(startLine, endLine), ranges);
                        break;
                    }
                    case Comment: {
                        int startLine = document.positionAt(scanner.getTokenOffset()).getLine();
                        String text = scanner.getTokenText();
                        Matcher m = REGION_PATTERN.matcher(text);
                        if (m.find()) {
                            int i;
                            if ("#region".equals(m.group().trim())) {
                                stack.add(new TagInfo(startLine, ""));
                                break;
                            }
                            for (i = stack.size() - 1; i >= 0 && ((TagInfo)stack.get((int)i)).tagName != null && !((TagInfo)stack.get((int)i)).tagName.isEmpty(); --i) {
                            }
                            if (i < 0) break;
                            TagInfo stackElement = (TagInfo)stack.get(i);
                            int j = stack.size() - 1;
                            while (j >= i) {
                                stack.remove(j--);
                            }
                            int endLine = startLine;
                            if (endLine <= (startLine = stackElement.startLine) || prevStart == startLine) break;
                            FoldingRange range = new FoldingRange(startLine, endLine);
                            range.setKind("region");
                            prevStart = XMLFoldings.addRange(range, ranges);
                            break;
                        }
                        int endLine = document.positionAt(scanner.getTokenOffset() + scanner.getTokenLength()).getLine();
                        if (startLine >= endLine) break;
                        FoldingRange range = new FoldingRange(startLine, endLine);
                        range.setKind("comment");
                        prevStart = XMLFoldings.addRange(range, ranges);
                        break;
                    }
                }
                token = scanner.scan();
            }
            int n = rangeLimit = context != null && context.getRangeLimit() != null ? context.getRangeLimit() : Integer.MAX_VALUE;
            if (ranges.size() > rangeLimit) {
                ranges = XMLFoldings.limitRanges(ranges, rangeLimit);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Foldings received a BadLocation while scanning the document", e);
        }
        catch (StackOverflowError e) {
            LOGGER.log(Level.SEVERE, "Foldings received a StackOverflowError while scanning the document", e);
        }
        return ranges;
    }

    private static int addRange(FoldingRange range, List<FoldingRange> ranges) {
        ranges.add(range);
        return range.getStartLine();
    }

    private static List<FoldingRange> limitRanges(List<FoldingRange> ranges, int rangeLimit) {
        Collections.sort(ranges, (r1, r2) -> {
            int diff = r1.getStartLine() - r2.getStartLine();
            if (diff == 0) {
                diff = r1.getEndLine() - r2.getEndLine();
            }
            return diff;
        });
        FoldingRange top = null;
        ArrayList<FoldingRange> previous = new ArrayList<FoldingRange>();
        HashMap<Integer, Integer> nestingLevels = new HashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> nestingLevelCounts = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < ranges.size(); ++i) {
            FoldingRange entry = ranges.get(i);
            if (top == null) {
                top = entry;
                XMLFoldings.setNestingLevel(i, 0, nestingLevels, nestingLevelCounts);
                continue;
            }
            if (entry.getStartLine() <= top.getStartLine()) continue;
            if (entry.getEndLine() <= top.getEndLine()) {
                previous.add(top);
                top = entry;
                XMLFoldings.setNestingLevel(i, previous.size(), nestingLevels, nestingLevelCounts);
                continue;
            }
            if (entry.getStartLine() <= top.getEndLine()) continue;
            while ((top = (FoldingRange)previous.remove(previous.size() - 1)) != null && entry.getStartLine() > top.getEndLine()) {
            }
            if (top != null) {
                previous.add(top);
            }
            top = entry;
            XMLFoldings.setNestingLevel(i, previous.size(), nestingLevels, nestingLevelCounts);
        }
        int entries = 0;
        int maxLevel = 0;
        for (Map.Entry entry : nestingLevelCounts.entrySet()) {
            Integer n = (Integer)entry.getValue();
            if (n + entries > rangeLimit) {
                maxLevel = (Integer)entry.getKey();
                break;
            }
            entries += n.intValue();
        }
        ArrayList<FoldingRange> result = new ArrayList<FoldingRange>();
        for (int i = 0; i < ranges.size(); ++i) {
            Integer level = (Integer)nestingLevels.get(i);
            if (level == null || level >= maxLevel && (level != maxLevel || entries++ >= rangeLimit)) continue;
            result.add(ranges.get(i));
        }
        return result;
    }

    private static void setNestingLevel(int index, int level, Map<Integer, Integer> nestingLevels, Map<Integer, Integer> nestingLevelCounts) {
        nestingLevels.put(index, level);
        if (level < 30) {
            nestingLevelCounts.put(level, (nestingLevelCounts.containsKey(level) ? nestingLevelCounts.get(level) : 0) + 1);
        }
    }

    class TagInfo {
        public final int startLine;
        public final String tagName;

        public TagInfo(int startLine, String tagName) {
            this.startLine = startLine;
            this.tagName = tagName;
        }
    }
}

