/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocationHint;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLModelUtils;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.TargetNamespace_1CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.TargetNamespace_2CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.cvc_attribute_3CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.cvc_complex_type_2_1CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.cvc_complex_type_2_3CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.cvc_complex_type_2_4_aCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.cvc_complex_type_3_2_2CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.cvc_complex_type_4CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.cvc_enumeration_validCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.cvc_type_3_1_1CodeAction;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.schema_reference_4CodeAction;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Range;

public enum XMLSchemaErrorCode implements IXMLErrorCode
{
    cvc_complex_type_2_3("cvc-complex-type.2.3"),
    cvc_complex_type_2_2("cvc-complex-type.2.2"),
    cvc_complex_type_2_1("cvc-complex-type.2.1"),
    cvc_complex_type_2_4_a("cvc-complex-type.2.4.a"),
    cvc_complex_type_2_4_b("cvc-complex-type.2.4.b"),
    cvc_complex_type_2_4_c("cvc-complex-type.2.4.c"),
    cvc_complex_type_2_4_d("cvc-complex-type.2.4.d"),
    cvc_complex_type_2_4_f("cvc-complex-type.2.4.f"),
    cvc_complex_type_3_1("cvc-complex-type.3.1"),
    cvc_complex_type_3_2_2("cvc-complex-type.3.2.2"),
    cvc_complex_type_4("cvc-complex-type.4"),
    cvc_datatype_valid_1_2_1("cvc-datatype-valid.1.2.1"),
    cvc_datatype_valid_1_2_3("cvc-datatype-valid.1.2.3"),
    cvc_elt_1_a("cvc-elt.1.a"),
    cvc_elt_3_1("cvc-elt.3.1"),
    cvc_elt_3_2_1("cvc-elt.3.2.1"),
    cvc_elt_4_2("cvc-elt.4.2"),
    cvc_pattern_valid("cvc-pattern-valid"),
    cvc_type_3_1_1("cvc-type.3.1.1"),
    cvc_type_3_1_2("cvc-type.3.1.2"),
    cvc_type_3_1_3("cvc-type.3.1.3"),
    cvc_attribute_3("cvc-attribute.3"),
    cvc_enumeration_valid("cvc-enumeration-valid"),
    cvc_maxlength_valid("cvc-maxLength-valid"),
    cvc_minlength_valid("cvc-minLength-valid"),
    cvc_maxExclusive_valid("cvc-maxExclusive-valid"),
    cvc_maxInclusive_valid("cvc-maxInclusive-valid"),
    cvc_minExclusive_valid("cvc-minExclusive-valid"),
    cvc_minInclusive_valid("cvc-minInclusive-valid"),
    TargetNamespace_1("TargetNamespace.1"),
    TargetNamespace_2("TargetNamespace.2"),
    SchemaLocation("SchemaLocation"),
    schema_reference_4("schema_reference.4"),
    src_element_3("src-element.3");

    private final String code;
    private static final Map<String, XMLSchemaErrorCode> codes;

    private XMLSchemaErrorCode() {
        this(null);
    }

    private XMLSchemaErrorCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return this.name();
        }
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public static XMLSchemaErrorCode get(String name) {
        return codes.get(name);
    }

    public static Range toLSPRange(XMLLocator location, XMLSchemaErrorCode code, Object[] arguments, DOMDocument document) {
        int offset = location.getCharacterOffset() - 1;
        switch (code) {
            case cvc_complex_type_2_3: {
                return XMLPositionUtility.selectFirstNonWhitespaceText(offset, document);
            }
            case cvc_complex_type_2_2: 
            case cvc_complex_type_2_4_a: 
            case cvc_complex_type_2_4_b: 
            case cvc_complex_type_2_4_c: 
            case cvc_complex_type_2_4_d: 
            case cvc_complex_type_2_4_f: 
            case cvc_elt_1_a: 
            case cvc_complex_type_4: 
            case src_element_3: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
            case cvc_complex_type_3_2_2: {
                String attrName = StringUtils.getString(arguments[1]);
                return XMLPositionUtility.selectAttributeNameFromGivenNameAt(attrName, offset, document);
            }
            case cvc_elt_3_1: {
                String namespaceAntAttrName;
                String attrName = namespaceAntAttrName = StringUtils.getString(arguments[1]);
                int index = namespaceAntAttrName.indexOf(",");
                if (index != -1) {
                    String namespaceURI = namespaceAntAttrName.substring(0, index);
                    String prefix = document.getDocumentElement().getPrefix(namespaceURI);
                    attrName = namespaceAntAttrName.substring(index + 1, namespaceAntAttrName.length());
                    if (prefix != null && !prefix.isEmpty()) {
                        attrName = prefix + ":" + attrName;
                    }
                }
                return XMLPositionUtility.selectAttributeFromGivenNameAt(attrName, offset, document);
            }
            case cvc_pattern_valid: {
                String value = StringUtils.getString(arguments[0]);
                Range result = XMLPositionUtility.selectAttributeValueByGivenValueAt(value, offset, document);
                if (result != null) {
                    return result;
                }
                return XMLPositionUtility.selectTrimmedText(offset, document);
            }
            case SchemaLocation: {
                SchemaLocation schemaLocation = document.getSchemaLocation();
                DOMNode locationRange = schemaLocation.getAttr().getNodeAttrValue();
                return locationRange != null ? XMLPositionUtility.createRange(locationRange) : null;
            }
            case schema_reference_4: {
                String hrefLocation = arguments.length == 1 ? (String)arguments[0] : null;
                DOMRange locationRange = XMLModelUtils.getHrefNode(document, hrefLocation);
                if (locationRange == null) {
                    NoNamespaceSchemaLocation noNamespaceSchemaLocation = document.getNoNamespaceSchemaLocation();
                    if (noNamespaceSchemaLocation != null) {
                        locationRange = noNamespaceSchemaLocation.getAttr().getNodeAttrValue();
                    } else {
                        SchemaLocation schemaLocation = document.getSchemaLocation();
                        if (schemaLocation != null) {
                            String invalidSchemaPath;
                            String string = invalidSchemaPath = arguments[0] instanceof String ? (String)arguments[0] : null;
                            if (invalidSchemaPath != null) {
                                for (SchemaLocationHint locHintRange : schemaLocation.getSchemaLocationHints()) {
                                    String expandedHint = XMLSchemaErrorCode.getResolvedLocation(document.getDocumentURI(), locHintRange.getHint());
                                    if (!invalidSchemaPath.equals(expandedHint)) continue;
                                    return XMLPositionUtility.createRange(locHintRange);
                                }
                            }
                            locationRange = schemaLocation.getAttr().getNodeAttrValue();
                        }
                    }
                }
                return locationRange != null ? XMLPositionUtility.createRange(locationRange) : null;
            }
            case cvc_attribute_3: 
            case cvc_complex_type_3_1: 
            case cvc_elt_4_2: {
                String attrName = StringUtils.getString(arguments[1]);
                return XMLPositionUtility.selectAttributeValueAt(attrName, offset, document);
            }
            case cvc_type_3_1_1: {
                return XMLPositionUtility.selectAllAttributes(offset, document);
            }
            case cvc_complex_type_2_1: 
            case cvc_elt_3_2_1: {
                return XMLPositionUtility.selectContent(offset, document);
            }
            case cvc_type_3_1_3: 
            case cvc_datatype_valid_1_2_1: 
            case cvc_datatype_valid_1_2_3: 
            case cvc_enumeration_valid: 
            case cvc_maxlength_valid: 
            case cvc_minlength_valid: 
            case cvc_maxExclusive_valid: 
            case cvc_maxInclusive_valid: 
            case cvc_minExclusive_valid: 
            case cvc_minInclusive_valid: {
                String attrValue = StringUtils.getString(arguments[0]);
                Range range = XMLPositionUtility.selectAttributeValueFromGivenValue(attrValue, offset, document);
                if (range != null) {
                    return range;
                }
                DOMElement element = (DOMElement)document.findNodeAt(offset);
                if (element != null && element.isEmpty()) {
                    return XMLPositionUtility.selectStartTagName(element);
                }
                if (DOMUtils.containsTextOnly(element)) {
                    return XMLPositionUtility.selectTrimmedText(offset, document);
                }
                return XMLPositionUtility.selectFirstChild(offset, document);
            }
            case cvc_type_3_1_2: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
            case TargetNamespace_1: {
                return XMLPositionUtility.selectRootAttributeValue("xmlns", document);
            }
            case TargetNamespace_2: {
                return XMLPositionUtility.selectRootStartTag(document);
            }
        }
        return null;
    }

    public static void registerCodeActionParticipants(Map<String, ICodeActionParticipant> codeActions, SharedSettings sharedSettings) {
        codeActions.put(cvc_complex_type_2_4_a.getCode(), new cvc_complex_type_2_4_aCodeAction());
        codeActions.put(cvc_complex_type_2_4_c.getCode(), new cvc_complex_type_2_4_aCodeAction());
        codeActions.put(cvc_complex_type_2_3.getCode(), new cvc_complex_type_2_3CodeAction());
        codeActions.put(cvc_complex_type_4.getCode(), new cvc_complex_type_4CodeAction());
        codeActions.put(cvc_type_3_1_1.getCode(), new cvc_type_3_1_1CodeAction());
        codeActions.put(cvc_attribute_3.getCode(), new cvc_attribute_3CodeAction());
        codeActions.put(cvc_complex_type_3_2_2.getCode(), new cvc_complex_type_3_2_2CodeAction());
        codeActions.put(cvc_enumeration_valid.getCode(), new cvc_enumeration_validCodeAction());
        codeActions.put(cvc_complex_type_2_1.getCode(), new cvc_complex_type_2_1CodeAction());
        codeActions.put(TargetNamespace_1.getCode(), new TargetNamespace_1CodeAction());
        codeActions.put(TargetNamespace_2.getCode(), new TargetNamespace_2CodeAction());
        if (sharedSettings.getWorkspaceSettings().isResourceOperationSupported("create")) {
            codeActions.put(schema_reference_4.getCode(), new schema_reference_4CodeAction());
        }
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (location == null) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId((String)location, (String)documentURI, (boolean)false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }

    static {
        codes = new HashMap<String, XMLSchemaErrorCode>();
        for (XMLSchemaErrorCode errorCode : XMLSchemaErrorCode.values()) {
            codes.put(errorCode.getCode(), errorCode);
        }
    }
}

