/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators;

import java.util.ArrayList;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.extensions.generators.AttributeDeclaration;
import org.eclipse.lemminx.extensions.generators.ContainerDeclaration;
import org.eclipse.lemminx.extensions.generators.ElementDeclaration;
import org.eclipse.lemminx.extensions.generators.FileContentGeneratorSettings;
import org.eclipse.lemminx.extensions.generators.Grammar;
import org.eclipse.lemminx.extensions.generators.IFileContentGenerator;
import org.eclipse.lemminx.services.IXMLFullFormatter;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXML2GrammarGenerator<T extends FileContentGeneratorSettings>
implements IFileContentGenerator<Document, T> {
    @Override
    public String generate(Document prototypeDocument, SharedSettings sharedSettings, T generatorSettings, IXMLFullFormatter formatter) {
        String newText = this.doGenerate(prototypeDocument, sharedSettings, generatorSettings);
        if (formatter == null) {
            return newText;
        }
        return formatter.formatFull(newText, "grammar." + this.getFileExtension(), sharedSettings);
    }

    protected abstract String getFileExtension();

    private String doGenerate(Document sourceDocument, SharedSettings sharedSettings, T generatorSettings) {
        Grammar grammar = AbstractXML2GrammarGenerator.createGrammar(sourceDocument, this.isFlat());
        XMLBuilder builder = new XMLBuilder(sharedSettings, "", "");
        this.generate(grammar, generatorSettings, builder);
        return builder.toString();
    }

    protected boolean isFlat() {
        return false;
    }

    protected abstract void generate(Grammar var1, T var2, XMLBuilder var3);

    private static Grammar createGrammar(Document sourceDocument, boolean flat) {
        Grammar grammar = new Grammar();
        String defaultNamespace = null;
        Element documentElement = sourceDocument.getDocumentElement();
        if (documentElement != null) {
            defaultNamespace = documentElement.getAttribute("xmlns");
        }
        grammar.setDefaultNamespace(defaultNamespace);
        AbstractXML2GrammarGenerator.fillElements(sourceDocument, grammar, grammar, flat);
        return grammar;
    }

    private static void fillElements(Node node, Grammar grammar, ContainerDeclaration parent, boolean flat) {
        NodeList children = node.getChildNodes();
        if (parent instanceof ElementDeclaration) {
            ArrayList<String> tags = new ArrayList<String>();
            ElementDeclaration parentDecl = (ElementDeclaration)parent;
            for (int i = 0; i < children.getLength(); ++i) {
                Element element;
                String localName;
                Node child = children.item(i);
                if (child.getNodeType() != 1 || StringUtils.isEmpty(localName = (element = (Element)child).getLocalName())) continue;
                tags.add(localName);
            }
            parentDecl.addChildHierarchy(tags);
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (element = (Element)child).getLocalName() == null) continue;
            ElementDeclaration elementDecl = AbstractXML2GrammarGenerator.getElementDecl(grammar, parent, flat, element);
            if (!elementDecl.hasCharacterContent()) {
                elementDecl.setHasCharacterContent(AbstractXML2GrammarGenerator.hasCharacterContent(element));
            }
            elementDecl.incrementOccurrences();
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Attr attr = (Attr)attributes.item(j);
                    if (AbstractXML2GrammarGenerator.isIgnore(attr)) continue;
                    AttributeDeclaration attributeDecl = elementDecl.getAttribute(attr.getName());
                    attributeDecl.incrementOccurrences();
                    attributeDecl.addValue(attr.getValue());
                }
            }
            AbstractXML2GrammarGenerator.fillElements(element, grammar, elementDecl, flat);
        }
    }

    private static boolean isIgnore(Attr attr) {
        String name = attr.getName();
        if (StringUtils.isEmpty(name)) {
            return true;
        }
        if (DOMAttr.isXmlns(name)) {
            return true;
        }
        return name.indexOf(58) != -1;
    }

    private static ElementDeclaration getElementDecl(Grammar grammar, ContainerDeclaration container, boolean flat, Element element) {
        String name = element.getLocalName();
        if (flat) {
            ElementDeclaration elementDecl = grammar.getElement(name);
            container.addElement(elementDecl);
            return elementDecl;
        }
        return container.getElement(name);
    }

    private static boolean hasCharacterContent(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return true;
        }
        return false;
    }
}

