/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.eclipse.lemminx.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.NodeList;

public class DOMDocumentTest {
    @Test
    public void testLargeFileWithScanner() {
        InputStream in = DOMDocumentTest.class.getResourceAsStream("/xml/largeFile.xml");
        String text = IOUtils.convertStreamToString((InputStream)in);
        long start = System.currentTimeMillis();
        Scanner scanner = XMLScanner.createScanner((String)text);
        TokenType token = scanner.scan();
        while (token != TokenType.EOS) {
            token = scanner.scan();
        }
        System.err.println("Parsed 'largeFile.xml' with XMLScanner in " + (System.currentTimeMillis() - start) + " ms.");
    }

    @Test
    public void testLargeFileWithDocument() {
        InputStream in = DOMDocumentTest.class.getResourceAsStream("/xml/largeFile.xml");
        String text = IOUtils.convertStreamToString((InputStream)in);
        TextDocument document = new TextDocument(text, "largeFile.xml");
        long start = System.currentTimeMillis();
        DOMParser.getInstance().parse(document, null);
        System.err.println("Parsed 'largeFile.xml' with XMLParser in " + (System.currentTimeMillis() - start) + " ms.");
    }

    @Test
    public void testBigLargeFileWithScanner() {
        InputStream in = DOMDocumentTest.class.getResourceAsStream("/xml/nasa.xml");
        String text = IOUtils.convertStreamToString((InputStream)in);
        long start = System.currentTimeMillis();
        Scanner scanner = XMLScanner.createScanner((String)text);
        TokenType token = scanner.scan();
        while (token != TokenType.EOS) {
            token = scanner.scan();
        }
        System.err.println("Parsed 'nasa.xml' with XMLScanner in " + (System.currentTimeMillis() - start) + " ms.");
    }

    @Test
    public void testBigLargeFileWithDocument() {
        InputStream in = DOMDocumentTest.class.getResourceAsStream("/xml/nasa.xml");
        String text = IOUtils.convertStreamToString((InputStream)in);
        TextDocument document = new TextDocument(text, "nasa.xml");
        long start = System.currentTimeMillis();
        DOMParser.getInstance().parse(document, null);
        System.err.println("Parsed 'nasa.xml' with XMLParser in " + (System.currentTimeMillis() - start) + " ms.");
    }

    @Test
    public void findOneElementWithW3CAndXPath() throws XPathExpressionException {
        DOMDocument document = DOMParser.getInstance().parse("<a><b><c>XXXX</c></b></a>", "test", null);
        DOMElement a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        Assertions.assertEquals((Object)"a", (Object)a.getNodeName());
        Assertions.assertTrue((boolean)a.isElement());
        DOMNode b = a.getFirstChild();
        Assertions.assertNotNull((Object)b);
        Assertions.assertEquals((Object)"b", (Object)b.getNodeName());
        Assertions.assertTrue((boolean)b.isElement());
        DOMNode c = b.getFirstChild();
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((Object)"c", (Object)c.getNodeName());
        Assertions.assertTrue((boolean)c.isElement());
        XPath xPath = XPathFactory.newInstance().newXPath();
        Object result = xPath.evaluate("/a/b/c", document, XPathConstants.NODE);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof DOMElement));
        DOMElement elt = (DOMElement)result;
        Assertions.assertEquals((Object)"c", (Object)elt.getNodeName());
        Assertions.assertEquals((Object)c, (Object)elt);
        Assertions.assertTrue((boolean)c.isElement());
    }

    @Test
    public void findTextWithXPath() throws XPathExpressionException {
        DOMDocument document = DOMParser.getInstance().parse("<a><b><c>XXXX</c></b></a>", "test", null);
        XPath xPath = XPathFactory.newInstance().newXPath();
        Object result = xPath.evaluate("/a/b/c/text()", document, XPathConstants.NODE);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof DOMText));
        DOMText text = (DOMText)result;
        Assertions.assertEquals((Object)"XXXX", (Object)text.getData());
        result = xPath.evaluate("/a/b/c/text()", document, XPathConstants.STRING);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"XXXX", (Object)result.toString());
    }

    @Test
    public void siblingTests() throws XPathExpressionException {
        DOMDocument document = DOMParser.getInstance().parse("<a><b><c>XXXX</c><c>YYYY</c></b></a>", "test", null);
        DOMElement a = document.getDocumentElement();
        Assertions.assertNotNull((Object)a);
        DOMNode b = a.getFirstChild();
        Assertions.assertNotNull((Object)b);
        DOMNode c1 = b.getFirstChild();
        Assertions.assertNotNull((Object)c1);
        DOMNode t1 = c1.getFirstChild();
        Assertions.assertTrue((boolean)t1.isText());
        DOMText text1 = (DOMText)t1;
        Assertions.assertEquals((Object)"XXXX", (Object)text1.getData());
        DOMNode c2 = c1.getNextSibling();
        Assertions.assertNotNull((Object)c2);
        DOMNode t2 = c2.getFirstChild();
        Assertions.assertTrue((boolean)t2.isText());
        DOMText text2 = (DOMText)t2;
        Assertions.assertEquals((Object)"YYYY", (Object)text2.getData());
        DOMNode c1Previous = c2.getPreviousSibling();
        Assertions.assertNotNull((Object)c1Previous);
        Assertions.assertEquals((Object)c1, (Object)c1Previous);
    }

    @Test
    public void findElementListWithXPath() throws XPathExpressionException {
        DOMDocument document = DOMParser.getInstance().parse("<a><b><c>XXXX</c><c>YYYY</c></b></a>", "test", null);
        XPath xPath = XPathFactory.newInstance().newXPath();
        Object result = xPath.evaluate("/a/b//c", document, XPathConstants.NODESET);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof NodeList));
        NodeList elts = (NodeList)result;
        Assertions.assertEquals((int)2, (int)elts.getLength());
    }

    @Test
    public void testDOMAsDTD() {
        String content = "<!ELEMENT";
        DOMDocument xml = DOMParser.getInstance().parse(content, "test.xml", null);
        Assertions.assertFalse((boolean)xml.isDTD());
        DOMNode element = xml.getChild(0);
        Assertions.assertTrue((boolean)element.isElement());
        DOMDocument unknown = DOMParser.getInstance().parse(content, "test.unknown", null);
        Assertions.assertFalse((boolean)unknown.isDTD());
        DOMNode unknownElement = unknown.getChild(0);
        Assertions.assertTrue((boolean)unknownElement.isElement());
        DOMDocument dtd = DOMParser.getInstance().parse(content, "test.dtd", null);
        Assertions.assertTrue((boolean)dtd.isDTD());
        DOMNode dtdDocType = dtd.getChild(0);
        Assertions.assertTrue((boolean)dtdDocType.isDoctype());
        DOMNode dtdElementDecl = dtdDocType.getChild(0);
        Assertions.assertTrue((boolean)dtdElementDecl.isDTDElementDecl());
        DOMDocument ent = DOMParser.getInstance().parse(content, "test.ent", null);
        Assertions.assertTrue((boolean)ent.isDTD());
        DOMNode entDocType = ent.getChild(0);
        Assertions.assertTrue((boolean)entDocType.isDoctype());
        DOMNode entElementDecl = entDocType.getChild(0);
        Assertions.assertTrue((boolean)entElementDecl.isDTDElementDecl());
        DOMDocument mod = DOMParser.getInstance().parse(content, "test.mod", null);
        Assertions.assertTrue((boolean)mod.isDTD());
        DOMNode modDocType = mod.getChild(0);
        Assertions.assertTrue((boolean)modDocType.isDoctype());
        DOMNode modElemmodDecl = modDocType.getChild(0);
        Assertions.assertTrue((boolean)modElemmodDecl.isDTDElementDecl());
    }

    @Test
    public void defaultNamespaceURI() {
        String xml = "<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xsi:schemaLocation=\"\r\n       http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n       http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\r\n    \"><bean /><camel:camelContext>";
        DOMDocument dom = DOMParser.getInstance().parse(xml, "test.xml", null);
        DOMElement bean = (DOMElement)dom.getDocumentElement().getFirstChild();
        Assertions.assertNull((Object)bean.getPrefix());
        Assertions.assertEquals((Object)"http://www.springframework.org/schema/beans", (Object)bean.getNamespaceURI());
        DOMElement camel = (DOMElement)bean.getNextSibling();
        Assertions.assertEquals((Object)"camel", (Object)camel.getPrefix());
        Assertions.assertEquals((Object)"http://camel.apache.org/schema/spring", (Object)camel.getNamespaceURI());
    }

    @Test
    public void noDefaultNamespaceURI() {
        String xml = "<b:beans xmlns:b=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xsi:schemaLocation=\"\r\n       http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n       http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\r\n    \"><bean /><camel:camelContext>";
        DOMDocument dom = DOMParser.getInstance().parse(xml, "test.xml", null);
        DOMElement bean = (DOMElement)dom.getDocumentElement().getFirstChild();
        Assertions.assertNull((Object)bean.getPrefix());
        Assertions.assertNull((Object)bean.getNamespaceURI());
        DOMElement camel = (DOMElement)bean.getNextSibling();
        Assertions.assertEquals((Object)"camel", (Object)camel.getPrefix());
        Assertions.assertEquals((Object)"http://camel.apache.org/schema/spring", (Object)camel.getNamespaceURI());
    }
}

