/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.services.IXMLDocumentProvider;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class XSDURIResolverExtension
implements URIResolverExtension {
    private static final String SCHEMA_FOR_SCHEMA_URI_2001 = "http://www.w3.org/2001/XMLSchema";
    private static final List<CacheResourcesManager.ResourceToDeploy> SCHEMA_URI_2001_RESOURCES = Arrays.asList(new CacheResourcesManager.ResourceToDeploy("http://www.w3.org/2001/XMLSchema.xsd", "schemas/xsd/XMLSchema.xsd"), new CacheResourcesManager.ResourceToDeploy("http://www.w3.org/2001/XMLSchema.dtd", "schemas/xsd/XMLSchema.dtd"), new CacheResourcesManager.ResourceToDeploy("http://www.w3.org/2001/datatypes.dtd", "schemas/xsd/datatypes.dtd"));
    private static final String SCHEMA_FOR_NAMESPACE_URI_1998 = "http://www.w3.org/XML/1998/namespace";
    private static final CacheResourcesManager.ResourceToDeploy NAMESPACE_URI_1998_RESOURCE = new CacheResourcesManager.ResourceToDeploy("https://www.w3.org/2001/xml.xsd", "schemas/xsd/xml.xsd");

    public XSDURIResolverExtension(IXMLDocumentProvider documentProvider) {
    }

    @Override
    public String resolve(String baseLocation, String publicId, String systemId) {
        if (SCHEMA_FOR_SCHEMA_URI_2001.equals(publicId)) {
            try {
                for (CacheResourcesManager.ResourceToDeploy resource : SCHEMA_URI_2001_RESOURCES) {
                    CacheResourcesManager.getResourceCachePath(resource);
                }
                return SCHEMA_URI_2001_RESOURCES.get(0).getDeployedPath().toFile().toURI().toString();
            }
            catch (Exception exception) {}
        } else if (SCHEMA_FOR_NAMESPACE_URI_1998.equals(publicId)) {
            try {
                return CacheResourcesManager.getResourceCachePath(NAMESPACE_URI_1998_RESOURCE).toFile().toURI().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String baseLocation;
        String xslFilePath;
        String publicId = resourceIdentifier.getNamespace();
        if ((SCHEMA_FOR_SCHEMA_URI_2001.equals(publicId) || SCHEMA_FOR_NAMESPACE_URI_1998.equals(publicId)) && (xslFilePath = this.resolve(baseLocation = resourceIdentifier.getBaseSystemId(), publicId, null)) != null) {
            return new XMLInputSource(publicId, xslFilePath, xslFilePath);
        }
        return null;
    }
}

