/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.AbstractPositionRequest;
import org.eclipse.lemminx.services.extensions.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

class CompletionRequest
extends AbstractPositionRequest
implements ICompletionRequest {
    private final XMLCompletionSettings completionSettings;
    private final XMLFormattingOptions formattingSettings;
    private Range replaceRange;
    private XMLGenerator generator;
    private boolean hasOpenBracket;
    private boolean addQuotes;

    public CompletionRequest(DOMDocument xmlDocument, Position position, SharedSettings settings, XMLExtensionsRegistry extensionsRegistry) throws BadLocationException {
        super(xmlDocument, position, extensionsRegistry);
        this.formattingSettings = settings.getFormattingSettings();
        this.completionSettings = settings.getCompletionSettings();
    }

    @Override
    protected DOMNode findNodeAt(DOMDocument xmlDocument, int offset) {
        return xmlDocument.findNodeBefore(offset);
    }

    @Override
    public XMLFormattingOptions getFormattingSettings() {
        return this.formattingSettings;
    }

    @Override
    public XMLCompletionSettings getCompletionSettings() {
        return this.completionSettings;
    }

    public void setReplaceRange(Range replaceRange) {
        this.replaceRange = replaceRange;
    }

    @Override
    public Range getReplaceRange() {
        return this.replaceRange;
    }

    @Override
    public XMLGenerator getXMLGenerator() throws BadLocationException {
        if (this.generator == null) {
            this.generator = new XMLGenerator(this.getFormattingSettings(), this.isAutoCloseTags(), this.getLineIndentInfo().getWhitespacesIndent(), this.getLineIndentInfo().getLineDelimiter(), this.isCompletionSnippetsSupported(), 0);
        }
        return this.generator;
    }

    @Override
    public String getFilterForStartTagName(String tagName) {
        if (this.hasOpenBracket) {
            return "<" + tagName;
        }
        return tagName;
    }

    public void setHasOpenBracket(boolean hasOpenBracket) {
        this.hasOpenBracket = hasOpenBracket;
    }

    public void setAddQuotes(boolean addQuotes) {
        this.addQuotes = addQuotes;
    }

    public boolean isAddQuotes() {
        return this.addQuotes;
    }

    @Override
    public String getInsertAttrValue(String value) {
        if (!this.addQuotes) {
            return value;
        }
        String quotation = this.getQuotation();
        return quotation + value + quotation;
    }

    private String getQuotation() {
        String quotation = this.formattingSettings != null ? this.formattingSettings.getQuotationAsString() : null;
        return StringUtils.isEmpty(quotation) ? "\"" : quotation;
    }

    @Override
    public boolean canSupportMarkupKind(String kind) {
        return this.completionSettings != null && this.completionSettings.getCompletionCapabilities() != null && this.completionSettings.getCompletionCapabilities().getCompletionItem() != null && this.completionSettings.getCompletionCapabilities().getCompletionItem().getDocumentationFormat() != null && this.completionSettings.getCompletionCapabilities().getCompletionItem().getDocumentationFormat().contains(kind);
    }

    @Override
    public boolean isCompletionSnippetsSupported() {
        return this.getCompletionSettings().isCompletionSnippetsSupported();
    }

    @Override
    public boolean isAutoCloseTags() {
        return this.getCompletionSettings().isAutoCloseTags();
    }

    @Override
    public InsertTextFormat getInsertTextFormat() {
        return this.isCompletionSnippetsSupported() ? InsertTextFormat.Snippet : InsertTextFormat.PlainText;
    }
}

