/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLParserConfiguration;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.extensions.diagnostics.LSPContentHandler;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLValidator {
    private static final Logger LOGGER = Logger.getLogger(XMLValidator.class.getName());
    private static final String DTD_NOT_FOUND = "Cannot find DTD ''{0}''.\nCreate the DTD file or configure an XML catalog for this DTD.";

    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, ContentModelSettings contentModelSettings, XMLGrammarPool grammarPool, CancelChecker monitor) {
        try {
            XMLValidationSettings validationSettings = contentModelSettings != null ? contentModelSettings.getValidation() : null;
            LSPXMLParserConfiguration configuration = new LSPXMLParserConfiguration(grammarPool, XMLValidator.isDisableOnlyDTDValidation(document), validationSettings);
            if (entityResolver != null) {
                configuration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", entityResolver);
            }
            LSPErrorReporterForXML reporter = new LSPErrorReporterForXML(document, diagnostics);
            boolean externalDTDValid = XMLValidator.checkExternalDTD(document, reporter, (XMLParserConfiguration)configuration);
            SAXParser parser = new SAXParser((XMLParserConfiguration)configuration);
            parser.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)reporter);
            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setContentHandler((ContentHandler)new LSPContentHandler(monitor));
            boolean hasGrammar = document.hasGrammar();
            if (validationSettings == null || validationSettings.isSchema()) {
                XMLValidator.checkExternalSchema(document.getExternalSchemaLocation(), parser);
                parser.setFeature("http://apache.org/xml/features/validation/schema", hasGrammar);
                XMLValidator.warnNoGrammar(document, diagnostics, contentModelSettings);
            } else {
                hasGrammar = false;
            }
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", externalDTDValid);
            parser.setFeature("http://xml.org/sax/features/validation", hasGrammar && externalDTDValid);
            String content = document.getText();
            String uri = document.getDocumentURI();
            XMLValidator.parseXML(content, uri, parser);
        }
        catch (IOException | CancellationException | SAXException validationSettings) {
        }
        catch (CacheResourceDownloadingException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected XMLValidator error", e);
        }
    }

    private static void parseXML(String content, String uri, SAXParser parser) throws SAXException, IOException {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(content));
        inputSource.setSystemId(uri);
        parser.parse(inputSource);
    }

    private static boolean isDisableOnlyDTDValidation(DOMDocument document) {
        if (!document.hasDTD()) {
            return false;
        }
        DOMDocumentType docType = document.getDoctype();
        if (docType.getKindNode() != null) {
            return false;
        }
        return !docType.getChildren().stream().anyMatch(node -> node.isDTDElementDecl() || node.isDTDAttListDecl());
    }

    private static boolean checkExternalDTD(final DOMDocument document, final LSPErrorReporterForXML reporter, XMLParserConfiguration configuration) {
        if (!document.hasDTD()) {
            return true;
        }
        final DOMDocumentType docType = document.getDoctype();
        if (docType.getKindNode() == null) {
            return true;
        }
        int end = document.getDoctype().getEnd();
        String xml = document.getText().substring(0, end);
        xml = xml + "<root/>";
        try {
            XMLEntityManager entityManager = new XMLEntityManager(){

                public String setupCurrentEntity(String name, XMLInputSource xmlInputSource, boolean literal, boolean isExternal) throws IOException, XNIException {
                    try {
                        return super.setupCurrentEntity(name, xmlInputSource, literal, isExternal);
                    }
                    catch (IOException e) {
                        try {
                            Range range = new Range(document.positionAt(docType.getSystemIdNode().getStart()), document.positionAt(docType.getSystemIdNode().getEnd()));
                            reporter.addDiagnostic(range, MessageFormat.format(XMLValidator.DTD_NOT_FOUND, xmlInputSource.getSystemId()), DiagnosticSeverity.Error, DTDErrorCode.dtd_not_found.getCode());
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
            };
            entityManager.reset((XMLComponentManager)configuration);
            SAXParser parser = new SAXParser(configuration);
            parser.setProperty("http://apache.org/xml/properties/internal/entity-manager", (Object)entityManager);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
            XMLValidator.parseXML(xml, document.getDocumentURI(), parser);
        }
        catch (CancellationException | SAXException entityManager) {
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static void warnNoGrammar(DOMDocument document, List<Diagnostic> diagnostics, ContentModelSettings settings) {
        boolean hasGrammar = document.hasGrammar();
        if (hasGrammar) {
            return;
        }
        DiagnosticSeverity severity = XMLValidationSettings.getNoGrammarSeverity(settings);
        if (severity == null) {
            return;
        }
        if (!hasGrammar) {
            Range range = null;
            DOMElement documentElement = document.getDocumentElement();
            if (documentElement != null) {
                range = XMLPositionUtility.selectStartTagName(documentElement);
            }
            if (range == null) {
                range = new Range(new Position(0, 0), new Position(0, 0));
            }
            diagnostics.add(new Diagnostic(range, "No grammar constraints (DTD or XML Schema).", severity, document.getDocumentURI(), "XML"));
        }
    }

    private static void checkExternalSchema(Map<String, String> result, SAXParser reader) throws SAXNotRecognizedException, SAXNotSupportedException {
        String noNamespaceSchemaLocation;
        if (result != null && (noNamespaceSchemaLocation = result.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) != null) {
            reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)noNamespaceSchemaLocation);
        }
    }
}

