/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.function.BiConsumer;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;

public class DTDElementDecl
extends DTDDeclNode {
    public DTDDeclParameter category;
    public DTDDeclParameter content;

    public DTDElementDecl(int start, int end) {
        super(start, end);
        this.setDeclType(start + 2, start + 9);
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    public String getCategory() {
        return this.category != null ? this.category.getParameter() : null;
    }

    public void setCategory(int start, int end) {
        this.category = this.addNewParameter(start, end);
    }

    public String getContent() {
        return this.content != null ? this.content.getParameter() : null;
    }

    public void setContent(int start, int end) {
        this.content = this.addNewParameter(start, end);
    }

    @Override
    public short getNodeType() {
        return 101;
    }

    public int getEndElementTag() {
        return this.getStart() + "<!ELEMENT".length();
    }

    public DTDDeclParameter getParameterAt(int offset) {
        if (this.isInNameParameter(offset)) {
            return null;
        }
        int start = this.getNameParameter().getEnd();
        int end = this.getEnd();
        String text = this.getOwnerDocument().getText();
        int paramStart = DTDElementDecl.findStartWord(text, start, offset);
        int paramEnd = DTDElementDecl.findEndWord(text, offset, end);
        if (paramStart == -1 || paramEnd == -1) {
            return null;
        }
        return new DTDDeclParameter(this, paramStart, paramEnd);
    }

    @Override
    public DTDDeclParameter getReferencedElementNameAt(int offset) {
        return this.getParameterAt(offset);
    }

    public void collectParameters(DTDDeclParameter target, BiConsumer<DTDDeclParameter, DTDDeclParameter> collector) {
        DTDDeclParameter name = this.getNameParameter();
        if (name == null) {
            return;
        }
        int start = name.getEnd();
        int end = this.getEnd();
        String text = this.getOwnerDocument().getText();
        text.length();
        int wordStart = -1;
        int wordEnd = -1;
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (DTDElementDecl.isValidChar(c)) {
                if (wordStart == -1) {
                    wordStart = i;
                }
            } else if (wordStart != -1) {
                wordEnd = i;
            }
            if (wordStart == -1 || wordEnd == -1) continue;
            boolean check = DTDElementDecl.isMatchName(target.getParameter(), text, wordStart, wordEnd);
            if (check) {
                collector.accept(new DTDDeclParameter(this, wordStart, wordEnd), target);
            }
            wordStart = -1;
            wordEnd = -1;
        }
    }

    private static int findStartWord(String text, int from, int to) {
        int wordStart = -1;
        int length = to - from;
        for (int i = 0; i < length; ++i) {
            if (!DTDElementDecl.isValidChar(text.charAt(to - i))) {
                return wordStart;
            }
            wordStart = to - i;
        }
        return wordStart;
    }

    private static int findEndWord(String text, int from, int to) {
        int wordEnd = -1;
        int length = to - from;
        for (int i = 0; i < length; ++i) {
            if (!DTDElementDecl.isValidChar(text.charAt(from + i))) {
                return wordEnd;
            }
            wordEnd = from + i + 1;
        }
        return wordEnd;
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    private static boolean isMatchName(String searchWord, String text, int wordStart, int wordEnd) {
        int length = wordEnd - wordStart;
        if (searchWord.length() != length) {
            return false;
        }
        for (int j = 0; j < length; ++j) {
            if (searchWord.charAt(j) == text.charAt(wordStart + j)) continue;
            return false;
        }
        return true;
    }
}

