/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.javaexec;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FatJarDetector {
    private final File directory;
    private Result result;

    FatJarDetector(File directory) {
        this.directory = directory;
    }

    public Result scan() {
        if (!this.directory.exists()) {
            return null;
        }
        if (this.result == null) {
            this.result = this.scanDirectory();
        }
        return this.result;
    }

    private Result scanDirectory() {
        List jarOrWars = Optional.ofNullable(this.directory.list((dir, name) -> name.endsWith(".war") || name.endsWith(".jar"))).map(files -> Stream.of(files).filter(Objects::nonNull).map(f -> new File(this.directory, (String)f)).collect(Collectors.toList())).orElse(Collections.emptyList());
        Result selectedJar = null;
        long maxSize = 0L;
        for (File jarOrWar : jarOrWars) {
            try {
                JarFile archive = new JarFile(jarOrWar);
                Throwable throwable = null;
                try {
                    long size;
                    Attributes mainAttributes;
                    String mainClass;
                    Manifest mf = archive.getManifest();
                    if (mf == null || mf.getMainAttributes() == null || (mainClass = (mainAttributes = mf.getMainAttributes()).getValue("Main-Class")) == null || (size = jarOrWar.length()) <= maxSize) continue;
                    maxSize = size;
                    selectedJar = new Result(jarOrWar, mainClass, mainAttributes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (archive == null) continue;
                    if (throwable != null) {
                        try {
                            archive.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    archive.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot examine file " + jarOrWar.getName() + " for the manifest");
            }
        }
        return selectedJar;
    }

    public static final class Result {
        private final File archiveFile;
        private final String mainClass;
        private final Attributes attributes;

        private Result(File archiveFile, String mainClass, Attributes attributes) {
            this.archiveFile = archiveFile;
            this.mainClass = mainClass;
            this.attributes = attributes;
        }

        public File getArchiveFile() {
            return this.archiveFile;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public String getManifestEntry(String key) {
            return this.attributes.getValue(key);
        }
    }
}

