/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.managers.AbstractMavenBasedTest;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MavenBuildSupportTest
extends AbstractMavenBasedTest {
    @Test
    public void testUpdate() throws Exception {
        IProject project = this.importSimpleJavaProject();
        IFile pom = project.getFile("pom.xml");
        URI pomUri = pom.getRawLocationURI();
        String originalPom = ResourceUtils.getContent((URI)pomUri);
        String dependencyLessPom = this.comment(originalPom, "<dependencies>", "</dependencies>");
        ResourceUtils.setContent((URI)pomUri, (String)dependencyLessPom);
        this.waitForBackgroundJobs();
        this.assertNoErrors(project);
        this.projectsManager.updateProject(project);
        this.waitForBackgroundJobs();
        this.assertHasErrors(project);
        ResourceUtils.setContent((URI)pomUri, (String)originalPom);
        this.projectsManager.updateProject(project);
        this.waitForBackgroundJobs();
        this.assertNoErrors(project);
    }

    @Test
    public void testCompileWithErrorProne() throws Exception {
        this.testNonStandardCompilerId("compile-with-error-prone");
    }

    @Test
    public void testCompileWithEclipse() throws Exception {
        this.testNonStandardCompilerId("compile-with-eclipse");
    }

    @Test
    public void testCompileWithEclipseTychoJdt() throws Exception {
        this.testNonStandardCompilerId("compile-with-tycho-jdt");
    }

    @Test
    public void testIgnoreInnerPomChanges() throws Exception {
        IProject project = this.importMavenProject("archetyped");
        Assert.assertEquals((String)"The inner pom should not have been imported", (long)2L, (long)WorkspaceHelper.getAllProjects().size());
        IFile innerPom = project.getFile("src/main/resources/archetype-resources/pom.xml");
        this.preferences.setUpdateBuildConfigurationStatus(Preferences.FeatureStatus.automatic);
        final boolean[] updateTriggered = new boolean[1];
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void scheduled(IJobChangeEvent event) {
                if (event.getJob().getName().contains("Update project")) {
                    updateTriggered[0] = true;
                }
            }
        };
        try {
            Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
            this.projectsManager.fileChanged(innerPom.getRawLocationURI().toString(), ProjectsManager.CHANGE_TYPE.CHANGED);
            this.waitForBackgroundJobs();
            Assert.assertFalse((String)"Update project should not have been triggered", (boolean)updateTriggered[0]);
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    @Test
    public void testBuildHelperSupport() throws Exception {
        IProject project = this.importMavenProject("buildhelped");
        project.build(6, this.monitor);
        this.assertIsJavaProject(project);
        this.assertNoErrors(project);
    }

    protected void testNonStandardCompilerId(String projectName) throws Exception {
        IProject project = this.importMavenProject(projectName);
        this.assertIsJavaProject(project);
        Assert.assertEquals((Object)"1.8", (Object)ProjectUtils.getJavaSourceLevel((IProject)project));
        this.assertNoErrors(project);
    }
}

