/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.AbstractGradleBasedTest;
import org.junit.Assert;
import org.junit.Test;

public class GradleBuildSupportTest
extends AbstractGradleBasedTest {
    @Test
    public void testUpdate() throws Exception {
        IProject project = this.importSimpleJavaProject();
        IFile gradle = project.getFile("build.gradle");
        URI gradleUri = gradle.getRawLocationURI();
        String originalGradle = ResourceUtils.getContent((URI)gradleUri);
        URI newGradleUri = project.getFile("build2.gradle").getRawLocationURI();
        String newGradle = ResourceUtils.getContent((URI)newGradleUri);
        ResourceUtils.setContent((URI)gradleUri, (String)newGradle);
        this.waitForBackgroundJobs();
        this.assertNoErrors(project);
        this.projectsManager.updateProject(project);
        this.waitForBackgroundJobs();
        this.assertHasErrors(project);
        Assert.assertEquals((Object)"1.8", (Object)ProjectUtils.getJavaSourceLevel((IProject)project));
        ResourceUtils.setContent((URI)gradleUri, (String)originalGradle);
        this.projectsManager.updateProject(project);
        this.waitForBackgroundJobs();
        this.assertNoErrors(project);
        Assert.assertEquals((Object)"1.7", (Object)ProjectUtils.getJavaSourceLevel((IProject)project));
    }
}

