/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.correction;

import java.util.Hashtable;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ls.core.internal.correction.AbstractQuickFixTest;
import org.eclipse.jdt.ls.core.internal.correction.TestOptions;
import org.junit.Before;
import org.junit.Test;

public class ReturnTypeQuickFixTest
extends AbstractQuickFixTest {
    private IJavaProject fJProject1;
    private IPackageFragmentRoot fSourceFolder;

    @Before
    public void setup() throws Exception {
        this.fJProject1 = this.newEmptyProject();
        Hashtable<String, String> options = TestOptions.getDefaultOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", "error");
        this.fJProject1.setOptions(options);
        this.fSourceFolder = this.fJProject1.getPackageFragmentRoot((IResource)this.fJProject1.getProject().getFolder("src"));
    }

    @Test
    public void testVoidMethodReturnsValue() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(Object o) {\n");
        buf.append("        return new Object();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object foo(Object o) {\n");
        buf.append("        return new Object();\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected(this, "Change method return type to 'Object'", buf.toString());
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(Object o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected(this, "Change to 'return;'", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMethodReturnsVoid() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object foo(Object o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object foo(Object o) {\n");
        buf.append("        return o;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected(this, "Change return statement", buf.toString());
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(Object o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected(this, "Change return type to 'void'", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testMissingReturnType() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public foo(Object o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(Object o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected(this, "Set method return type to 'void'", buf.toString());
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public E(Object o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected(this, "Change to constructor", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }

    @Test
    public void testShouldReturn() throws Exception {
        IPackageFragment pack1 = this.fSourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object foo(Object o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object foo(Object o) {\n");
        buf.append("        return o;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e1 = new AbstractQuickFixTest.Expected(this, "Change return statement", buf.toString());
        buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(Object o) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        AbstractQuickFixTest.Expected e2 = new AbstractQuickFixTest.Expected(this, "Change return type to 'void'", buf.toString());
        this.assertCodeActions(cu, e1, e2);
    }
}

