/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;

public class SimpleLogListener
implements ILogListener {
    private List<IStatus> messages = new ArrayList<IStatus>();

    public void logging(IStatus status, String plugin) {
        this.messages.add(status);
    }

    public List<IStatus> getStatuses() {
        return this.messages;
    }

    public List<String> getErrors() {
        return this.getMessages(4);
    }

    public List<String> getInfos() {
        return this.getMessages(1);
    }

    public List<String> getWarnings() {
        return this.getMessages(2);
    }

    public List<String> getMessages(int severity) {
        return this.getStatuses().stream().filter(s -> s.getSeverity() == severity).map(this::convert).collect(Collectors.toList());
    }

    private String convert(IStatus status) {
        StringBuilder s = new StringBuilder(status.getMessage());
        if (status.getException() != null) {
            String stackTrace = Throwables.getStackTraceAsString((Throwable)status.getException());
            s.append("\n");
            s.append(stackTrace);
        }
        return s.toString();
    }
}

