/*******************************************************************************
 * Copyright (c) 2017 Red Hat Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Red Hat Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.ls.core.internal;

import java.io.IOException;

import org.eclipse.jdt.ls.core.internal.ConnectionStreamFactory.SocketStreamProvider;
import org.eclipse.jdt.ls.core.internal.ConnectionStreamFactory.StdIOStreamProvider;
import org.eclipse.jdt.ls.core.internal.ConnectionStreamFactory.StreamProvider;
import org.junit.Assert;
import org.junit.Test;

/**
 *
 */
public class ConnectionStreamFactoryTest {

	@Test
	public void testStdIOSelection(){
		checkStreamProvider(StdIOStreamProvider.class);
	}

	@Test
	public void testSocketSelection(){
		System.setProperty("CLIENT_PORT", "10001");
		checkStreamProvider(SocketStreamProvider.class);
		System.clearProperty("CLIENT_PORT");
	}

	@Test
	public void testStdInOut() throws IOException {
		ConnectionStreamFactory tested = new ConnectionStreamFactory();
		Assert.assertSame(tested.getInputStream(), JavaLanguageServerPlugin.getIn());
		Assert.assertSame(tested.getOutputStream(), JavaLanguageServerPlugin.getOut());
		Assert.assertNotSame(tested.getInputStream(), System.in);
		Assert.assertNotSame(tested.getOutputStream(), System.out);
		System.out.println("test");
		Assert.assertTrue(tested.getInputStream().available() == 0);
	}

	private void checkStreamProvider(Class<? extends StreamProvider> providerClass){
		ConnectionStreamFactory tested = new ConnectionStreamFactory();
		StreamProvider provider = tested.getSelectedStream();
		Assert.assertSame(providerClass, provider.getClass());
	}


}
