/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.ls.core.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.ls.core.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ModifierCorrectionSubProcessor {
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;
    public static final int TO_NON_FINAL = 5;
    public static final String KEY_MODIFIER = "modifier";

    public static void installLinkedVisibilityProposals(LinkedProposalModel linkedProposalModel, ASTRewrite rewrite, List<IExtendedModifier> modifiers, boolean inInterface, String groupId) {
        Modifier modifier = ModifierCorrectionSubProcessor.findVisibilityModifier(modifiers);
        if (modifier != null) {
            int[] nArray;
            int selected = modifier.getKeyword().toFlagValue();
            LinkedProposalPositionGroup positionGroup = linkedProposalModel.getPositionGroup(groupId, true);
            positionGroup.addPosition(rewrite.track((ASTNode)modifier), false);
            positionGroup.addProposal(new ModifierLinkedModeProposal(selected, 10));
            if (inInterface) {
                int[] nArray2 = new int[2];
                nArray = nArray2;
                nArray2[0] = 1;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 1;
                nArray3[2] = 4;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] flagValues = nArray;
            int i = 0;
            while (i < flagValues.length) {
                if (flagValues[i] != selected) {
                    positionGroup.addProposal(new ModifierLinkedModeProposal(flagValues[i], 9 - i));
                }
                ++i;
            }
        }
    }

    public static void installLinkedVisibilityProposals(LinkedProposalModel linkedProposalModel, ASTRewrite rewrite, List<IExtendedModifier> modifiers, boolean inInterface) {
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(linkedProposalModel, rewrite, modifiers, inInterface, KEY_MODIFIER);
    }

    private static Modifier findVisibilityModifier(List<IExtendedModifier> modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Modifier modifier;
            Modifier.ModifierKeyword keyword;
            IExtendedModifier curr = modifiers.get(i);
            if (curr instanceof Modifier && ((keyword = (modifier = (Modifier)curr).getKeyword()) == Modifier.ModifierKeyword.PUBLIC_KEYWORD || keyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD || keyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD)) {
                return modifier;
            }
            ++i;
        }
        return null;
    }

    private static class ModifierLinkedModeProposal
    extends LinkedProposalPositionGroup.Proposal {
        private final int fModifier;

        public ModifierLinkedModeProposal(int modifier, int relevance) {
            super(null, relevance);
            this.fModifier = modifier;
        }

        @Override
        public String getAdditionalProposalInfo() {
            return this.getDisplayString();
        }

        @Override
        public String getDisplayString() {
            if (this.fModifier == 0) {
                return CorrectionMessages.ModifierCorrectionSubProcessor_default_visibility_label;
            }
            return Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString();
        }

        @Override
        public TextEdit computeEdits(int offset, LinkedPosition currentPosition, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            try {
                IDocument document = currentPosition.getDocument();
                MultiTextEdit edit = new MultiTextEdit();
                int documentLen = document.getLength();
                if (this.fModifier == 0) {
                    int end;
                    int k = end = currentPosition.offset + currentPosition.length;
                    while (k < documentLen && IndentManipulation.isIndentChar((char)document.getChar(k))) {
                        ++k;
                    }
                    edit.addChild((TextEdit)new ReplaceEdit(end, k - end, new String()));
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, new String()));
                } else {
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString()));
                    int end = currentPosition.offset + currentPosition.length;
                    if (end < documentLen && !Character.isWhitespace(document.getChar(end))) {
                        edit.addChild((TextEdit)new ReplaceEdit(end, 0, String.valueOf(' ')));
                    }
                }
                return edit;
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ls.core", 4, e.getMessage(), (Throwable)e));
            }
        }
    }
}

