/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.preferences.MavenConfigurationImpl;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;

public class MavenProjectImporter
extends AbstractProjectImporter {
    public static final String POM_FILE = "pom.xml";
    private Set<MavenProjectInfo> projectInfos = null;
    private IProjectConfigurationManager configurationManager;

    public MavenProjectImporter() {
        this(MavenPlugin.getProjectConfigurationManager());
    }

    public MavenProjectImporter(IProjectConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    @Override
    public boolean applies(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager != null && !preferencesManager.getPreferences().isImportMavenEnabled()) {
            return false;
        }
        Set<MavenProjectInfo> files = this.getMavenProjectInfo(monitor);
        if (files != null) {
            Iterator<MavenProjectInfo> iter = files.iterator();
            while (iter.hasNext()) {
                File dir;
                MavenProjectInfo projectInfo = iter.next();
                File file = dir = projectInfo.getPomFile() == null ? null : projectInfo.getPomFile().getParentFile();
                if (dir == null || !this.exclude(dir.toPath())) continue;
                iter.remove();
            }
        }
        return files != null && !files.isEmpty();
    }

    private boolean exclude(java.nio.file.Path path) {
        List<String> javaImportExclusions = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaImportExclusions();
        if (javaImportExclusions != null) {
            for (String pattern : javaImportExclusions) {
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
                if (!matcher.matches(path)) continue;
                return true;
            }
        }
        return false;
    }

    synchronized Set<MavenProjectInfo> getMavenProjectInfo(IProgressMonitor monitor) throws OperationCanceledException {
        if (this.projectInfos == null) {
            this.projectInfos = this.collectMavenProjectInfo(monitor);
        }
        return this.projectInfos;
    }

    Set<MavenProjectInfo> collectMavenProjectInfo(IProgressMonitor monitor) throws OperationCanceledException {
        MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
        return this.getMavenProjects(this.getProjectDirectory(), modelManager, monitor);
    }

    @Override
    public void reset() {
        this.projectInfos = null;
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        JavaLanguageServerPlugin.logInfo("Importing Maven project(s)");
        MavenConfigurationImpl configurationImpl = (MavenConfigurationImpl)MavenPlugin.getMavenConfiguration();
        configurationImpl.setDownloadSources(true);
        configurationImpl.setNotCoveredMojoExecutionSeverity(ProblemSeverity.ignore.toString());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<MavenProjectInfo> files = this.getMavenProjectInfo((IProgressMonitor)subMonitor.split(5));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
        LinkedHashSet<MavenProjectInfo> toImport = new LinkedHashSet<MavenProjectInfo>();
        long lastWorkspaceStateSaved = this.getLastWorkspaceStateModified();
        for (MavenProjectInfo projectInfo : files) {
            File pom = projectInfo.getPomFile();
            IContainer container = root.getContainerForLocation((IPath)new Path(pom.getAbsolutePath()));
            if (container == null) {
                toImport.add(projectInfo);
                continue;
            }
            IProject project = container.getProject();
            if (ProjectUtils.isMavenProject(project)) {
                projects.add(container.getProject());
                continue;
            }
            if (project == null) continue;
            toImport.add(projectInfo);
        }
        if (!toImport.isEmpty()) {
            ProjectImportConfiguration importConfig = new ProjectImportConfiguration();
            this.configurationManager.importProjects(toImport, importConfig, (IProgressMonitor)subMonitor.split(95));
        }
        this.updateProjects(projects, lastWorkspaceStateSaved, monitor);
    }

    private long getLastWorkspaceStateModified() {
        File workspaceStateFile = MavenPluginActivator.getDefault().getMavenProjectManager().getWorkspaceStateFile();
        return workspaceStateFile.lastModified();
    }

    private File getProjectDirectory() {
        return this.rootFolder;
    }

    private void updateProjects(final Collection<IProject> projects, long lastWorkspaceStateSaved, IProgressMonitor monitor) throws CoreException {
        if (projects.isEmpty()) {
            return;
        }
        Iterator<IProject> iterator = projects.iterator();
        while (iterator.hasNext()) {
            IProject project = iterator.next();
            project.open(monitor);
            project.refreshLocal(2, monitor);
            if (this.needsMavenUpdate(project, lastWorkspaceStateSaved)) continue;
            iterator.remove();
        }
        if (projects.isEmpty()) {
            return;
        }
        new WorkspaceJob("Update Maven project configuration"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                for (IProject project : projects) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    JavaLanguageServerPlugin.logInfo("Updating project configuration for Maven project " + project.getName());
                    MavenUpdateRequest request = new MavenUpdateRequest(project, MavenPlugin.getMavenConfiguration().isOffline(), true);
                    MavenProjectImporter.this.configurationManager.updateProjectConfiguration(request, monitor);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private boolean needsMavenUpdate(IProject project, long lastWorkspaceStateSaved) {
        return project.getFile(POM_FILE).getLocalTimeStamp() > lastWorkspaceStateSaved;
    }

    private Set<MavenProjectInfo> getMavenProjects(File directory, MavenModelManager modelManager, IProgressMonitor monitor) throws OperationCanceledException {
        if (directory == null) {
            return Collections.emptySet();
        }
        try {
            LocalProjectScanner scanner = new LocalProjectScanner(directory.getParentFile(), directory.toString(), false, modelManager);
            scanner.run(monitor);
            return this.collectProjects(scanner.getProjects());
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    public boolean isMavenProject() {
        return this.isMavenProject(this.getProjectDirectory());
    }

    private boolean isMavenProject(File dir) {
        if (!this.isReadable(dir) || !dir.isDirectory()) {
            return false;
        }
        return this.isReadable(new File(dir, POM_FILE));
    }

    private boolean isReadable(File destination) {
        return destination != null && destination.canRead();
    }

    public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
        return new LinkedHashSet<MavenProjectInfo>(){
            private static final long serialVersionUID = 1L;

            public Set<MavenProjectInfo> collectProjects(Collection<MavenProjectInfo> projects) {
                for (MavenProjectInfo projectInfo : projects) {
                    this.add(projectInfo);
                    this.collectProjects(projectInfo.getProjects());
                }
                return this;
            }
        }.collectProjects(projects);
    }
}

