/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.gradle.tooling.GradleConnector;

public class GradleProjectImporter
extends AbstractProjectImporter {
    public static final String GRADLE_HOME = "GRADLE_HOME";
    private static final String BUILD_GRADLE_DESCRIPTOR = "build.gradle";
    protected static final GradleDistribution DEFAULT_DISTRIBUTION = GradleDistribution.fromBuild();
    private Collection<Path> directories;

    @Override
    public boolean applies(IProgressMonitor monitor) throws CoreException {
        if (this.rootFolder == null) {
            return false;
        }
        PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferencesManager != null && !preferencesManager.getPreferences().isImportGradleEnabled()) {
            return false;
        }
        if (this.directories == null) {
            BasicFileDetector gradleDetector = new BasicFileDetector(this.rootFolder.toPath(), BUILD_GRADLE_DESCRIPTOR).includeNested(false).addExclusions("**/build");
            this.directories = gradleDetector.scan(monitor);
        }
        return !this.directories.isEmpty();
    }

    @Override
    public void importToWorkspace(IProgressMonitor monitor) throws CoreException {
        if (!this.applies(monitor)) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        JavaLanguageServerPlugin.logInfo("Importing Gradle project(s)");
        int projectSize = this.directories.size();
        subMonitor.setWorkRemaining(projectSize);
        this.directories.forEach(d -> this.importDir((Path)d, monitor));
        subMonitor.done();
    }

    private void importDir(Path rootFolder, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        this.startSynchronization(rootFolder, monitor);
    }

    public static GradleDistribution getGradleDistribution(Path rootFolder) {
        GradleDistribution distribution = DEFAULT_DISTRIBUTION;
        if (Files.exists(rootFolder.resolve("gradlew"), new LinkOption[0])) {
            distribution = GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.WRAPPER, null).toGradleDistribution();
        } else {
            File gradleHomeFile = GradleProjectImporter.getGradleHomeFile();
            if (gradleHomeFile != null) {
                distribution = GradleDistribution.forLocalInstallation((File)gradleHomeFile);
            }
        }
        return distribution;
    }

    public static File getGradleHomeFile() {
        Map<String, String> env = System.getenv();
        Properties sysprops = System.getProperties();
        return GradleProjectImporter.getGradleHomeFile(env, sysprops);
    }

    public static File getGradleHomeFile(Map<String, String> env, Properties sysprops) {
        File gradleHomeFile;
        String gradleHome = env.get(GRADLE_HOME);
        if (gradleHome == null || !new File(gradleHome).isDirectory()) {
            gradleHome = sysprops.getProperty(GRADLE_HOME);
        }
        if (gradleHome != null && (gradleHomeFile = new File(gradleHome)).isDirectory()) {
            return gradleHomeFile;
        }
        return null;
    }

    protected void startSynchronization(Path rootFolder, IProgressMonitor monitor) {
        File location = rootFolder.toFile();
        boolean shouldSynchronize = GradleProjectImporter.shouldSynchronize(location);
        List<IProject> projects = ProjectUtils.getGradleProjects();
        for (IProject project : projects) {
            File projectDir;
            File file = projectDir = project.getLocation() == null ? null : project.getLocation().toFile();
            if (!location.equals(projectDir)) continue;
            shouldSynchronize = GradleProjectImporter.checkGradlePersistence(shouldSynchronize, project, projectDir);
            break;
        }
        if (shouldSynchronize) {
            boolean overrideWorkspaceSettings = GradleProjectImporter.getGradleHomeFile() != null;
            GradleDistribution distribution = GradleProjectImporter.getGradleDistribution(rootFolder);
            BuildConfiguration configuration = CorePlugin.configurationManager().createBuildConfiguration(location, overrideWorkspaceSettings, distribution, null, false, false, false);
            GradleBuild build = CorePlugin.gradleWorkspaceManager().getGradleBuild(configuration);
            build.getModelProvider().fetchEclipseGradleProjects(FetchStrategy.LOAD_IF_NOT_CACHED, GradleConnector.newCancellationTokenSource().token(), monitor);
            build.synchronize(NewProjectHandler.IMPORT_AND_MERGE);
        }
    }

    public static boolean shouldSynchronize(File location) {
        boolean shouldSynchronize = true;
        List<IProject> projects = ProjectUtils.getGradleProjects();
        for (IProject project : projects) {
            File projectDir;
            File file = projectDir = project.getLocation() == null ? null : project.getLocation().toFile();
            if (!location.equals(projectDir)) continue;
            shouldSynchronize = GradleProjectImporter.checkGradlePersistence(shouldSynchronize, project, projectDir);
            break;
        }
        return shouldSynchronize;
    }

    private static boolean checkGradlePersistence(boolean shouldSynchronize, IProject project, File projectDir) {
        File persistentFile;
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
        if (model.isPresent() && (persistentFile = CorePlugin.getInstance().getStateLocation().append("project-preferences").append(project.getName()).toFile()).exists()) {
            final long modified = persistentFile.lastModified();
            if (projectDir.exists()) {
                File[] files = projectDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (name != null && name.endsWith(".gradle")) {
                            return new File(dir, name).lastModified() > modified;
                        }
                        return false;
                    }
                });
                shouldSynchronize = files != null && files.length > 0;
            }
        }
        return shouldSynchronize;
    }

    @Override
    public void reset() {
    }
}

